<?php

use backend\models\ItEasyMarketer;
use backend\models\ItEasyWarehouse;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyMarketerPublisher $model */
/** @var yii\widgets\ActiveForm $form */
?>
<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>marketer-publisher"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->
    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        <?= Html::encode($this->title) ?>
                    </div>
                    <p class="mg-b-20">Please create marketer publisher according to you !!</p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row row-xs">
                            <div class="col-md-4">


                                <?= $form->field($model, 'it_easy_marketer_id')->dropDownList(
                                    ArrayHelper::map(ItEasyMarketer::find()->select(['it_easy_id', 'it_easy_marketer_name'])->where(['it_easy_marketer_status' => 'Active'])->asArray()->all(), 'it_easy_id', 'it_easy_marketer_name'),
                                    [
                                        'prompt' => 'Please Select'
                                    ]
                                ) ?>

                            </div>
                            <div class="col-md-4">
                                <?= $form->field($model, 'it_easy_publisher_name')->textInput(['maxlength' => true]) ?>
                            </div>
                            <div class="col-md-4 mg-t-10 mg-md-t-0">
                                <?= $form->field($model, 'it_easy_status')->dropDownList(['Active' => 'Active', 'Blocked' => 'Blocked',], ['prompt' => '']) ?>
                            </div>


                        </div>

                        <div class="row row-xs">
                            <div class="col-md-2 mt-4 mt-xl-0" style="margin-top:30px !important;">
                                <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                            </div>


                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>
    <?php ActiveForm::end(); ?>

</div>