<?php

use backend\models\ItEasyMarketerPublisher;
use backend\models\ItEasyMarketer;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyMarketerPublisherSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Marketer Publishers';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Marketer Publisher', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_marketer_id')->dropDownList(
                                    ArrayHelper::map(ItEasyMarketer::find()->select(['it_easy_id', 'it_easy_marketer_name'])->where(['it_easy_marketer_status' => 'Active'])->asArray()->all(), 'it_easy_id', 'it_easy_marketer_name'),
                                    [
                                        'prompt' => 'Please Select Marketer' 
                                    ]
                                )->label(false)  ?>
                            </div>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_publisher_name')->textInput(['maxlength' => true,'placeholder'=>'Publisher Name...'])->label(false) ?>
                            </div>
                           
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>

                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                // 'it_easy_marketer_id',
                                'it_easy_publisher_name',
                                'it_easy_status',
                                // 'created_time',
                                //'updated_time',
                                //'created_by',
                                //'updated_by',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyMarketerPublisher $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>