<?php

use backend\models\ItEasyMarketer;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyMarketerSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Marketers';
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Marketer', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                        
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_marketer_username')->textInput(['maxlength' => true, 'placeholder' => 'Search Username....'])->label(false); ?>
                            </div>
                          <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_marketer_api_type')->dropDownList(['Carl'=>'Carl','Rest'=>'Rest','Soap'=>'Soap'], ['prompt' => 'Select Api Type'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_marketer_api_method')->dropDownList(['Post'=>'Post','Get'=>'Get','Delete'=>'Delete','Patch'=>'Patch'], ['prompt' => 'Select Api Method'])->label(false); ?>
                            </div>
                            
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_marketer_status')->dropDownList(['Active' => 'Active', 'Blocked' => 'Blocked'],['prompt' => 'Search by Status'])->label(false); ?>
                            </div>
                           
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>

                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                               // 'it_easy_marketer_name',
                                'it_easy_marketer_username',
                               'it_easy_marketer_type',
                                'it_easy_marketer_api_url:url',
                               
                                //'it_easy_marketer_password',
                                'it_easy_marketer_api_method',
                                'it_easy_marketer_api_type',
                                'it_easy_marketer_status',
                                //'created_time',
                                //'created_by',
                                //'updated_time',
                                //'updated_by',
                                [
                                    'class' => ActionColumn::className(),
                                    'template'=>'{update}',
                                    'urlCreator' => function ($action, ItEasyMarketer $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>

                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>

