<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Publisher Analysis';
$this->params['breadcrumbs'][] = $this->title;
// echo "<pre>"; print_r($searchModel); die;

?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 22px;
      margin-top: 13px;
      margin-bottom: 15px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
                

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <div class="row row-sm">
        <div class="col-xl-12 col-md-12">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                
                  <div class="col-md-2">
                    <?php if((Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5')){ ?>
                        <?= $formsearch->field($searchModel, 'it_easy_assigned_by')->dropDownList($tl_data, [ 'prompt' => 'Search by TL Name'])->label(false); ?>

                      <?php } ?>
                    </div>
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_assigned_to')->dropDownList($agent_data, [ 'prompt' => 'Search by Agent Name'])->label(false); ?>
                    </div>

                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_first_status')->dropDownlist(['Lead' => 'Lead', 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by First Status'])->label(false); ?>
                    </div>

                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m').'-01' : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2" style="float: right;">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>



    <br>
    <div class="row row-sm">
      <div class="col-md-12 col-lg-12  col-xl-12 col-sm-12" style="padding: 0px 22px;">
        <div class="card" style="padding: 0px 22px;">
          <div class="card-header">
            <div class="d-flex justify-content-between">
              <h4 class="card-title" style="font-family: system-ui;font-size: 18px;">Publisher Wise Analysis Data</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <p class="tx-12 tx-gray-500 mb-0">In this row, due to multiple products, the assigned order count can be high, so you can check on the particular product that How many orders have I made for the product and what has been its performance?</p>
          </div><!-- card-header -->
          <div class="card-body p-0" style="margin-bottom: 30px;">

            <table class="table card-table country-table mb-0">
              <tbody>
                <tr>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Publisher Name</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Total Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Total Order Value</td>
                  
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Ticket Size</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Confirm Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Confirm Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Dispatch Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Dispatch Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Delivered Order</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">Delivered Total</td>
                  <td style="font-size: 18px;font-family: system-ui;text-align: center;">RTO Order</td>
                </tr>
            <?php if(!empty($agentwise_product_report)){
              foreach ($agentwise_product_report as $key => $state_report) {
                
                 if(!empty($state_report['confirm_count'])){  
                $confirm_percentage = round(($state_report['confirm_count']  / $state_report['total_assign'] ) * 100);
                 }else{
                     $confirm_percentage = '0';
                 }
                if(!empty($state_report['confirm_count'])){
                $dispatch_percentage = round(($state_report['dispatched_order_count']  / $state_report['confirm_count'] ) * 100);
                }else{
                  $dispatch_percentage = '0';
                }  
                if(!empty($state_report['confirm_count'])){
                $delivered_percentage = round(($state_report['delivered_order_count']  / $state_report['confirm_count'] ) * 100);
                }else{
                  $delivered_percentage = '0';
                }
                if(!empty($state_report['confirm_count'])){
                $rto_percentage = round(($state_report['rto_order_count']  / $state_report['confirm_count'] ) * 100);
                }else{
                  $rto_percentage = '0';
                }

         ?>
                <tr>
                  <td style="text-align: center;"><b style="font-size:18px;"><?= !empty($state_report['it_easy_marketer_publisher']) ? $state_report['it_easy_marketer_publisher'] : ''; ?></b></td>
                  <td style="text-align: center;"><?= !empty( $state_report['total_assign']) ? $state_report['total_assign'] : ''; ?></td>
                  <td style="text-align: center;"><?= !empty( $state_report['ordered_ammount']) ? $state_report['ordered_ammount'] : ''; ?></td>
                  
                  <td style="text-align: center;"><?= !empty($state_report['average_ticket_size']) ? $state_report['average_ticket_size'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['confirm_count']) ? $state_report['confirm_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($confirm_percentage < 75){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $confirm_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $confirm_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['confirm_sum']) ? $state_report['confirm_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['dispatched_order_count']) ? $state_report['dispatched_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($dispatch_percentage < 95){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $dispatch_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $dispatch_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['dispatched_order_sum']) ? $state_report['dispatched_order_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['delivered_order_count']) ? $state_report['delivered_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($delivered_percentage < 75){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $delivered_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $delivered_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['delivered_order_sum']) ? $state_report['delivered_order_sum'] : ''; ?>&nbsp;
                
                  </td>
                  <td style="text-align: center;"><?= !empty($state_report['rto_order_count']) ? $state_report['rto_order_count'] : ''; ?>&nbsp;&nbsp;&nbsp;
                    <?php if($rto_percentage > 20){ ?>
                    <span class="text-danger"><i class="fe fe-arrow-down"></i><?= $rto_percentage; ?>%</span>
                    <?php }else{ ?>
                    <span class="text-success fs-15"><i class="fe fe-arrow-up"></i><?= $rto_percentage; ?>%</span>
                    <?php } ?> 
                  </td>
                </tr>
             <?php } } ?>    
              </tbody>
            </table>





            
          </div>
        </div><!-- card -->
      </div>
    </div>


</div>
