<?php

use backend\models\ItEasyMaterialHistory;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyMaterialHistorySearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'It Easy Material Histories';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="it-easy-material-history-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create It Easy Material History', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'it_easy_id',
            'it_easy_vendor_id',
            'it_easy_material_id',
            'it_easy_material_quantity',
            'it_easy_weight_type',
            //'it_easy_per_kg',
            //'it_easy_total_price',
            //'it_easy_gst_amount',
            //'it_easy_gst_type',
            //'it_easy_received_date',
            //'it_easy_received_by',
            //'it_easy_approved_status',
            //'it_easy_buy_month',
            //'it_easy_buy_year',
            //'created_time',
            //'updated_time',
            //'created_by',
            //'updated_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, ItEasyMaterialHistory $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                 }
            ],
        ],
    ]); ?>


</div>
