<?php

use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\web\JsExpression;
use backend\models\ItEasyOrderDispatch;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyCourierPincode;
use kartik\date\DatePicker;
use backend\models\ItEasyOrder;
use kartik\daterange\DateRangePicker;
use common\models\User;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Need to Work on these ORDERS';
$this->params['breadcrumbs'][] = $this->title;


?>

<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<style type="text/css">
    .assignclass{
      float: right;
      margin-top: 50px;
      border: #e2e2e2;
      background-color: #e2e2e2;
      border-radius: 15px;
      padding-top: 18px;
      padding-right: 34px;
    }

      .modal-dialog {
    max-width: 75%;
  }

  .paymentcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 18px;
  }

  .schipingcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 14px;
  }

  .customercard {
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 92%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin: 10px;
    margin-left: 26px;
    margin-left: 43px;
  }
  .customerform{
    overflow-y: scroll;
    overflow-x: hidden;
  }
.producttable{
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
background-color: #cec5f9;
border-radius: 14px;
width: 93%;
margin-left: 22px;
margin-top: 20px;
height: 275px;
padding: 17px;
margin-left: 43px;
}
  .my-styles {
    border: 1px solid black;
    padding: 15px;
}
.my-styles p{
    border: 1px solid black;
    padding: 10px;
    margin: -1px;
}
.my-styles .iconclor{
color: #fff;
background-color: #48a1bb;
border-color: #48a1bb;
padding: 4px;
}
.ordercusop{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 408px;
  margin-left: -1px;
}

h6{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 430px;
  margin-left: -16px;
}
thead, tbody, tfoot, tr, td, th {
  border-color: inherit;
  border-style: solid;
  border-width: 1px;
}
.colorchange{
  color: #fff;
  font-weight: 500;
  padding: 7px;
}
.btncolor{
    background-color: #48a1bb;
    float: right;
}
span{
  margin: 8px;
}
.text-right{
  text-align: right;
}

.ordercount{
  float: right;
background: #50A696;
width: 22px;
height: 22px;
border-radius: 50%;
align-items: center;
text-align: center;
margin-top: -10px;
margin-right: -10px;
cursor: pointer;
font-size:11px;
}
.producttable1{

border-radius: 14px;
width: 93%;

margin-top: 20px;
height: 275px;
padding: 17px;
margin-left: 43px;
}

#duplocateordertbody > tr > td {
  border-color: inherit;
  border-style: solid;
  border-width: 1px;
  /*padding: 10px;*/
  font-size: 12px;
  font-weight: 500;
  text-align: center;
}
.assignclass1{
float: right;
margin-top: 50px;
border: #e2e2e2;
background-color: #e2e2e2;
border-radius: 15px;
padding-top: 18px;
/*padding-right: -3px;*/
width: 98%;
margin-left: 12px;
}
.totalcountbackground{
background-image: linear-gradient(to left, #c6c1c1 0%, gray 100%) !important;
}


</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            <div class="mb-xl-0">

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
            <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_order_number')->textInput(['maxlength' => true, 'placeholder' => 'Order Number....'])->label(false); ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_mobile_number')->textInput(['maxlength' => true, 'placeholder' => 'Mobile Number....'])->label(false); ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_awb_number')->textInput(['maxlength' => true, 'placeholder' => 'AWB Number....'])->label(false); ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_courier_name')->dropDownList($array_helper_courier, [ 'prompt' => 'Search BY Courier Name....'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-3">
                      <?= $form->field($model, 'it_easy_order_status_id')->dropDownlist($order_statusdata, [ 'prompt' => 'Search by Order Status'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_attempt_count')->dropDownList(['1' => '1', '2' => '2', '3' => '3', '4' => '4'], [ 'prompt' => 'Search BY Attempt Count....'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-3">
                      <?= $form->field($model, 'it_easy_order_disposition_id')->dropDownlist($order_dispositiondata,[ 'prompt' => 'Search By Disposition'])->label(false); ?>
                    </div> 
                    
                    <div class="col-md-3">
                      <?= $form->field($model, 'it_easy_ndr_status_id')->dropDownlist($ndr_statusdata, [ 'prompt' => 'Search by NDR Status'])->label(false); ?>
                    </div>
                      
                    
                    <div class="col-md-2">
                        <?= $form->field($model, 'assign_type')->dropDownList(['Assign' => 'Assign', 'Unassign' => 'Unassign'], [ 'prompt' => 'Search by Assign Type'])->label(false); ?>
                    </div>

                    <div class="col-md-2">
                    <?= $form->field($model, 'date_type_filter')->dropDownList([ 'Date Modified' => 'Date Modified', 'Date Added' => 'Date Added', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'], ['prompt' => 'Search by Date Type'])->label(false); ?>
                    </div>
                    <div class="col-md-3">
                    <div class="form-group field-iteasyordersearch-date_from_date">
                    <?= DatePicker::widget([
                                'name' => 'ItEasyNdr[date_from_date]', 
                                'value' => $model->date_from_date,
                                'options' => ['placeholder' => 'From date', 'id' => 'iteasyndr-date_from_date'],
                                'pluginOptions' => [
                                'format' => 'yyyy-mm-dd',
                                'todayHighlight' => true,
                                'autoclose' => true,
                                'placeholder' => 'Search by From date'
                                    ]
                                ]) ?>
                    </div>
                    </div>

                    <div class="col-md-3">
                    <div class="form-group field-iteasyordersearch-date_to_date">
                            <?= DatePicker::widget([
                            'name' => 'ItEasyNdr[date_to_date]', 
                            'value' => $model->date_to_date,
                            'options' => ['placeholder' => 'To date', 'id' => 'iteasyndr-date_to_date'],
                            'pluginOptions' => [
                            'format' => 'yyyy-mm-dd',
                            'todayHighlight' => true,
                            'autoclose' => true,
                                ]
                            ]) ?>
                        </div>
                    </div>
                    
                    <div class="col-md-3">
                      <?php $ndr_dispositiondata['no_disposition'] = "No Disposition";

                         ksort($ndr_dispositiondata);

                         ?>
                      <?= $form->field($model, 'it_easy_ndr_disposition_id')->widget(Select2::classname(), [
                                    'data' => $ndr_dispositiondata,
                                    'language' => 'en',
                                    'options' => ['multiple' => true, 'class' => 'text-start', 'placeholder' => 'Search By NDR Disposition'],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(false) ?>
                    </div>
                          
                    <div class="col-md-1" style="float: right;">
                        <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                    </div>      
					<div class="col-md-1" style="float: right;">
                      <?= Html::submitButton('Export', ['class' => 'btn btn-secondary-gradient btn-block', 'id' => 'order_list_ndr_export_index']) ?>
                    </div>
                    

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                
                
                
                <div class="assignclass1">
                    <?php if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){ ?>
                           <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL ASSIGN</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['assign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                          <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL OFD</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['OFD_count']) ? $today_report['OFD_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                        <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL DELIVERED </h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['delivered_count']) ? $today_report['delivered_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                      <?php }else{ ?>

                               <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL ASSIGN</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['assign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                          <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL Unassign</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['unassign_leads']) ? $today_report['unassign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                        <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL OFD</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['OFD_count']) ? $today_report['OFD_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                        <div class="col-xl-3 col-lg-3 col-md-3 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL DELIVERED </h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['delivered_count']) ? $today_report['delivered_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                   
                          
                        
                    
                      <?php } ?>
                      </div>  
                
                
                
                

                <div class="card-body">
                  <?php $form1 = ActiveForm::begin(['id' => 'assign-ndr','action' => ['assign-ndr', $Params], 'method' => 'get']); ?> 
                <div class="col-md-6 assignclass">
                
                <?php if(Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5'){ ?>
                <p style="margin-left: 12px;font-size: 20px;font-family: initial;">Assign NDR Leads from Here</p>
                <div class="col-md-5">
                <?= $form1->field($model, 'it_easy_ndr_tl')->dropDownList(
                 ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->andWhere(['it_easy_dept_id'=>7])->andWhere(['it_easy_type_id'=>3])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Select NDR TL'])->label(false) ?>
                 </div>
                   <div class="col-md-5">
                <?= $form1->field($model, 'it_easy_ndr_agent')->dropDownList(
                ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->andWhere(['it_easy_dept_id'=>7])->andWhere(['in','it_easy_type_id',[4,5]])->asArray()->all(),'id','it_easy_firstname'),['prompt' => 'Select NDR Agent'])->label(false) ?>
                </div>
                <div class="col-md-1">
                <button type="submit" onclick="getNdrassign()" style="background-color:#ffb174" class="btn btn-dark">Assign</button>
                </div>
                <?php } ?>
                </div>
                 
                    <div class="table-responsive border-top userlist-table">
                       
                        <?= GridView::widget([
                'dataProvider' => $dataProvider,
                // 'filterModel' => $searchModel,
                
                'rowOptions' => function ($model) {
                    
                    return ['style' => 'text-align:center;'];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    ['class' => 'yii\grid\CheckboxColumn'],

                    [
                       'label' => 'Order-Number',
                       'format' => 'raw',
                       'attribute' =>'it_easy_order_number',
                       'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],

                       'value' => function ($model) {
                         	
                            $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                            if(empty($model->it_easy_ndr_tl) && empty($model->it_easy_ndr_agent)){
                                $NDR_Tag = 'Fresh NDR';
                            }else{
                                $NDR_Tag = 'WORKED NDR';
                            }
                            
                            return '<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name.'<br><span style="color:#fcfcfc;">'.$NDR_Tag.'</span>';
                            
                       }
                    ],
                    [
                       'label' => 'Customer-Info',
                       'format' => 'raw',
                       'attribute' =>'it_easy_firstname',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email;
                            
                       }
                    ],

                    [
                       'label' => 'Address',
                       'format' => 'raw',
                       'attribute' =>'it_easy_city',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;
                            
                       }
                    ],


                    [
                       'label' => 'NDR TL/Agent',
                       'format' => 'raw',
                       'attribute' =>'it_easy_assigned_to',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_ndr_tl, $model->it_easy_ndr_agent);
                            return $get_agent_tl_name;
                            
                       }
                    ],
                    [
                       'label' => 'NDR STATUS/Disposition',
                       'format' => 'raw',
                       'attribute' =>'it_easy_ndr_disposition_id',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                         	if(!empty($model->it_easy_ndr_disposition_id)){
                            	$disposition = ItEasyOrder::GetOrderDispositionNamebystatusId($model->it_easy_ndr_disposition_id);
                            }else{
                              	$disposition = '';
                            }
							if(!empty($model->it_easy_ndr_status_id)){
                            	$get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_ndr_status_id);
                            }else{
                              	$get_status_name = '';
                            }
                            if(!empty($model->it_easy_arrange_time)){
                            	$arrange_time = $model->it_easy_arrange_time;
                            }else{
                              	$arrange_time = '';
                            }
                            return $get_status_name .'<br><br>'. $disposition.'<br><br>'. $arrange_time;
                            
                       }
                    ],

                    
                    [
                        'label' => 'Live-Status',
                       'format' => 'raw',
                       'attribute' =>'it_easy_device',
                       'value' => function ($model) {
                            $material_name = ItEasyOrderDispatch::find()->select(['it_easy_id', 'it_easy_order_status', 'it_easy_courier_name', 'it_easy_awb_number'])->where(['it_easy_order_id' => $model->it_easy_order_id ])->asArray()->one(); 
                         	if(!empty($material_name)){
                                return '<b>'.$material_name['it_easy_courier_name'].'<br>'.$material_name['it_easy_awb_number'].'</b><br>'.$material_name['it_easy_order_status'];
                            }else{
                              	return "";
                            }
                       }
                    ],
                    [
                        'label' => 'Created',
                       'format' => 'raw',
                       'attribute' =>'it_easy_created_time',
                       'value' => function ($model) {
                            return date('Y-m-d', strtotime($model->it_easy_created_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_created_time));
                       }
                    ],
                    [
                        'label' => 'Placed Date',
                       'format' => 'raw',
                       'attribute' =>'it_easy_placed_time',
                       'value' => function ($model) {
                         	if(!empty($model->it_easy_placed_time)){
                            	return date('Y-m-d', strtotime($model->it_easy_placed_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_placed_time));
                            }else{
                              	return '';
                            }
                       }
                    ],


                        [
                  'class' => 'yii\grid\ActionColumn',
                  'template' => '{createbutton} {trackhistory}',
                  'buttons' => [
                    'createbutton' => function ($url, $model) {
                      $buttons = "";
                      $buttons .= '<a style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;" class="md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title="Edit Your Order" href="'.BASE_URL.'ndr/update?it_easy_order_id='.$model->it_easy_order_id.'"  target="_blank">Edit</a>';
                      $buttons .= '<a data-toggle="modal" data-target="#vieworder"><button style= "color: #fff;background-color: #5bc0de;border-color: #39b3d7;" href="javascript:void(0)" value="' . $model->it_easy_order_id . '" id="abcd" class="getvieworder btn btn-info btnw btn-sm"><i class="typcn typcn-eye"></i></button></a>';
                      $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#disposition"  style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 102px;background-color:#ef710e" class="adddisposition md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title=""  href="javascript:void(0)" data-modal="modal-1" data-original-title="Add Disposition">Disposition</a>';

                      return $buttons;
                    },
                    'trackhistory' => function ($url, $model) {
                      $buttons = "";
                      $buttons .= '<a style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;" class="md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title="Track Order History" href="'.BASE_URL.'ndr/trackhistory?it_easy_order_id='.$model->it_easy_order_id.'"  target="_blank">Track</a><br>';
                      
                      return $buttons;
                    },
                  ],

                ],
           
                ],
            ]); ?>
                    </div>
                     <?php ActiveForm::end(); ?>
                </div>
            
            </div>
        </div>
        <!--/div-->
    </div>
</div>
<div class="modal fade" id="status" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Add NDR Status</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['ndr/add-status'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="addndrstatusid" class="form-control" name="ItEasyNdr[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_ndr_status_id')->dropDownList(
        ArrayHelper::map(ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->where(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type'=>'NDR'])->asArray()->all(),'it_easy_order_status_id','it_easy_order_status_name'),['prompt' => 'Please Select'])->label('NDR Status') ?>
            </div>
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_comment')->textArea(['maxlength' => true])->label('Comment') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="disposition" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Add NDR Disposition</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['ndr/add-disposition'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="adddispositionid" class="form-control" name="ItEasyNdr[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
         
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_ndr_disposition_id')->dropDownList(
        ArrayHelper::map(ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->where(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type'=>'NDR'])->asArray()->all(),'it_easy_order_disposition_id','it_easy_order_disposition_name'),['prompt' => 'Please Select'])->label('NDR Disposition') ?>
            </div>
            <div class="col-md-12" id='arrangedate'>
            
                     <div class="form-group field-iteasyordersearch-it_easy_arrange_time">
                      <label class="control-label" for="iteasyndr-it_easy_ndr_disposition_id">Arrange Time</label>
                    <?= DatePicker::widget([
                                'name' => 'ItEasyNdr[it_easy_arrange_time]', 
                                'value' => $model->it_easy_arrange_time,
                                'options' => ['placeholder' => 'Date', 'id' => 'iteasyndr-it_easy_arrange_time'],
                                'pluginOptions' => [
                                'format' => 'yyyy-mm-dd',
                                'todayHighlight' => true,
                                'autoclose' => true,
                                'placeholder' => 'Search by From date'
                                    ]
                                ]) ?>
                    </div>
            </div>
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_comment')->textArea(['maxlength' => true])->label('Comment') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>



<div class="modal fade" id="vieworder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;height: 500px;">
      <div class="modal-header">
        <h5>Order#<span id='printordernumber'></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
  
      <div class="modal-body customerform">
        <div class="row">

          <input type="hidden" id="getvieworderid" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard my-styles">
            <div class="col-md-6  my-styles">
              <h6 class="ordercusop"><i class="typcn typcn-shopping-cart"></i> Order Details</h6>
              <p><i class="typcn typcn-shopping-cart iconclor"></i><span  id="storename"></span></p>
              <p><i class="fa fa-calendar iconclor"></i><span  id="createdtime"></span></p>
              <p><i class="fe fe-credit-card iconclor"></i><span  id="paymentmethod"></span></p>
             
              <p><i class="fa fa-globe iconclor"></i><span  id="website"></span></p>
            </div>
            <div class="col-md-6 my-styles">
               <h6 class="ordercusop"><i class="far fa-user"></i> Customer Details</h6>
              <p><i class="far fa-user iconclor"></i><span  id="name"></span></p>
              
              <p><i class="fa fa-envelope iconclor"></i><span  id="email"></span></p>
              <p><i class="fa fa-phone iconclor"></i> <span  id="phone"></span></p>
              <p><i class="fa fa-mobile iconclor"></i> <span  id="mobile"></span></p>
            </div>
        
          </div>
          <div class="row">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard">
                  <h6>Payment Address</h6><br>
                  <div class="row">
                    <span  id="billname"></span>
                    <span  id="billadd1"></span>
                    <span  id="billadd2"></span>
                    <span  id="billcitypin"></span>
                    <span  id="billstate"></span>
                   
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="schipingcard">
                  <h6>Shiping Address</h6><br>
                  <div class="row">
                  <span  id="shipname"></span>
                  <span  id="shipadd1"></span>
                  <span  id="shipadd2"></span>
                  <span  id="shipcitypin"></span>
                  <span  id="shipstate"></span>
              </div>
            </div>
          </div>
        </div>
        </div>

        <div class="row producttable">
          <div class="col-md-12">
          <table id='mltipleproduct' style="width: 105%;margin-left: -22px;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Product</span></td>
      
                <td><span class="colorchange">Quantity</span></td>
                <td><span class="colorchange">Unit Price</span></td>
                <td><span class="colorchange">Total</span></td></tr>
            </thead>
            <tbody id='tbodyprint'>
      
            </tbody>
            <tfoot id='tfootprint'>
                
            </tfoot>
          </table> 
          </div>         
        </div> 

            <div class="row" style="margin-top: 20px;">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard" style="min-height: 347px;">
                  <h6>Order History</h6><br>
                  <div class="row">
                      
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
                
            
            </thead>
            <tbody id="addstatustable">
            
            </tbody>
        
          </table> 

            </div>
          </div>
        </div>

             <div class="col-md-6">
          <div class="schipingcard" style="min-height: 347px;">
            <h6>Disposition Order History</h6><br>
            <div class="row">
                              
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
          
            
            </thead>
            <tbody id="dispostaustable">
         
            </tbody>
        
          </table> 
              </div>
            </div>
          </div>
        </div>
        </div> 
      </div>
    </div>
  </div>
</div>
</div>

