<?php

use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\web\JsExpression;
use backend\models\ItEasyOrderDispatch;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyCourierPincode;
use kartik\date\DatePicker;
use backend\models\ItEasyOrder;
use kartik\daterange\DateRangePicker;
use common\models\User;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Track ORDERS Via AWB Numbers';
$this->params['breadcrumbs'][] = $this->title;


?>

<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }

    .assignclass{
      float: right;
      margin-top: 50px;
      border: #e2e2e2;
      background-color: #e2e2e2;
      border-radius: 15px;
      padding-top: 18px;
      padding-right: 34px;
      margin-bottom: 8px;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            <div class="mb-xl-0">

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-md-12 col-lg-12 col-xl-12">
          <div class="card card-table-two">
            <div class="d-flex justify-content-between">
              <h3 class="mb-1" style="font-family: 'Roboto';">(<?= !empty($order_dispatch_details->it_easy_order_number) ? $order_dispatch_details->it_easy_order_number : ''; ?>) <?= !empty($order_dispatch_details->it_easy_courier_name) ? $order_dispatch_details->it_easy_courier_name : ''; ?> : <?= !empty($order_dispatch_details->it_easy_awb_number) ? $order_dispatch_details->it_easy_awb_number : ''; ?>  <?= !empty($order_dispatch_details->it_easy_return_awb) ? $order_dispatch_details->it_easy_return_awb : ''; ?></h3>
             
              <br>
              <br>
              <br>
            </div>
            
            <div class="table-responsive country-table">
              <table class="table table-striped table-bordered mb-0 text-sm-nowrap text-lg-nowrap text-xl-nowrap">
                <thead>
                  <tr>
                    <th class="wd-lg-13p tx-center" style="font-family: 'Roboto';"><h5>Order Number</h5></th>
                    <th class="wd-lg-12p tx-center" style="font-family: 'Roboto';"><h5>AWB Number</h5></th>
                    <th class="wd-lg-15p tx-center" style="font-family: 'Roboto';"><h5>Location</h5></th>
                    <th class="wd-lg-15p tx-center" style="font-family: 'Roboto';"><h5>Order Status</h5></th>
                    <th class="wd-lg-30p tx-center" style="font-family: 'Roboto';"><h5>Courier Comment</h5></th>
                    <th class="wd-lg-15p tx-center" style="font-family: 'Roboto';"><h5>Courier Time</h5></th>
                  </tr>
                </thead>
                <tbody>
                  
                  <?php if(!empty($trackModel)){ 
                    //   echo "<pre>"; print_r($trackModel); die;
                  	foreach($trackModel as $key => $track){
                  
                  ?>
                  <tr>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->order_id; ?></h5></td>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->awb_number; ?></h5></td>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->location; ?></h5></td>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->status_description; ?></h5></td>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->remark; ?></h5></td>
                    <td class="tx-center tx-medium tx-inverse"><h5><?= $track->status_time; ?></h5></td>
                  </tr>
                  
                  <?php } }else{ ?>
                  
                  <tr><td colspan="6">No Data Found!</td></tr>
                  <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
      </div>
        <!--/div-->
    </div>
</div>
