<?php

use backend\models\ItEasyBuyProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\web\JsExpression;
use backend\models\ItEasyProduct;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyCourierPincode;
use kartik\date\DatePicker;
use backend\models\ItEasyOrder;
use kartik\daterange\DateRangePicker;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyShippingApi;
use backend\models\ItEasyState;
use backend\models\ItEasyOrderDispatch;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Non Serviceable Orders';
$this->params['breadcrumbs'][] = $this->title;

$courier_name = ItEasyShippingApi::find()->select(['it_easy_ship_id', 'it_easy_name'])->where(['status' => 'Active'])->asArray()->all();

// echo "<pre>";print_r($order_counts);die;

if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}

?>

<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<style type="text/css">
    .assignclass{
      float: right;
      margin-top: 50px;
      border: #e2e2e2;
      background-color: #e2e2e2;
      border-radius: 15px;
      padding-top: 18px;
      padding-right: 34px;
    }

      .modal-dialog {
    max-width: 75%;
  }

  .paymentcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 18px;
  }

  .schipingcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 14px;
  }

  .customercard {
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 92%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin: 10px;
    margin-left: 26px;
    margin-left: 43px;
  }
  .customerform{
    overflow-y: scroll;
    overflow-x: hidden;
  }
.producttable{
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
background-color: #cec5f9;
border-radius: 14px;
width: 93%;
margin-left: 22px;
margin-top: 20px;
height: 275px;
padding: 17px;
margin-left: 43px;
}
  .my-styles {
    border: 1px solid black;
    padding: 15px;
}
.my-styles p{
    border: 1px solid black;
    padding: 10px;
    margin: -1px;
}
.my-styles .iconclor{
color: #fff;
background-color: #48a1bb;
border-color: #48a1bb;
padding: 4px;
}
.ordercusop{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 408px;
  margin-left: -1px;
}

h6{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 430px;
  margin-left: -16px;
}
thead, tbody, tfoot, tr, td, th {
  border-color: inherit;
  border-style: solid;
  border-width: 1px;
}
.colorchange{
  color: #fff;
  font-weight: 500;
  padding: 7px;
}
.btncolor{
    background-color: #48a1bb;
    float: right;
}
span{
  margin: 8px;
}
.text-right{
  text-align: right;
}
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">


                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">

                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['non-serviceable'],'method' => 'get']); ?>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_platform')->dropDownlist($search_array, ['prompt' => 'Search by Platform Type'])->label(false); ?>
                            </div>
                            
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Order number....'])->label(false); ?>
                            </div>
                            

                            

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added',  'AWB ASSIGN' => 'AWB ASSIGN', 'Date Modified' => 'Date Modified', 'Date Converted' => 'Date Converted','Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'], ['prompt' => 'Search by Date Type'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_from_date">
                                <?= DatePicker::widget([
                                'name' => 'ItEasyOrderSearch[date_from_date]', 
                                'value' => $searchModel->date_from_date,
                                'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                                'pluginOptions' => [
                                'format' => 'yyyy-mm-dd',
                                'todayHighlight' => true,
                                'autoclose' => true,
                                'placeholder' => 'Search by From date'
                                    ]
                                ]) ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_to_date">
                                    <?= DatePicker::widget([
                                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                                    'value' => $searchModel->date_to_date,
                                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                                    'pluginOptions' => [
                                    'format' => 'yyyy-mm-dd',
                                    'todayHighlight' => true,
                                    'autoclose' => true,
                                        ]
                                    ]) ?>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_mobile_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Mobile number....'])->label(false); ?>
                            </div>
                            
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_assigned_to')->dropDownlist(['231' => 'Auto Assign', '' => 'All'], [ 'prompt' => 'Search by Auto Assign'])->label(false); ?>
                            </div>
                            
                             <div class="col-md-2">
                        <?= $form->field($searchModel, 'it_easy_courier_name')->dropDownList($array_helper_courier, [ 'prompt' => 'Search BY Courier Name....'])->label(false); ?>
                            </div>
							<div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_state_id')->dropDownList($statedata, [ 'prompt' => 'Search by State Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_status_id')->dropDownlist($order_statusdata, [ 'prompt' => 'Search by Order Status'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_payment_code')->dropDownlist($payment_method, ['prompt' => 'Search by Payment Mode'])->label(false); ?>
                            </div>

                            
                            
                            
                            <div class="col-md-1" style="float: right;padding: 5px;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                            </div>

                             
                            
                              <div class="col-md-1" style="float: right;padding: 5px;">
                                <?= Html::a('Reset', ['order-dispatch/manifest'], ['class'=>'btn btn-secondary-gradient btn-block']) ?>
                              </div>
                              
                              <div class="col-md-1" style="float: right;padding: 5px;">
                                <?= Html::submitButton('Export', ['class' => 'btn btn-secondary-gradient btn-block', 'id' => 'order_list_nonserviceable']) ?>
                            </div> 
                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>

                </div>
                
                
            
                
                
                
                <?php $form1 = ActiveForm::begin([ 'options' => ['class'=>'generatemani','target' => '_blank'], 'action' => ['mark-nonserviceable'], 'method' => 'post']); ?>

                <div class="col-md-12">
                  	<br>
                  	<div class="col-md-3" style="float:right;width: 166px;">
                <button type="sumbit" id="generatecancel" class="btn btn-dark btn-block">Mark Non Serviceable</button>
                      </div>
              	</div>
            
                <div class="card-body">
                    <div class="table-responsive userlist-table">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
  							'rowOptions' => function ($model) {
                                if($model->it_easy_read_status == '0'){
                                    return ['style' => 'background-color:#cbc9c9;text-align:center;'];
                                }
                                return ['style' => 'text-align:center;'];
                            },
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                ['class' => 'yii\grid\CheckboxColumn'],


                                [
                                   'label' => 'Order-Number',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_order_number',
                                   'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],

                                   'value' => function ($model) {
                                        $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                                        $it_easy_flag =  $model->it_easy_flag;
                                        return '<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name.'<br><span style="color:#e18a02;"><b>'.$it_easy_flag.'</b></span><br><span style="color:#e18a02;"><b>'.$model->address_validator_response.'</b></span>';

                                   }
                                ],
                                [
                                   'label' => 'Customer-Info',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_firstname',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {

                                        return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email;

                                   }
                                ],
		
                                [
                                   'label' => 'Address',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_city',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {

                                        return $model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;

                                   }
                                ],
                              
                              	[
                                   'label' => 'Serviceable',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_order_serviceable',

                                   'contentOptions' => ['style' => 'line-height: 36px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {
                                        if(!empty($model->it_easy_order_serviceable)){
                                            
                                            $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($model->it_easy_order_serviceable);
                                            $str_serviceable = '';
                                            if(!empty($get_serviceable_name)){
                                                $count_serviceable = count($get_serviceable_name);
                                                $check_serviceable = $count_serviceable - 1; 
                                                foreach ($get_serviceable_name as $key => $service){
                                                    
                                                        $str_serviceable .= '<a onclick="reassigned('.$model->it_easy_order_id.','.$service->it_easy_ship_id.')" title="'.$service->it_easy_name.'" class="btn btn-info delhivery-sfr btn-sm" style="background-color: #c5b01f;color: #ffffff;margin: 3px;">'.$service->it_easy_name.'</a>&nbsp;';
                                                    
                                                }
                                              	
                                            } 
                                            $str_serviceable .= '<a href="'.BASE_URL.'order-dispatch/refresh-api?order_id='.$model->it_easy_order_id.'" data-toggle="tooltip" class=""  data-original-title="Refresh Serviceable API"><span style="font-size: 24px;float: right;margin-top: 14px;"><i class="typcn typcn-refresh"></i></span></a>';
                                            return $str_serviceable;
                                        }else{
                                            $str_serviceable = '<a href="'.BASE_URL.'order-dispatch/refresh-api?order_id='.$model->it_easy_order_id.'" data-toggle="tooltip" class=""  data-original-title="Refresh Serviceable API"><span style="font-size: 24px;float: right;margin-top: 14px;"><i class="typcn typcn-refresh"></i></span></a>';
                                            return $str_serviceable;
                                        }
                                   }
                                ],
                              
                              
                              
                              	[
                                    'label' => 'Updated',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_updated_time',
                                   'value' => function ($model) {
                                        return date('Y-m-d', strtotime($model->it_easy_updated_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_updated_time));
                                   }
                                ],
                            [
                          'class' => 'yii\grid\ActionColumn',
                          'template' => '{createbutton}',
                          'buttons' => [
                            'createbutton' => function ($url, $model) {
                              $buttons = "";
                       
                               $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#reawb" style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;background-color:#5bc0de" class="reawborder btn btn-info btnw btn-sm" data-toggle="tooltip" title=""  href="javascript:void(0)"  data-original-title="Re AWB">Re AWB</a>';
                              $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#cancel" style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;background-color:#f24545" class="cancelorder btn btn-info btnw btn-sm" data-toggle="tooltip" title=""  href="javascript:void(0)"  data-original-title="Cancel">Cancel</a>';
                              $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#return"  style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;background-color:#ef710e" class="returnorder md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title=""  href="javascript:void(0)" data-modal="modal-1" data-original-title="Return">Return</a>';
                                   $buttons .= '<a data-toggle="modal" data-target="#vieworder"><button style= "color: #fff;background-color: #5bc0de;border-color: #39b3d7;" href="javascript:void(0)" value="' . $model->it_easy_order_id . '" id="abcd" class="getvieworder btn btn-info btnw btn-sm"><i class="typcn typcn-eye"></button></a>';
                              

                              return $buttons;
                            },
                          ],

                        ],

                            ],
                        ]); ?>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
        <!--/div-->
    </div>
</div>

<div class="modal fade" id="cancel" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Cancel Order History</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['order-dispatch/cancel'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="cancelorder" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_order_status_id')->dropDownList(
        $order_statusdata_view,['prompt' => 'Please Select'])->label('Order Status') ?>
            </div>
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_comment')->textArea(['maxlength' => true])->label('Comment**') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="return" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Return Order History</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['order-dispatch/return'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="returnorder" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
         
            <div class="col-md-12">
            <?= $form->field($model, 'it_easy_order_status_id')->hiddenInput(['value'=>'21'])->label(false); ?>
            <p style="line-height: 38px;background-color: #cfe9f4 !important;text-align: center;font-family: initial;" class="bg-info">This order will be returned as APROVAL PENDING.</p>
            </div>
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_comment')->textArea(['maxlength' => true])->label('Comment**') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="reawb" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Select Courier Company</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['ajax/assigncourier'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">
            <input type="hidden"  class="form-control" name="identitiy"  aria-required="true" value="assignawbmani" aria-invalid="false">
          <input type="hidden" id="reawborder" class="form-control" name="order_id" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
            <?php foreach ($courier_name as $key => $value) { ?>
            <div class="col-md-12 form-group">
              
              <label class="col-sm-12 control-label" style="text-align:left;">  
            <input type="radio" class="form-group" name="api_id" value="<?= $value['it_easy_ship_id']; ?>" id="aip_sd_company_id">
            <?= $value['it_easy_name']; ?> <?php if($value['it_easy_ship_id'] == '5'){ ?>
              <input id="india_post_courier_awb" style="margin-top: 10px;width: 250px;margin-left: 72px;" name="india_post_courier_awb" type="text" placeholder="INDIA POST AWB Number">
            <?php } ?></label>
          
            </div>
               <?php   } ?>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary saveawb']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="vieworder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;height: 500px;">
      <div class="modal-header">
        <h5>Order#<span id='printordernumber'></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
  
      <div class="modal-body customerform">
        <div class="row">

          <input type="hidden" id="getvieworderid" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard my-styles">
            <div class="col-md-6  my-styles">
              <h6 class="ordercusop"><i class="typcn typcn-shopping-cart"></i> Order Details</h6>
              <p><i class="typcn typcn-shopping-cart iconclor"></i><span  id="storename"></span></p>
              <p><i class="fa fa-calendar iconclor"></i><span  id="createdtime"></span></p>
              <p><i class="fe fe-credit-card iconclor"></i><span  id="paymentmethod"></span></p>
             
              <p><i class="fa fa-globe iconclor"></i><span  id="website"></span></p>
            </div>
            <div class="col-md-6 my-styles">
               <h6 class="ordercusop"><i class="far fa-user"></i> Customer Details</h6>
              <p><i class="far fa-user iconclor"></i><span  id="name"></span></p>
              
              <p><i class="fa fa-envelope iconclor"></i><span  id="email"></span></p>
              <p><i class="fa fa-phone iconclor"></i> <span  id="phone"></span></p>
              <p><i class="fa fa-mobile iconclor"></i> <span  id="mobile"></span></p>
            </div>
        
          </div>
          <div class="row">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard">
                  <h6>Payment Address</h6><br>
                  <div class="row">
                    <span  id="billname"></span>
                    <span  id="billadd1"></span>
                    <span  id="billadd2"></span>
                    <span  id="billcitypin"></span>
                    <span  id="billstate"></span>
                   
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="schipingcard">
                  <h6>Shiping Address</h6><br>
                  <div class="row">
                  <span  id="shipname"></span>
                  <span  id="shipadd1"></span>
                  <span  id="shipadd2"></span>
                  <span  id="shipcitypin"></span>
                  <span  id="shipstate"></span>
              </div>
            </div>
          </div>
        </div>
        </div>

        <div class="row producttable">
          <div class="col-md-12">
          <table id='mltipleproduct' style="width: 105%;margin-left: -22px;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Product</span></td>
      
                <td><span class="colorchange">Quantity</span></td>
                <td><span class="colorchange">Unit Price</span></td>
                <td><span class="colorchange">Total</span></td></tr>
            </thead>
            <tbody id='tbodyprint'>
      
            </tbody>
            <tfoot id='tfootprint'>
                
            </tfoot>
          </table> 
          </div>         
        </div> 

            <div class="row" style="margin-top: 20px;">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard" style="min-height: 347px;">
                  <h6>Order History</h6><br>
                  <div class="row">
                      
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
                
            
            </thead>
            <tbody id="addstatustable">
            
            </tbody>
        
          </table> 

            </div>
          </div>
        </div>

             <div class="col-md-6">
          <div class="schipingcard" style="min-height: 347px;">
            <h6>Disposition Order History</h6><br>
            <div class="row">
                              
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
          
            
            </thead>
            <tbody id="dispostaustable">
         
            </tbody>
        
          </table> 
              </div>
            </div>
          </div>
        </div>
        </div> 
      </div>
    </div>
  </div>
</div>
</div>