<script src="<?= BASE_URL ?>plugins/jquery/jquery.min.js"></script>
<script src="<?= BASE_URL ?>js/bootstrap.min.js"></script>
<script src="<?= BASE_URL ?>js/EAN_UPC.js"></script>
<script src="<?= BASE_URL ?>js/CODE128.js"></script>
<script src="<?= BASE_URL ?>js/JsBarcode.js"></script>
<link href="<?= BASE_URL ?>css/label-print2.css" rel="stylesheet">
<link href="<?= BASE_URL ?>css/label-screen2.css" rel="stylesheet">

<style>
  * {
    box-sizing: border-box;
    font-family: Arial, Helvetica, sans-serif;
  }

  body {
    margin: 0;
    padding: 0;
    background: #f5f5f5;
    font-size: 14px;  /* bigger base font */
  }

  /* Flexible width, but landscape style (wide) */
  .page {
    width: 100%;
    max-width: 290mm;      /* approx A4 landscape width, but not fixed */
    margin: 10px auto;
    background: #fff;
    padding: 10mm;
    border: 1px solid #000;
  }
  
  .page-break {
    page-break-after: always;
}

@media print {
    .page-break {
        page-break-after: always;
    }
}

  h1, h2, h3, h4, h5 {
    margin: 0;
    padding: 0;
  }

  .small      { font-size: 13px; }
  .bold       { font-weight: bold; }
  .text-right { text-align: right; }
  .text-center{ text-align: center; }

  .bordered {
    border: 1px solid #000;
    border-collapse: collapse;
  }
  .bordered td,
  .bordered th {
    border: 1px solid #000;
    padding: 4px 5px;
    font-size: 13px;   /* bigger table fonts */
  }

  .no-border td,
  .no-border th {
    border: none;
    padding: 2px 3px;
    font-size: 12px;
  }

  .section-title {
    font-weight: bold;
    font-size: 14px;
    border-bottom: 1px solid #000;
    padding-bottom: 3px;
    margin-top: 4px;
    margin-bottom: 4px;
  }

  .barcode-large {
    height: 90px;
    border: 1px solid #000;
    margin: 4px 0;
    text-align: center;
    font-size: 13px;
    letter-spacing: 3px;
    padding-top: 14px;
  }

  .mt-5  { margin-top: 6px; }
  .mt-10 { margin-top: 10px; }

  @media print {
    @page {
      size: landscape;   /* only orientation, no fixed paper size */
      margin: 5mm;
    }
    body {
      background: #fff;
      margin: 0;
      padding: 0;
    }
    .page {
      margin: 0 auto;
      border: none;
      padding: 6mm;
    }
  }
</style>

<?php
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyProductVariation;

/** number to words helper */
function numToWordsRec($number) {
    $words = array(
        0 => 'zero', 1 => 'one', 2 => 'two',
        3 => 'three', 4 => 'four', 5 => 'five',
        6 => 'six', 7 => 'seven', 8 => 'eight',
        9 => 'nine', 10 => 'ten', 11 => 'eleven',
        12 => 'twelve', 13 => 'thirteen',
        14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
        19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
        40 => 'forty', 50 => 'fifty', 60 => 'sixty',
        70 => 'seventy', 80 => 'eighty',
        90 => 'ninety'
    );

    if ($number < 20) {
        return $words[$number];
    }

    if ($number < 100) {
        return $words[10 * floor($number / 10)] . ($number % 10 ? ' '.$words[$number % 10] : '');
    }

    if ($number < 1000) {
        return $words[floor($number / 100)] . ' hundred' . ($number % 100 ? ' '.numToWordsRec($number % 100) : '');
    }

    if ($number < 1000000) {
        return numToWordsRec(floor($number / 1000)) . ' thousand' . ($number % 1000 ? ' '.numToWordsRec($number % 1000) : '');
    }

    return numToWordsRec(floor($number / 1000000)) . ' million' . ($number % 1000000 ? ' '.numToWordsRec($number % 1000000) : '');
}

$ia = 1;
$total_records = count($params);
foreach ($params as $printdata) {

    $product        = ItEasyOrder::GrtOrderProducts1($printdata['orderid']);
    // echo"<pre>";
    // print_r($product);die;
    $dispatch_order = ItEasyOrderDispatch::findOne(['it_easy_order_id' => $printdata['orderid']]);
    $process_code   = $dispatch_order ? $dispatch_order->it_easy_route_code : '';

    $withgst_total  = isset($withgst_total) ? $withgst_total : (float)$printdata['order_total_price'];

    $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($printdata['shipping_code']);

    if (!empty($get_shippingmethod) && isset($get_shippingmethod['it_easy_method_value'])) {

        if ($get_shippingmethod['it_easy_add_value_type'] == 'Flat') {
            if ($get_shippingmethod['it_easy_method_value_type'] == 'Add-Amount') {
                $shipping_value = $get_shippingmethod['it_easy_method_value'];
            } else {
                $shipping_value = -$get_shippingmethod['it_easy_method_value'];
            }
        } else {
            if ($get_shippingmethod['it_easy_method_value_type'] == 'Add-Amount') {
                $shipping_value = $withgst_total * $get_shippingmethod['it_easy_method_value'] / 100;
            } else {
                $shipping_value = $withgst_total * $get_shippingmethod['it_easy_method_value'] / 100;
                $shipping_value = -$shipping_value;
            }
        }
    } else {
        $shipping_value = 0;
    }

    $get_coupon_data = ItEasyOrder::getCoouponbyid($printdata['coupon_id']);

    if (!empty($get_coupon_data)) {
        if ($get_coupon_data['it_easy_coupon_type'] == 'Flat') {
            $dis_coupon_value = $get_coupon_data['it_easy_discount'];
        } else {
            $dis_coupon_value = $withgst_total * $get_coupon_data['it_easy_discount'] / 100;
        }
    } else {
        $dis_coupon_value = 0;
    }

    $total_price    = (int)$printdata['order_total_price'];
    $word_rs_total  = numToWordsRec($total_price);

   // $printdata['invoice'] = str_replace('2023_2024', '2024_2025', $printdata['invoice']);
    
    $printdata['invoice'] = ItEasyOrder::getInvoiceNumber($printdata['orderid']);
    
//      $invoice = $printdata['invoice']; // e.g. NH-2024_2025-480565

// $parts = explode('-', $invoice);

// // PART 1
// $prefix = $parts[0];  // NH

// // PART 2 (year logic)
// list($yr_from, $yr_to) = explode('_', $parts[1]);
// $short_year = sprintf("%02d", ((int)$yr_to + 1) % 100);  // e.g. 25

// // PART 3 (original)
// $original_code = $parts[2];  // 480565

// // New format for part 3 (A00001_original)
// $running_number = 1;  // update this as needed
// $running_number_formatted = sprintf("A%05d", $running_number);

// // final modified part3
// $modified_part3 = $running_number_formatted . "_" . $original_code;

// // final invoice
// $printdata['invoice'] = "{$prefix}/{$short_year}/{$modified_part3}";
    $product = ItEasyOrder::GrtOrderProducts1($printdata['orderid']);
?>

<div class="page">
    
    <!-- Order ID Centered -->
    <div style="text-align:center; font-size:18px; font-weight:bold; margin-bottom:10px;">
        Order ID: #<?= $printdata['ordernumber'] ?></td>
    </div>

  <!-- TOP SENDER / SHIP TO / BILL TO SECTION -->
  <table class="bordered" style="width:100%; border-bottom:none;">
    <tr>
      <!-- Sender -->
      <td style="width:33%; vertical-align:top;">
        <div class="bold small">Sender:</div>
        <div class="bold small"><?= $printdata['it_easy_registered_name'] ?></div>
        <div class="small">
          <?= $printdata['storeadd1'] ?>,
          <?= $printdata['storeadd2'] ?>,
          <?= $printdata['storecity'] ?>,
          <?= $printdata['storestate'] ?> - <?= $printdata['storepin'] ?><br />
          <b>GST NO :</b> <?= $printdata['storegst'] ?><br />
        </div>
      </td>

      <!-- Ship To -->
      <td style="width:34%; vertical-align:top;">
        <div class="bold small">Ship To:</div>
        <div class="bold small"><?= $printdata['shipfirstname'] ?> <?= $printdata['shiplastname'] ?></div>
        <div class="small">
          <?= $printdata['shipadd1'] ?> ,  <?= $printdata['shipadd2'] ?> <?= $printdata['shipcity'] ?>-<?= $printdata['shippin'] ?> , <?= $printdata['shipstate'] ?>
        </div>
      </td>

      <!-- Bill To -->
      <td style="width:33%; vertical-align:top;">
        <div class="bold small">Bill To:</div>
        <div class="bold small"><?= $printdata['billfirstname'] ?> <?= $printdata['billlastname'] ?></div>
        <div class="small">
          <?= $printdata['billfirstname'] ?> <?= $printdata['billlastname'] ?>
          <?= $printdata['billadd1'] ?> <?= $printdata['billadd2'] ?>
          <?= $printdata['billcity'] ?>, <?= $printdata['billstate'] ?>, <?= $printdata['billpin'] ?>, India.
        </div>
      </td>
    </tr>
  </table>

  <!-- MIDDLE: LEFT (INVOICE DETAILS) + RIGHT (BIG BARCODE) -->
  <table class="bordered" style="width:100%; border-top:none; border-bottom:none;">
    <tr>
      <!-- LEFT: Invoice Details -->
      <td style="width:40%; vertical-align:top;">
        <div class="section-title small">Invoice Details-</div>
        <table class="no-border" style="width:100%;">
          <tr>
            <td>Invoice Date:</td>
            <td class="bold"> <?= !empty($printdata['convertdate']) ? date('d/M/Y', strtotime($printdata['convertdate'])): date('d/M/Y', strtotime($printdata['createtime'])); ?></td>
          </tr>
          <tr>
            <td>Invoice No.:</td>
            <td class="bold"><?= $printdata['invoice'] ?></td>
          </tr>
          <tr>
            <td>Order No:</td>
            <td class="bold">#<?= $printdata['ordernumber'] ?></td>
          </tr>
          <tr>
            <td>Sort Code:</td>
            <td class="bold"><?= $printdata['route_code'] ?></td>
          </tr>
          <tr>
            <td>COD Money:</td>
            <td class="bold">Rs.<?= $printdata['collectprice'] ?>-</td>
          </tr>
          <tr>
            <td>Order Total:</td>
            <td class="bold">Rs.<?= $printdata['order_total_price'] ?></td>
          </tr>
          <!-- ORDER BARCODE ROW (INSIDE INVOICE BOX) -->
          <tr>
            <td colspan="2" class="text-center" style="padding-top:8px;">
              <img id="order<?= $ia ?>" style="width:100%;height:60px;" /><br/>
              <span class="small">[<?= $printdata['ordernumber'] ?>]</span>
            </td>
          </tr>
        </table>
      </td>

      <!-- RIGHT: Big Barcode (AWB) -->
      <td style="width:60%; vertical-align:top;">
        <div class="small mt-5">
          Mobile No.: +91xxxxx<br>
          Pay Mode: <b><?= $printdata['paymentmode']; ?></b>, Weight: 0.5KG<br>
          Courier: <b><?= $printdata['subcourier']; ?></b>, AWB No.: <?= $printdata['awbnumber'] ?>
        </div>

        <div class="barcode-large">
          <span style="text-align: center; display:block;">
            <img id="awb_numberbarcode<?= $ia ?>" style="width:100%;height:70px;" /><br /><br />
            [<?= $printdata['awbnumber'] ?>]
          </span>
        </div>
      </td>
    </tr>
  </table>

  <!-- ITEMS TABLE -->
  <table class="bordered" style="width:100%; margin-top:6px;">
    <thead>
      <tr>
        <th style="width:15%;">Product Name</th>
         <th style="width:15%;">Product HSN</th>
        <th style="width:5%;">Qty</th>
        <!--<th style="width:10%;">Rate</th>-->
           <th style="width:10%;">Taxable Amount<br>(INR)</th>
        <th style="width:15%;">Tax Amount</th>
        <th style="width:15%;">Tax Rate & Tax Type<br>(<?php if($printdata['state_id'] == '7'){ echo "CGST + SGST"; }else{ echo "IGST"; } ?>)</th>
        <th style="width:15%;">Amount<br>(INR)</th>
      </tr>
    </thead>
    <tbody>
      <?php
        $sub_total         = 0;
        $product_total     = 0;
        $tax_total         = 0;
        $product_quantity  = 0;
        $totalTaxable = 0;
      $totalGST = 0;

        foreach ($product as $value) {
            // echo "<pre>";
            // print_r($value);die;
           

          $tax_rate = ItEasyProductVariation::find()
              ->where(['it_easy_product_id' => $value['it_easy_product_id']])
              ->andWhere(['it_easy_variation_id' => $value['it_easy_variation_id']])
              ->asArray()->one();

          $unit_price = $value['it_easy_product_total'] / max(1, $value['it_easy_product_quantity']);

          $sub_total         += $value['it_easy_product_price'];
          $product_total     += $value['it_easy_product_total'];
          $tax_total         += $value['it_easy_product_tax'];
          $product_quantity  += $value['it_easy_product_quantity'];
         
          
          $totalPrice=$value['it_easy_product_total'];
          $gstPercent=$tax_rate['it_easy_product_tax'];
          
          $taxableAmount = ($totalPrice / (100 + $gstPercent)) * 100;

// Calculate GST amount
$gstAmount = $totalPrice - $taxableAmount;

// Format values
$taxableAmount = number_format($taxableAmount, 2, '.', '');
$gstAmount = number_format($gstAmount, 2, '.', '');

  $totalTaxable  += $taxableAmount;
    $totalGST      += $gstAmount;
         // $taxable_amount    +=$value['it_easy_product_total']/$tax_rate['it_easy_product_tax']+100*100;
         
      ?>
      <tr>
        <td><?= $value['product_sku'] ?> (<?= $value['it_easy_variation_name'] ?>)</td>
          <td class="text-center"><?= $value['it_easy_product_hsn'] ?></td>
        <td class="text-center"><?= $value['it_easy_product_quantity'] ?></td>
        <!--<td class="text-center"><?= $value['it_easy_product_total']; ?></td>-->
          <td class="text-center"><?=$taxableAmount ?></td>
        <!--<td class="text-center"><?= $value['it_easy_product_tax']; ?></td>-->
        <td class="text-center"><?= $gstAmount ?></td>
        <td class="text-center"><?= $tax_rate['it_easy_product_tax'] ?>%</td>
        <td class="text-center"><?= $value['it_easy_product_total']; ?></td>
      </tr>
      <?php } // end foreach product ?>
      <tr>
        <td class="bold">Total</td>
         <td class="bold"></td>
        <td class="text-center bold"><?= $product_quantity; ?></td>
        <!--<td class="text-center bold"><?= $product_total; ?></td>-->
         <td class="text-center bold"><?= $totalTaxable; ?></td>
        <!--<td class="text-center bold"><?= $tax_total; ?></td>-->
          <td class="text-center bold"><?= $totalGST; ?></td>
            <td class="bold"></td>
        <!--<td class="text-center bold"><?= $tax_rate['it_easy_product_tax'] ?>%</td>-->
        <td class="text-center bold"><?= $product_total; ?></td>
      </tr>
    </tbody>
  </table>

  <!-- BOTTOM DECLARATION + SIGNATURE -->
  <table style="width:100%; margin-top:8px;">
    <tr>
      <td style="width:70%; vertical-align:top;" class="small">
        <div class="bold">Declaration:</div>
        <ol style="margin:0; padding-left:15px; margin-top:3px;">
          <li>We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.</li>
          <li>All Disputes are subject to Delhi (07) jurisdiction only.</li>
        </ol>

        <div class="bold mt-5 small">Attention:</div>
        <div class="small">
          For any returns or exchanges, please ensure you record a video while unboxing the sealed package.
          Requests without this video will not be accepted.
        </div>
      </td>

      <td style="width:30%; vertical-align:bottom;" class="small text-right">
        <div class="small">E.&amp;O.E.</div>
        <div class="small">Tax Payable on reverse charge basis: No</div>
        <br>
        <div>For Skygain Nutricare Pvt. Ltd.</div>
        <br><br>
        <div class="bold"><img src="<?= BASE_URL; ?>img/sign-bs%20(1).jpg" alt="" width="50"></div>
        <div>Authorised Signatory</div>
      </td>
    </tr>
  </table>

</div>

<!-- JS TO DRAW BARCODES FOR THIS PAGE -->
<script>
  $(document).ready(function () {
    // Thicker + taller bars so they survive printer scaling to 4x6
    $("#order<?= $ia ?>").JsBarcode("<?= $printdata['ordernumber']; ?>", {
      width: 3,          // thicker bars
      height: 60,        // taller bars
      margin: 0,
      fontSize: 14
    });

    $("#awb_numberbarcode<?= $ia ?>").JsBarcode("<?= $printdata['awbnumber']; ?>", {
      width: 3,
      height: 70,
      margin: 0,
      fontSize: 14
    });
  });
</script>
<?php if ($ia < $total_records) { ?>
   <div class="page-break"></div>
<?php } ?>

<?php
  $ia++;
} // end foreach $params
?>