<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2; // or kartik\select2\Select2
use yii\web\JsExpression;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyState;
use backend\models\ItEasyProduct;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyDiseasesName;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrder $model */
/** @var yii\widgets\ActiveForm $form */
$url = \yii\helpers\Url::to(['ajax/getstate']);
$this->title = 'Create Order';
$productdata = [];
$stateList = ItEasyState::find()->select(['it_easy_id', 'it_easy_state_name'])->all();
$statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');
// $order_statusdata = ArrayHelper::map(ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_order_type' => 'Order'])->all(), 'it_easy_order_status_id', 'it_easy_order_status_name');
$order_dispositiondata = ArrayHelper::map(ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type' => 'Order'])->all(), 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');
$statedata = ArrayHelper::map($stateList, 'it_easy_id', 'it_easy_state_name');

$shipping_method = ArrayHelper::map(ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Shipping'])->andWhere(['it_easy_status' => 'Active'])->all(), 'it_easy_method_code', 'it_easy_method_name' );

$payment_method = ArrayHelper::map(ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Payment'])->andWhere(['it_easy_status' => 'Active'])->all(), 'it_easy_method_code', 'it_easy_method_name' );
// echo "<pre>"; print_r($productdata); die;
$diseases = ArrayHelper::map(ItEasyDiseasesName::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_name' );


if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}


?>
<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }
    .timeline-badge{
        left: 43.8% !important;
        width: 35px !important;
        height: 35px !important;
    }
    .timeline-panel{
        width: 53% !important;
        margin-left: 0% !important;
        margin-right: 0% !important;
        padding-right: 5px !important;
        padding-left: 5px !important; 
    }
    .timeline-title{
        color: #939393;
    }
    .vtimeline .timeline-wrapper.timeline-inverted .timeline-panel{
        margin-left: auto !important;
        

    }
    .vtimeline .timeline-wrapper .timeline-badge i{
        font-size: 16px !important;
        line-height: 31px !important;
    }
    .timeline-wrapper-primary .timeline-panel:before, .timeline-wrapper-primary .timeline-badge{
        background-color: #eb4b26 !important;
    }
    .timeline-wrapper-secondary .timeline-panel:before, .timeline-wrapper-secondary .timeline-badge{
        background-color: #eb4b26 !important;
    }
    .timeline-wrapper-info .timeline-panel:before, .timeline-wrapper-info .timeline-badge{
        background-color: #eb4b26 !important;
    }

    .show_customer_dropdown{
        background-color: #f7f3f3;
        /* padding-left: 10px; */
        margin-top: -17px;
        border-radius: 5px;
        border: 2px solid #fbebce;
        padding-top: 10px;
        max-height: 210px;
        overflow: scroll;
        display: none;
    }
    .tiny-add-customer{
        list-style: none;
        overflow-x: scroll;
        color: #8d8a8a;
        font-size: 14px;
        font-weight: 700;
        margin-bottom: -6px;
    }
    .tiny-add-customer > li{
        padding: 10px 1px 10px 25px;
        border-bottom: 1px solid #dfdcdc;
        margin-left: -43px;
        cursor: pointer;
    }
    @media (min-width: 576px){
        .modal-dialog{
            max-width: 700px !important;
        }
    }
    label{
        font-size: 15px;
        font-weight: 400;
    }
    .title{
        padding-bottom: 15px;
        border-bottom: 1px solid #e3e8f7;
        margin-bottom: 20px;
    }
  
</style>
<?php $form = ActiveForm::begin(['options' => ['autocomplete' => 'off']]); ?> 
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between" style="background-color: #fcfcfc;padding: 10px;color: #999898;">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::submitButton('Save Order', ['class' => 'btn btn-dark btn-block',  'id' => 'submit_button_take_2']) ?>&nbsp;&nbsp;&nbsp;
                    <div class="pr-1 mb-xl-0">

                        <a href="<?= BASE_URL ?>order"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <div class="row">
        <div class="col-lg-3 col-md-3">
            <div class="vtimeline" style="background-color:#ffffff; padding: 10px;">
                <div class="timeline-wrapper timeline-wrapper-primary">
                    <div class="timeline-badge success" id="checkbox_customer_adding_class"><i class="fas fa-times" id="checkbox_customer_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Customer</h6>
                        </div>
                    </div>
                </div>

                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge success" id="checkbox_billing_adding_class"><i class="fas fa-times" id="checkbox_billing_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Billing</h6>
                        </div>
                    </div>
                </div>

                <div class="timeline-wrapper timeline-wrapper-info">
                    <div class="timeline-badge" id="checkbox_shipping_adding_class"><i class="fas fa-times" id="checkbox_shipping_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Shipping</h6>
                        </div>
                    </div>
                </div>
                
                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge" id="checkbox_product_adding_class"><i class="fas fa-times" id="checkbox_product_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Product</h6>
                        </div>
                    </div>
                </div>
                <div class="timeline-wrapper timeline-wrapper-info">
                    <div class="timeline-badge" id="checkbox_payments_adding_class"><i class="fas fa-times" id="checkbox_payments_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Payments</h6>
                        </div>
                    </div>
                </div>
                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge success"><i class="fas fa-times" id="checkbox_couries_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Courier</h6>
                        </div>
                    </div>
                </div>
            </div>
            <div class="vtimeline" style="background-color:#ffffff; padding: 10px;">
                <?php if(!empty($model->it_easy_order_serviceable)){ ?>
                    
                <?php } ?>
                
            </div>
        </div>
        
        <div class="col-lg-9 col-md-9">
           
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Customer Information
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                            <?= $form->field($model, 'it_easy_customer_id')->textInput(['id' => 'Add-Customer', 'placeholder' => 'Add & Search by Name or mobile number'])->label(false); ?>
                        <div class="show_customer_dropdown" id="show_customer_dropdown">

                        </div>
                

                        <div class="card" id="customer_information_show" style="display: none;">
                            <div class="card-header pb-0">
                                <div class="card-title pb-0  mb-2" id="customer_name_add" style="font-size: 20px;"></div>
                                <p class="tx-14 tx-gray-500 mb-3" id="custome_address_add"></p>
                                <div class="right" style="float: right;margin-top: -76px;">
                                    <button   class="btn btn-primary" data-target="#scrollmodal" data-toggle="modal"><i class="typcn typcn-pen"></i></button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col text-center">
                                        <label class="tx-12" >Mobile</label>
                                        <p class="font-weight-bold tx-16" id="customer_mobile_add"></p>
                                    </div><!-- col -->
                                    <div class="col border-left text-center">
                                        <label class="tx-12">Email</label>
                                        <p class="font-weight-bold tx-16" id="customer_email_add"></p>
                                    </div><!-- col -->
                                    <div class="col border-left text-center">
                                        <label class="tx-12">Pincode</label>
                                        <p class="font-weight-bold tx-16" id="customer_pincode_add"></p>
                                    </div><!-- col -->
                                </div><!-- row -->
                                <div class="progress ht-20 mt-4">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary ht-20 wd-95p">99%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Add Product
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
                        <div class="col-md-5">
                <?= 


                $form->field($product_model, 'it_easy_product_id')->widget(Select2::classname(), [
                            'data' => $productdata,
                            'options' => [ 'placeholder' => 'Search for a Product ...', 'class' => 'order_variation_change_status'],
                            'pluginOptions' => [
                                'allowClear' => true,
                                'minimumInputLength' => 2,
                                'language' => [
                                    'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
                                ],
                                'ajax' => [
                                    'url' => $url = \yii\helpers\Url::to(['ajax/getproduct']),
                                    'dataType' => 'json',
                                    'data' => new JsExpression('function(params) { return {q:params.term}; }')
                                ],
                                'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                                'templateResult' => new JsExpression('function(city) { return city.text; }'),
                                'templateSelection' => new JsExpression('function (city) { return city.text; }'),
                            ],
                        ])->label(false);

                    //$form->field($product_model, 'it_easy_product_id')->dropDownList($productdata, ['prompt' => 'Search by Product'])->label(false);


                         ?>     
                        </div>

                        <div class="col-md-4">
                <?= $form->field($product_model, 'it_easy_variation_id')->dropDownList([], ['prompt' => 'Search Variation'])->label(false); ?>     
                        </div>

                        <div class="col-md-3">
                                <button class="btn btn-secondary" id="add_product_creater" type="button">Add Product</button>
                        </div>
                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0" id="product_table_Add_show">
                        <tbody>
                            <tr data-id="0">
                                <td class="w-1" style="width:15%;"></td>
                                <td style="width:46%;"><b>Product Details<b></td>
                                <td class="w-1 text-right" style="width:14%;"><b>Quantity</b></td>
                                <td class="w-1 text-right" style="width:15%;"><b>Total</b></td>

                                <td class="w-1 text-right" style="width:10%;"></td>
                            </tr>
                        </tbody>
                    </table>
                        </div>
                    </div>
                </div>

            </div>


            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Payments
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
                        <div class="col-md-12">
                    <?= $form->field($model, 'it_easy_disease_name')->widget(Select2::classname(), [
                        'data' => $diseases,
                        'language' => 'en',
                        'options' => ['placeholder' => 'Select Disease Name ...','multiple' => true],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                        ]);

                         ?>
                        </div>
                        
                        <div class="col-md-12">
                  
                        <?= $form->field($model, 'it_easy_platform')->dropDownList($search_array)->label('Platform') ?>

                        </div>
                        
                        <div class="col-md-12">
                  
                        <?= $form->field($model, 'it_easy_abondoned_type')->dropDownList(['Abondoned' => 'Abondoned', 'Amazon' => 'Amazon', 'Flipkart' => 'Flipkart'], ['prompt' => 'Select Abondoned Type'])->label('Abondoned Type') ?>

                        </div> 
                        <div class="col-md-6">
                  
                        <?= $form->field($model, 'it_easy_course_duration')->dropDownList(['1 month' => '1 month', '15 days' => '15 days'], ['prompt' => 'Select Course Duration'])->label('Course Duration') ?>

                        </div> 

                        <div class="col-md-6">
                        
                        <?= $form->field($model, 'it_easy_age')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-md-6">
                            <input type="hidden" name="ItEasyOrder[Payment_Value_Old]" id="Payment_Value_Old" value="0_add">
                            <input type="hidden" name="ItEasyOrder[Shipping_Value_Old]" id="Shipping_Value_Old" value="0_add">
                            <?= $form->field($model, 'it_easy_payment_method')->dropDownList($payment_method, ['prompt' => 'Select Payment Method']); ?>
                            
                        </div>
                        <div class="col-md-6">
                    <?= $form->field($model, 'it_easy_shipping_method')->dropDownList($shipping_method, ['prompt' => 'Select Shipping Method']); ?>
                        </div> 

                        
                        <div class="col-md-6">
                            <?= $form->field($model, 'it_easy_order_status_id')->dropDownList($order_statusdata, ['prompt' => 'Select Order Status'])->label('Order Status'); ?>

                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'it_easy_order_disposition_id')->dropDownList($order_dispositiondata, ['prompt' => 'Select Order Disposition'])->label('Order Disposition'); ?>

                        </div>

                        <div class="col-md-6">
                            <?= $form->field($model, 'it_easy_order_status_comment')->textArea(); ?>

                        </div>
                        <div class="col-md-6">
                            <?= $form->field($model, 'it_easy_order_disposition_comment')->textArea(); ?>

                        </div>


                        <div class="col-md-9">   
                <?= $form->field($model, 'it_easy_coupon_id')->widget(Select2::classname(), [
                            'data' => $productdata,
                            'options' => [ 'placeholder' => 'Search for a Coupon...', 'class' => 'order_variation_change_status'],
                            'pluginOptions' => [
                                'allowClear' => true,
                                'minimumInputLength' => 2,
                                'language' => [
                                    'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
                                ],
                                'ajax' => [
                                    'url' => $url = \yii\helpers\Url::to(['ajax/getcoupon']),
                                    'dataType' => 'json',
                                    'data' => new JsExpression('function(params) { return {q:params.term}; }')
                                ],
                                'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                                'templateResult' => new JsExpression('function(city) { return city.text; }'),
                                'templateSelection' => new JsExpression('function (city) { return city.text; }'),
                            ],
                        ])->label(false);

                    //$form->field($product_model, 'it_easy_product_id')->dropDownList($productdata, ['prompt' => 'Search by Product'])->label(false);


                         ?>     
                        </div>

                        <div class="col-md-3" style="float: right;">
                                <button class="btn btn-secondary" id="apply_coupon" type="button">Apply Coupon</button>
                        </div>

                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0" id="product_table_Add_show">
                        <tbody>
                            <tr data-id="0">
                                <td class="w-1" style="width:25%;"><strong>Subtotal</strong></td>
                                <td style="width:50%;"></td>
                                <td class="w-1 text-right" style="width:25%;"><b>₹<span class="order_subtotal_price"><?= number_format((float)0, 2, '.', ''); ?></span></b></td>
                            </tr>
                            <tr data-id="1">
                                <td class="w-1" style="width:25%;">Add discount</td>
                                <td style="width:50%;"><span class="add_coupon_name">—</span></td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_discount_price"><?= number_format((float)0, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="2">
                                <td class="w-1" style="width:25%;">Add Shipping</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_shipping_price"><?= number_format((float)0, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="2">
                                <td class="w-1" style="width:25%;">COD Handling Charges</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_cod_handling_price"><?= number_format((float)0, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="3">
                                <td class="w-1" style="width:25%;">Estimate Tax</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_estimate_tax_price"><?= number_format((float)0, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="4">
                                <td class="w-1" style="width:25%;"><strong>Total</strong></td>
                                <td style="width:50%;"></td>
                                <div class="main_total_price" style="display:none;"><?= number_format((float)0, 2, '.', ''); ?></div>
                                <td class="w-1 text-right" style="width:25%;"><b>₹<span class="add_Total_price"><?= number_format((float)0, 2, '.', ''); ?></span></b></td>
                            </tr>

                        </tbody>
                    </table>
                        <p style="padding: 10px;margin-top: 10px;">Taxes may be estimates until the order is created.</p>
                        </div>
                    </div>
                </div>

                <div class="col-md mt-4 mt-xl-0" style="margin-top:30px !important;">
                    <?= Html::submitButton('Save Order', ['class' => 'btn btn-dark btn-block', 'id' => 'submit_button_take_1']) ?>
                    <br>
                </div>
            </div>

        </div>
     </div>
</div>






<div class="modal show" id="scrollmodal" style="display: none;" aria-modal="true">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content modal-content-demo">
            <div class="modal-header">
                <h6 class="modal-title">Customer Information</h6><button aria-label="Close" class="close" data-dismiss="modal" type="button"><span aria-hidden="true">×</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div style="display: none;">
                        <?= $form->field($model, 'it_easy_customer_id')->hiddenInput([])->label(false); ?>
                    </div>
                    <div class="col-md-6">
                        
                        <?= $form->field($model, 'it_easy_firstname')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_lastname')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_mobile_number')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_alternate_number')->textInput(['maxlength' => true]) ?>
                    </div>        
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_email')->textInput(['maxlength' => true]) ?>
                    </div>
                    
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_address_1')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_address_2')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_city')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-3">
                    <?= $form->field($model, 'it_easy_pincode')->textInput(['maxlength' => true,  'options' => ['autocomplete' => 'off']]) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_fax')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-12 text_ikssss" style="background-color: #6095b1;padding: 10px;color: #d9ddd8;font-family: fangsong;">
                        
                    </div>
                </div>  
                <br>
                <div class="content clearfix">
                     <div class="row">
                   <div class="col-md-6"> 
                    <h3 id="wizard1-h-0" tabindex="-1" class="title current">Billing Information</h3>
                    </div>
                    <div class="col-md-6"><input type="checkbox" name="" id="forbilling"><span style="font-weight: 700;"> Same as main address</span>
                    </div>
                    </div>
                    <section id="wizard1-p-0" role="tabpanel" aria-labelledby="wizard1-h-0" class="body current" aria-hidden="false">
                     <div class="row">  
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_firstname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_lastname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_company_name')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_gst')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_mobile')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_alternate_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_email')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_address_1')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_address_2')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                
                                
                                <?= $form->field($model, 'it_easy_billing_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_city')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_pincode')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                    </div>
                    </section>
                </div>

                <br>
                <div class="content clearfix">
                        <div class="row">
                        <div class="col-md-6">
                    <h3 id="wizard1-h-0" tabindex="-1" class="title current">Shipping Information</h3>
                    </div>
                     <div class="col-md-6"><input type="checkbox" name="" id="forshiping"><span style="font-weight: 700;">   Same as main address</span>
                    </div>
                    </div>
                    <section id="wizard1-p-0" role="tabpanel" aria-labelledby="wizard1-h-0" class="body current" aria-hidden="false">
                     <div class="row">  
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_firstname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_lastname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_mobile_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_alternate_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_email')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_address_1')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_address_2')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                

                                <?= $form->field($model, 'it_easy_shipping_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_city')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_pincode')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                    </div>
                    </section>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn ripple btn-primary" id="customer_form_submit" type="button">Save changes</button>
                <button class="btn ripple btn-secondary" data-dismiss="modal" type="button">Close</button>
            </div>
        </div>
    </div>
</div>



<?php ActiveForm::end(); ?>

<div class="sweet-overlay" tabindex="-1" style="opacity: -0.01;display: none;"></div>
<div class="sweet-alert showSweetAlert visible" data-custom-class="" data-has-cancel-button="false" data-has-confirm-button="true" data-allow-outside-click="false" data-has-done-function="false" data-animation="pop" data-timer="null" style="display: none;margin-top: -182px;">
    
    <div class="sa-icon sa-success animate" style="display: block;">
      <span class="sa-line sa-tip animateSuccessTip"></span>
      <span class="sa-line sa-long animateSuccessLong"></span>

      <div class="sa-placeholder"></div>
      <div class="sa-fix"></div>
    </div>
    <h2>Well done!</h2>
    <p style="display: block;">You added a customer!</p>
    <fieldset>
      <input type="text" tabindex="3" placeholder="">
      <div class="sa-input-error"></div>
    </fieldset>
    <div class="sa-error-container">
      <div class="icon">!</div>
      <p>Not valid!</p>
    </div>
    <div class="sa-button-container">
      <button class="cancel" tabindex="2" style="display: none; box-shadow: none;">Cancel</button>
      <div class="sa-confirm-button-container">
        <button class="confirm" tabindex="1" style="display: inline-block; background-color: rgb(87, 169, 79); box-shadow: rgba(87, 169, 79, 0.8) 0px 0px 2px, rgba(0, 0, 0, 0.05) 0px 0px 0px 1px inset;">OK</button><div class="la-ball-fall">
          <div></div>
          <div></div>
          <div></div>
        </div>
      </div>
    </div>
</div>


<div class="sweet-alert showSweetAlert visible" id="sweet-alert2" data-custom-class="" data-has-cancel-button="false" data-has-confirm-button="true" data-allow-outside-click="false" data-has-done-function="false" data-animation="pop" data-timer="null" style="display: none;margin-top: -182px;">
    
    <div class="sa-icon sa-error">
      <span class="sa-x-mark">
        <span class="sa-line sa-left"></span>
        <span class="sa-line sa-right"></span>
      </span>
    </div>
    <h2 class="product_add_error">!</h2>
    <br>
    <fieldset>
      <input type="text" tabindex="3" placeholder="">
      <div class="sa-input-error"></div>
    </fieldset>
    <div class="sa-error-container">
      <div class="icon">!</div>
      <p>Not valid!</p>
    </div>
    <div class="sa-button-container">
      <div class="sa-confirm-button-container">
        <button class="confirm" tabindex="1" style="display: inline-block; background-color: rgb(87, 169, 79); box-shadow: rgba(87, 169, 79, 0.8) 0px 0px 2px, rgba(0, 0, 0, 0.05) 0px 0px 0px 1px inset;">OK</button><div class="la-ball-fall">
          <div></div>
          <div></div>
          <div></div>
        </div>
      </div>
    </div>
</div>


    