<?php

use backend\models\ItEasyOrder;
use backend\models\ItEasyTeam;
use backend\models\ItEasyOrderProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;
use common\models\User;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Orders';
$this->params['breadcrumbs'][] = $this->title;
// echo Yii::$app->request->url; die;

if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}
?>

<style type="text/css">
    .assignclass{
      float: right;
      margin-top: 50px;
      border: #e2e2e2;
      background-color: #e2e2e2;
      border-radius: 15px;
      padding-top: 18px;
      padding-right: 34px;
    }

      .modal-dialog {
    max-width: 75%;
  }

  .paymentcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 18px;
  }

  .schipingcard {
    box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 100%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin-left: 14px;
  }

  .customercard {
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
    transition: 0.3s;
    width: 92%;
    border-radius: 14px;
    background-color: #cec5f9;
    padding: 20px;
    margin: 10px;
    margin-left: 26px;
    margin-left: 43px;
  }
  .customerform{
    overflow-y: scroll;
    overflow-x: hidden;
  }
.producttable{
box-shadow: 0 4px 8px 0 rgba(81, 66, 66, 0.2);
background-color: #cec5f9;
border-radius: 14px;
width: 93%;
margin-left: 22px;
margin-top: 20px;
height: 275px;
padding: 17px;
margin-left: 43px;
}
  .my-styles {
    border: 1px solid black;
    padding: 15px;
}
.my-styles p{
    border: 1px solid black;
    padding: 10px;
    margin: -1px;
}
.my-styles .iconclor{
color: #fff;
background-color: #48a1bb;
border-color: #48a1bb;
padding: 4px;
}
.ordercusop{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 258px;
  margin-left: -1px;
}

h6{
  background-color: #92a6a0;
  height: 33px;
  padding: 8px;
  color: #fff;
  width: 430px;
  margin-left: -16px;
}
thead, tbody, tfoot, tr, td, th {
  border-color: inherit;
  border-style: solid;
  border-width: 1px;
}
.colorchange{
  color: #fff;
  font-weight: 500;
  padding: 7px;
}
.btncolor{
    background-color: #48a1bb;
    float: right;
}
span{
  margin: 8px;
}
.text-right{
  text-align: right;
}
.ordercount{
  float: right;
background: #50A696;
width: 22px;
height: 22px;
border-radius: 50%;
align-items: center;
text-align: center;
margin-top: -10px;
margin-right: -10px;
cursor: pointer;
font-size:11px;
}
.producttable1{

border-radius: 14px;
width: 93%;

margin-top: 20px;
height: 275px;
padding: 17px;
margin-left: 43px;
}

#duplocateordertbody > tr > td {
  border-color: inherit;
  border-style: solid;
  border-width: 1px;
  /*padding: 10px;*/
  font-size: 12px;
  font-weight: 500;
  text-align: center;
}
.assignclass1{
float: right;
margin-top: 50px;
border: #e2e2e2;
background-color: #e2e2e2;
border-radius: 15px;
padding-top: 18px;
/*padding-right: -3px;*/
width: 98%;
margin-left: 12px;
}
.totalcountbackground{
background-image: linear-gradient(to left, #c6c1c1 0%, gray 100%) !important;
}
</style>

<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
              	<div class="btn-group dropdown">
                    <?= Html::a('<i class="fe fe-refresh-ccw"></i> Refresh Serviceable', ['fetch-serviceable'], ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                </div>
         
              	<div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_platform')->dropDownlist($search_array, ['prompt' => 'Search by Platform Type'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Order number....'])->label(false); ?>
                            </div>
                            
                            

                            

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Order Place via Agent' => 'Order Place via Agent', 'Date Converted' => 'Confirmation Date', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'], ['prompt' => 'Search by Date Type'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_from_date">
                                <?= DatePicker::widget([
                                'name' => 'ItEasyOrderSearch[date_from_date]', 
                                'value' => $searchModel->date_from_date,
                                'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                                'pluginOptions' => [
                                'format' => 'yyyy-mm-dd',
                                'todayHighlight' => true,
                                'autoclose' => true,
                                'placeholder' => 'Search by From date'
                                    ]
                                ]) ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_to_date">
                                    <?= DatePicker::widget([
                                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                                    'value' => $searchModel->date_to_date,
                                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                                    'pluginOptions' => [
                                    'format' => 'yyyy-mm-dd',
                                    'todayHighlight' => true,
                                    'autoclose' => true,
                                        ]
                                    ]) ?>
                                </div>
                            </div>
                            
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_mobile_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Mobile number....'])->label(false); ?>
                            </div>
                            
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_other_order_id')->textInput(['maxlength' => true, 'placeholder' => 'Search by Shopify ID....'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_status_id')->dropDownlist($search_statusdata, [ 'prompt' => 'Search by Order Status'])->label(false); ?>
                            </div>
                                  <div class="col-md-2">
                               <?php $order_dispositiondata['no_disposition'] = "No Disposition";
                               ksort($order_dispositiondata);
                               ?>
                                <?= $form->field($searchModel, 'it_easy_order_disposition_id')->dropDownlist($order_dispositiondata,[ 'prompt' => 'Search By Disposition'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_payment_code')->dropDownlist($payment_method, ['prompt' => 'Search by Payment Mode'])->label(false); ?>
                            </div>

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_first_status')->dropDownlist(['Lead' => 'Lead', 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by First Status'])->label(false); ?>
                            </div>

                            
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_marketer_publisher')->textInput(['maxlength' => true, 'placeholder' => 'Search by Channel Marketer'])->label(false); ?>
                            </div>

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_state_id')->dropDownList($statedata, [ 'prompt' => 'Search by State Name'])->label(false); ?>
                            </div>

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_assigned_by')->dropDownList($tl_data, [ 'prompt' => 'Search by TL Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_assigned_to')->dropDownList($agent_data, [ 'prompt' => 'Search by Agent Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'assign_type')->dropDownList(['Assign' => 'Assign', 'Unassign' => 'Unassign'], [ 'prompt' => 'Search by Assign Type'])->label(false); ?>
                            </div>
                                  <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_awb_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by AWB number....'])->label(false); ?>
                            </div>

                           <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_email')->textInput(['maxlength' => true, 'placeholder' => 'Search by Customer Email....'])->label(false); ?>
                            </div>
                        <!--      <div class="col-md-2">-->
                        <!--<?= $form->field($searchModel, 'it_easy_courier_name')->dropDownList($array_helper_courier, [ 'prompt' => 'Search BY Courier Name....'])->label(false); ?>-->
                        <!--    </div>-->
                            
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                            </div>
                            <?php if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '1' || Yii::$app->user->identity->it_easy_dept_id == '6'): ?>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Export', ['class' => 'btn btn-secondary-gradient btn-block', 'id' => 'order_list_export_index']) ?>
                            </div>
                            <?php endif; ?>
                            	<?php if(Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5'): ?>
                            <div class="col-md-2" style="float: right;">
                                <button type="button" id="order_list_export_agent" class="btn btn-secondary-gradient btn-block">Agentwise Export</button></div>
                                <?php endif; ?>
                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
               
              <div class="assignclass1">
                    <?php if(Yii::$app->user->identity->it_easy_dept_id == '4' && (Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5')){ ?>
                           <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL ASSIGN</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['assign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                          <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL CONFIRM</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['confirm_count']) ? $today_report['confirm_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                        <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TICKET SIZE</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['average_ticket']) ? $today_report['average_ticket'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                      <?php }else{ ?>

                               <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL ASSIGN</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['assign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                          <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL CONFIRM</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['confirm_count']) ? $today_report['confirm_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                  <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL ORDERS</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['total_leads']) ? $today_report['total_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                 
                        <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL UNASSIGN</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['unassign_leads'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                   
                          <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL DISPATCH</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['dispatched_order_count']) ? $today_report['dispatched_order_count'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                          
                          <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TOTAL PREPAID</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['prepaid_order']) ? $today_report['prepaid_order'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>

                              <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">TICKET SIZE</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['average_ticket']) ? $today_report['average_ticket'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-2 col-lg-2 col-md-2 col-xm-12">
                            <div class="card overflow-hidden sales-card totalcountbackground">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                      <h5 class="mb-3 tx-12 text-white">Total Pending Work Order</h5>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['pending_work_order']) ? $today_report['pending_work_order'] : '0'; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                      <?php } ?>
                      </div>        
                
              <?php $form1 = ActiveForm::begin(['id' => 'assigntlagent','action' => ['assign-agent-tl'], 'method' => 'get']); ?>
                <div class="card-body">
                    <input type="hidden" name="url" value='<?= htmlspecialchars(Yii::$app->request->url); ?>'>
                  <?php if(Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5'){
                        
                        if(Yii::$app->user->identity->it_easy_type_id == '3' &&  Yii::$app->user->identity->it_easy_dept_id  == '4'){
                            $team = ItEasyTeam::find()->where(['it_easy_parent_user' => Yii::$app->user->identity->id])->asArray()->one();
                            if(!empty($team)){
                            $agent_array = explode(',', $team['it_easy_child_user']);
                            }else{
                                $agent_array = '';
                            }
                        
                        if(!empty($team)){
                            $parent_id = $team['it_easy_parent_user'];
                        }else{
                            $parent_id = '';
                        }
                  
                  ?>
                            <div class="col-md-6 assignclass">
                <p style="margin-left: 12px;font-size: 20px;font-family: initial;">Assign Status & Disposition</p>
                <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_by')->dropDownList(
                 ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>4])->andWhere(['it_easy_type_id'=>3])->andWhere(['id' => $parent_id])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Select TL', 'id' => 'gettl'])->label(false) ?>
                 </div>
                   <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_to')->dropDownList(
                ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>4])->andWhere(['in','it_easy_type_id',[4,5]])->andWhere(['in', 'id', $agent_array])->asArray()->all(),'id','it_easy_firstname'),['prompt' => 'Select Agent', 'id' => 'getagent'])->label(false) ?>
                </div>
                <div class="col-md-2">
                <button type="submit" onclick="getOrderassign()" style="background-color:#ffb174" class="btn btn-dark">Assign</button>
                </div>
                </div>
                
                <?php }elseif(Yii::$app->user->identity->it_easy_type_id == '3' &&  Yii::$app->user->identity->it_easy_dept_id  == '9'){
                            $team = ItEasyTeam::find()->where(['it_easy_parent_user' => Yii::$app->user->identity->id])->asArray()->one();
                            if(!empty($team)){
                            $agent_array = explode(',', $team['it_easy_child_user']);
                            }else{
                                $agent_array = '';
                            }
                        
                        if(!empty($team)){
                            $parent_id = $team['it_easy_parent_user'];
                        }else{
                            $parent_id = '';
                        }
                  
                  ?>
                            <div class="col-md-6 assignclass">
                <p style="margin-left: 12px;font-size: 20px;font-family: initial;">Assign Status & Disposition</p>
                <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_by')->dropDownList(
                 ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>9])->andWhere(['it_easy_type_id'=>3])->andWhere(['id' => $parent_id])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Select TL', 'id' => 'gettl'])->label(false) ?>
                 </div>
                   <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_to')->dropDownList(
                ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>9])->andWhere(['in','it_easy_type_id',[4,5]])->andWhere(['in', 'id', $agent_array])->asArray()->all(),'id','it_easy_firstname'),['prompt' => 'Select Agent', 'id' => 'getagent'])->label(false) ?>
                </div>
                <div class="col-md-2">
                <button type="submit" onclick="getOrderassign()" style="background-color:#ffb174" class="btn btn-dark">Assign</button>
                </div>
                </div>
                
                <?php }else{ ?>
                    <div class="col-md-6 assignclass">
                <p style="margin-left: 12px;font-size: 20px;font-family: initial;">Assign Status & Disposition</p>
                <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_by')->dropDownList(
                 ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>4])->andWhere(['it_easy_type_id'=>3])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Select TL', 'id' => 'gettl'])->label(false) ?>
                 </div>
                   <div class="col-md-5">
                <?= $form1->field($searchModel, 'it_easy_assigned_to')->dropDownList(
                ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'ACTIVE'])->andWhere(['it_easy_dept_id'=>4])->andWhere(['in','it_easy_type_id',[4,5]])->asArray()->all(),'id','it_easy_firstname'),['prompt' => 'Select Agent', 'id' => 'getagent'])->label(false) ?>
                </div>
                <div class="col-md-2">
                <button type="submit" onclick="getOrderassign()" style="background-color:#ffb174" class="btn btn-dark">Assign</button>
                </div>
                </div>
              <?php } } ?>
                  
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                // 'filterModel' => $searchModel,
                
                'rowOptions' => function ($model) {
                    if($model->it_easy_read_status == '0'){
                        return ['style' => 'background-color:#cbc9c9;text-align:center'];
                    }
                    return ['style' => 'text-align:center;'];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    ['class' => 'yii\grid\CheckboxColumn'],

                    [
                       'label' => 'Order-Number',
                       'format' => 'raw',
                       'attribute' =>'it_easy_order_number',
                       'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],

                       'value' => function ($model) {
                            $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                            $count_order = ItEasyOrder::GetOrderStatusNamebymobile($model->it_easy_mobile_number);
                            $it_easy_flag =  $model->it_easy_flag;
                            $shortAddress = mb_substr((string) $model->address_validator_response, 0, 20);
                            return (!empty($count_order[0]['cnt']) ?'<span class="ordercount" data-target="#duplicateorder" data-toggle="modal" data-id="' . $model->it_easy_mobile_number . '">'.$count_order[0]['cnt'].'</span>' : '').'<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'<br>'.$model->it_easy_platform.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name.'<br><span style="color:#e18a02;"><b>'.$it_easy_flag.'</b></span><br><span style="color:#e18a02;"><b>'.$shortAddress.'</b></span>';
                            
                       }
                    ],
                    [
                       'label' => 'Customer-Info',
                       'format' => 'raw',
                       'attribute' =>'it_easy_firstname',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                            
                            return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email.'<br>'.$model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;
                            
                       }
                    ],


                

                    [
                       'label' => 'TL/Agent',
                       'format' => 'raw',
                       'attribute' =>'it_easy_assigned_to',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                           if(isset(Yii::$app->user->identity->it_easy_dept_id) && Yii::$app->user->identity->it_easy_dept_id == '9'){
                                $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_retention_TLid, $model->it_easy_retention_AGENTid);
                           }else{
                               $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_assigned_by, $model->it_easy_assigned_to);
                           }
                            return $get_agent_tl_name;
                            
                       }
                    ],
                    
                    [
                       'label' => 'Total',
                       'format' => 'raw',
                       'attribute' =>'it_easy_coupon_id',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                           
                           $coupon_data = ItEasyOrder::getCoouponbyid($model->it_easy_coupon_id);
                            if(!empty($coupon_data)){
                                
                                if(isset(Yii::$app->user->identity->it_easy_type_id) && Yii::$app->user->identity->it_easy_type_id == '3'){
                                    $coupon = '<span style="font-size:16px;">System- </span><br><span style="font-size:16px;"></span><br>Coupon('.$coupon_data->it_easy_coupon_code.')<br>₹'.number_format((float)$coupon_data->it_easy_discount, 2, '.', '').'<br>Total Outstanding<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_understanding, 2, '.', '').'</span><br>Total Paid<span style="font-size:16px;">'.number_format((float)$model->it_easy_partially_paid, 2, '.', '').'</span>';
                                }else{
                                    $coupon ='<span style="font-size:16px;">System- ₹'.number_format((float)$model->it_easy_ordered_amount, 2, '.', '').'</span><br>Final-Amount- ₹<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_price, 2, '.', '').'</span><br>Coupon('.$coupon_data->it_easy_coupon_code.')<br>₹'.number_format((float)$coupon_data->it_easy_discount, 2, '.', '').'<br>Total Outstanding<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_understanding, 2, '.', '').'</span><br>Total Paid<span style="font-size:16px;">'.number_format((float)$model->it_easy_partially_paid, 2, '.', '').'</span>';
                                }
                            }else{
                                $coupon = '<span style="font-size:16px;">System- ₹'.number_format((float)$model->it_easy_ordered_amount, 2, '.', '').'</span><br>Final-Amount- ₹<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_price, 2, '.', '').'</span><br>Total Outstanding<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_understanding, 2, '.', '').'</span><br>Total Paid<span style="font-size:16px;">'.number_format((float)$model->it_easy_partially_paid, 2, '.', '').'</span>';
                            }
                            return $coupon;
                            
                       }
                    ],
                    
                    
                    [
                       'label' => 'Disposition',
                       'format' => 'raw',
                       'attribute' =>'it_easy_order_disposition_id',
                       'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                       'value' => function ($model) {
                           
                            $get_status_name = ItEasyOrder::GetOrderDispositionNamebystatusId($model->it_easy_order_disposition_id);
                            return $get_status_name;
                            
                       }
                    ],
                  
                  	[
                      'label' => 'Product Name',
                      'format' => 'raw',
                      'attribute' =>'it_easy_device',
                      'contentOptions' => ['style' => 'line-height: 10px;font-size: 14px;padding:6px;'],
                      'value' => function ($model) {
                        $order_product = ItEasyOrderProduct::find()->where(['it_easy_order_id' => $model->it_easy_order_id])->asArray()->all();
                        $str = '';
                        $str = '<span style="font-size:12px; font-weight: 600;font-family: monospace;">';
                        foreach($order_product as $key => $product){
                            $shortProduct = mb_substr((string) $product['it_easy_product_name'], 0, 17);
                          $str .= $shortProduct.'<br>';
                        }
                        $str .= '</span>';
                        return $str;

                      }
                    ],

                    // [
                    //   'label' => 'Serviceable',
                    //   'format' => 'raw',
                    //   'attribute' =>'it_easy_order_serviceable',
                    //   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                    //   'value' => function ($model) {
                    //         if(!empty($model->it_easy_order_serviceable)){
                    //             $get_serviceable_name = ItEasyOrder::GetServiceableClickCourierName($model->it_easy_order_serviceable);
                    //             $str_serviceable = '';
                    //             if(!empty($get_serviceable_name)){
                    //                 $count_serviceable = count($get_serviceable_name);
                    //                 $check_serviceable = $count_serviceable - 1; 
                    //                 foreach ($get_serviceable_name as $key => $service){
                    //                     if($key == $check_serviceable){
                    //                         $str_serviceable .= $service->courier_name;
                    //                     }else{
                    //                         $str_serviceable .= $service->courier_name.'<br>';
                    //                     }
                    //                 }
                    //             }    
                    //             return $str_serviceable;
                    //         }else{
                    //             return '';
                    //         }
                    //   }
                    // ],
                    
                    [
                        'label' => 'Publisher/SSD',
                       'format' => 'raw',
                       'attribute' =>'it_easy_marketer_publisher',
                       'value' => function ($model) {
                            $shortMarketer = mb_substr((string) $model->it_easy_marketer_publisher, 0, 14);
                            $shortClicks = mb_substr((string) $model->it_easy_marketer_click_id, 0, 14);
                            return $shortMarketer.'<br>'.$shortClicks;
                       }
                    ],
                    [
                        'label' => 'Created',
                       'format' => 'raw',
                       'attribute' =>'it_easy_created_time',
                       'value' => function ($model) {
                           
                            if(!empty($model->it_easy_updated_time)){
                                $update_time = date('Y-m-d', strtotime($model->it_easy_updated_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_updated_time));
                              }else{
                                $update_time = '';
                              }
                           
                           
                            return date('Y-m-d', strtotime($model->it_easy_created_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_created_time)).'<br>'.$update_time;
                       }
                    ],
                            [
                  'label' => 'Action',
                  'format' => 'raw',
                  'value' => function ($model) {
                   if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '1' || Yii::$app->user->identity->it_easy_dept_id == '9'){
                    if(Yii::$app->user->identity->it_easy_type_id != '4' && Yii::$app->user->identity->it_easy_type_id != '5'){   
                      if($model['it_easy_order_status_id'] == '21'){
                        $buttons = '';
                       $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#confirmstatus" style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 120px;background-color:#26af31" class="cancelorder btn btn-info btnw btn-sm" data-toggle="tooltip" title=""  href="javascript:void(0)"  data-original-title="Confirm Status">Confirm-Status</a><br><br>';
                       
                       $buttons .= '<a data-id="' . $model->it_easy_order_id . '" data-toggle="modal" data-target="#disapproved_button" class="cancelorder btn btn-info btnw btn-sm hide" data-toggle="tooltip" title=""  href="javascript:void(0)"  data-original-title="Disapproved" style= "color: #fff;background-color: #f56b6b !important;border-color: #f24545;">Disapproved</a><br>';
                    
                          //$buttons .= '<button style= "color: #fff;background-color: #f56b6b;border-color: #f24545;"  type="button" class="btn btn-info btnw btn-sm hide'.$model->it_easy_order_id.'" onclick="return getconfirmordisapproved('.$model->it_easy_order_id.',2)" >Disapproved</button>';
    
                          return $buttons;
                        }else{
                          return '';
                        }
                    }
                    }
                    },

          
                ],
                                [
                  
                  'format' => 'raw',
                  'value' => function ($model) {
                    $buttons = '';
                    if(Yii::$app->user->identity->it_easy_dept_id == '8' || Yii::$app->user->identity->it_easy_dept_id == '4' || Yii::$app->user->identity->it_easy_dept_id == '1' || Yii::$app->user->identity->it_easy_dept_id == '9'){
                        
                        if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                            $array_5=array('1', '2', '3', '4', '5','6', '9', '14', '15', '16','22', '23', '24', '26', '27','28', '29', '30', '31', '48', '47');
                            
                            if (!in_array($model->it_easy_order_status_id,$array_5)){
                                
                                $buttons .= '<a target="_blank" href='.BASE_URL.'order/update?it_easy_order_id='.$model->it_easy_order_id.' ?><button style= "color: #fff;background-color: #1e91cf;border-color: #1978ab;" type="button" class="btn btn-info btnw btn-sm"><i class="typcn typcn-pencil"></i></button></a>';
                                
                            }
                        }else{
                    $buttons .= '<a target="_blank" href='.BASE_URL.'order/update?it_easy_order_id='.$model->it_easy_order_id.' ?><button style= "color: #fff;background-color: #1e91cf;border-color: #1978ab;" type="button" class="btn btn-info btnw btn-sm"><i class="typcn typcn-pencil"></i></button></a>';
                        }
                    }

                     $buttons .= '<a data-toggle="modal" data-target="#vieworder"><button style= "color: #fff;background-color: #5bc0de;border-color: #39b3d7;" href="javascript:void(0)" value="' . $model->it_easy_order_id . '" id="abcd" class="getvieworder btn btn-info btnw btn-sm"><i class="typcn typcn-eye"></i></button></a>';

                     $buttons .= '<br><a style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;" class="md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title="Refresh Serviceable" href="'.BASE_URL.'order/fetch-serviceable?it_easy_order_id='.$model->it_easy_order_id.'"><i class="fe fe-refresh-ccw"></i></a><br>';
                     $buttons .= '<br><a style= "margin: 3px 5px;display: inline-block;border-radius: 6px;width: 70px;" class="md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title="Track Order History" href="'.BASE_URL.'ndr/trackhistory?it_easy_order_id='.$model->it_easy_order_id.'"  target="_blank">Track</a><br>';

                      return $buttons;
                 
                    },

          
                ],
                ],
            ]); ?>
                    </div>
                </div>
            </div>
           <?php ActiveForm::end(); ?>
        </div>
        <!--/div-->
    </div>
</div>

<div class="modal fade" id="vieworder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;height: 500px;">
      <div class="modal-header">
        <h5>Order#<span id='printordernumber'></span></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
  
      <div class="modal-body customerform">
        <div class="row">

          <input type="hidden" id="getvieworderid" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard my-styles">
            <div class="col-md-4  my-styles">
              <h6 class="ordercusop"><i class="typcn typcn-shopping-cart"></i> Order Details</h6>
              <p><i class="typcn typcn-shopping-cart iconclor"></i><span  id="storename"></span></p>
              <p><i class="fa fa-calendar iconclor"></i><span  id="createdtime"></span></p>
              <p><i class="fe fe-credit-card iconclor"></i><span  id="paymentmethod"></span></p>
             
              <p><i class="fa fa-globe iconclor"></i><span  id="website"></span></p>
            </div>
            <div class="col-md-4 my-styles">
               <h6 class="ordercusop"><i class="far fa-user"></i> Customer Details</h6>
              <p><i class="far fa-user iconclor"></i><span  id="name"></span></p>
              
              <p><i class="fa fa-envelope iconclor"></i><span  id="email"></span></p>
              <p><i class="fa fa-phone iconclor"></i> <span  id="phone"></span></p>
              <p><i class="fa fa-mobile iconclor"></i> <span  id="mobile"></span></p>
            </div>
            <div class="col-md-4 my-styles">
               <h6 class="ordercusop"><i class="la la-cog"></i>Options</h6>
              <p>Customer Online Payment Link  &nbsp&nbsp <i class="typcn typcn-plus iconclor"></i></p>
              
            </div>
          </div>
          <div class="row">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard">
                  <h6>Payment Address</h6><br>
                  <div class="row">
                    <span  id="billname"></span>
                    <span  id="billadd1"></span>
                    <span  id="billadd2"></span>
                    <span  id="billcitypin"></span>
                    <span  id="billstate"></span>
                   
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="schipingcard">
                  <h6>Shiping Address</h6><br>
                  <div class="row">
                  <span  id="shipname"></span>
                  <span  id="shipadd1"></span>
                  <span  id="shipadd2"></span>
                  <span  id="shipcitypin"></span>
                  <span  id="shipstate"></span>
              </div>
            </div>
          </div>
        </div>
        </div>

        <div class="row producttable">
          <div class="col-md-12">
          <table id='mltipleproduct' style="width: 105%;margin-left: -22px;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Product</span></td>
      
                <td><span class="colorchange">Quantity</span></td>
                <td><span class="colorchange">Unit Price</span></td>
                <td><span class="colorchange">Total</span></td></tr>
            </thead>
            <tbody id='tbodyprint'>
      
            </tbody>
            <tfoot id='tfootprint'>
                
            </tfoot>
          </table> 
          </div>         
        </div> 

            <div class="row" style="margin-top: 20px;">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard" style="min-height: 347px;">
                  <h6>Order History</h6><br>
                  <div class="row">
                      
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
                
            
            </thead>
            <tbody id="addstatustable">
            
            </tbody>
        
          </table> 

            </div>
          </div>
        </div>

        <div class="col-md-6">
          <div class="schipingcard" id="status_class_remove">
            <h6>Add Order History</h6><br>
           
            <div class="row">
            <div class="col-md-12">
            <?= $form->field($model, 'it_easy_order_status_id')->dropDownList($order_statusdata, ['prompt' => 'Select Order Status'])->label('Order Status'); ?>
        
            </div>
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_comment')->textArea(['maxlength' => true])->label('Comment**') ?>
            </div>

            <div class="col-md-12">
                <p id='message' style="color: red"></p> 
                <p id='message1' style="color: red"></p> 
             <button type="submit" class="btn btn-primary btncolor orderhistory">Add History</button>
           </div>

              </div>
               
            </div>
          </div>


        </div>
        </div> 
          

              <div class="row" style="margin-top: 20px;">
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="paymentcard" id="disposition_class_remove">
                  <h6>Disposition Add Order History</h6><br>
                  <div class="row" >
            <div class="col-md-12">
          <?= $form->field($model, 'it_easy_order_disposition_id')->dropDownList(
        ArrayHelper::map(ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->where(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type'=>'Order'])->asArray()->all(),'it_easy_order_disposition_id','it_easy_order_disposition_name'),['prompt' => 'Please Select'])->label('Select Disposition') ?>
            </div>
            <div class="col-md-12">
              <div class="form-group field-iteasyorder-it_easy_comment">
            <label class="control-label" for="iteasyorder-it_easy_comment">Comment**</label>
            <textarea id="iteaydispo-it_easy_comment" class="form-control" name="ItEasyOrder[it_easy_comment]" maxlength="255"></textarea>

            <div class="help-block"></div>
            </div>
             
            </div> 
            <div class="col-md-12">
            <p id='dispomess' style="color: red"></p> 
                <p id='dispomess1' style="color: red"></p> 
             <button type="submit" class="btn btn-primary btncolor dispohistory">Add History</button>
           </div>

            </div>
          </div>
        </div>

        <div class="col-md-6">
          <div class="schipingcard" style="min-height: 347px;">
            <h6>Disposition Order History</h6><br>
            <div class="row">
                              
            <table style="width: 100%;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Date Added</span></td>
                <td><span class="colorchange">Comment</span></td>
                <td><span class="colorchange">Status</span></td>
          
            
            </thead>
            <tbody id="dispostaustable">
         
            </tbody>
        
          </table> 
              </div>
            </div>
          </div>


        </div>
        </div> 



      </div>
    </div>
  </div>
</div>
</div>


<div class="modal fade" id="confirmstatus" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Cancel Order History</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['order/confirm-status'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="cancelorder" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_order_status_id')->dropDownList(
        ['1'=> 'Confirm Order'])->label('Order Status') ?>
            </div>
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_flag')->dropDownList(
        ['Assured Delivery'=> 'Assured Delivery', 'Dice Delivery' => 'Dice Delivery'])->label('Quality Flag') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="disapproved_button" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;">
      <div class="modal-header">
        <h5>Disapproved Order History</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php $form = ActiveForm::begin(['action' => ['order/disapproved-status'], 'method' => 'post']); ?>
      <div class="modal-body">
        <div class="row">

          <input type="hidden" id="cancelorder" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
          <div class="customercard">
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_order_status_id')->dropDownList(
        ['7'=> 'Hold Order'])->label('Order Status') ?>
            </div>
            
            <div class="col-md-12">
              <?= $form->field($model, 'it_easy_flag')->textInput()->label('Comment') ?>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

            <?= Html::submitButton('Save', ['class' => 'btn btn-primary']) ?>
          </div>
          <?php ActiveForm::end(); ?>
        </div>
      </div>
    </div>
  </div>
</div>



<div class="modal fade" id="duplicateorder" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content" style="background-color: #d2caca;height: 500px;">
      <div class="modal-header">
       
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
  
      <div class="modal-body customerform">
        <div class="row">

          <input type="hidden" id="getvieworderid" class="form-control" name="ItEasyOrder[it_easy_order_id]" value="" aria-required="true" aria-invalid="false">
       
  

        <div class="row producttable1">
          <div class="col-md-12">
          <table id='mltipleproduct' style="width: 105%;margin-left: -27px;margin-top: -31px;">
            <thead style="background-color: #92a6a0;">
              <tr>
                <td><span class="colorchange">Order-Number</span></td>
      
                <td><span class="colorchange">Customer-Info</span></td>
                <td><span class="colorchange">Address</span></td>
                <td><span class="colorchange">Total/Coupon</span></td>
                <td><span class="colorchange">TL/Agent</span></td>
                <td><span class="colorchange">Disposition</span></td>
                <td><span class="colorchange">Created</span></td>
                <td><span class="colorchange">Updated</span></td>
              </tr>
            </thead>
            <tbody id='duplocateordertbody'>
           
            </tbody>
         
          </table> 
          </div>         
        </div> 

      </div>
    </div>
  </div>
</div>
</div>
