<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Sale & Retention Report';
$this->params['breadcrumbs'][] = $this->title;

if(isset($searchModel->it_easy_first_status) && $searchModel->it_easy_first_status == 'Retention'){
    $retention_text = 'Retention';
}else if(isset($searchModel->it_easy_first_status) && $searchModel->it_easy_first_status == 'Abondoned'){
    $retention_text = 'Abondoned';
}else{
    $retention_text = "";
}
?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 22px;
      margin-top: 13px;
      margin-bottom: 15px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
  th{
    font-size: 16px !important;
    font-family: monospace;
    font-weight: bolder !important;
    text-align: center !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <div class="row row-sm" style="margin-top: 40px;
    background: #edecec;
    padding-top: 20px;
    border-radius: 9px;">
          <div class="col-xl-1 col-md-1"> </div>
        <div class="col-xl-11 col-md-11">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['report-proper'],'method' => 'get']); ?>
                
                  
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_first_status')->dropDownlist(['Fresh' => 'Fresh', 'Retention' => 'Retention', 'Abondoned' => 'Abondoned'], ['prompt' => 'Search by Order Type'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added',  'Date Assigned' => 'Date Assigned'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m').'-01' : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
                

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    

    <!-- row opened -->
    <div class="row row-sm">
      <div class="col-md-12">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'rowOptions' => function ($model) {
                  return ['style' => 'text-align:center;font-family: "Roboto";font-weight: bolder;'];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    [
                       'label' => 'Channel Name',
                       'format' => 'raw',
                       'attribute' =>'it_easy_marketer_publisher',
                       'value' => function ($model) {
                           if(isset($retention_text) && ($retention_text == 'Retention')){
                               if(empty($model['it_easy_marketer_publisher'])){
                                    return "Retention";
                               }else{
                                   return $model['it_easy_marketer_publisher'];
                               }
                           }else if(isset($retention_text) && ($retention_text == 'Abondoned')){
                               if(empty($model['it_easy_marketer_publisher'])){
                                    return "Abondoned";
                               }else{
                                   return $model['it_easy_marketer_publisher'];
                               }
                           }else{
                               return $model['it_easy_marketer_publisher'];
                           }
                           
                       }
                    ],
                    [
                       'label' => 'Total Order',
                       'format' => 'raw',
                       'attribute' =>'total_order_number',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['total_order_number'].'</span> <span style="float:right;">'.$model['sum_assign_total'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Confirm Order',
                       'format' => 'raw',
                       'attribute' =>'confirm_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['confirm_count'].'</span> <span style="float:right;">'.$model['confirm_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Pending Order',
                       'format' => 'raw',
                       'attribute' =>'pending_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['pending_count'].'</span> <span style="float:right;">'.$model['pending_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'AWB Order',
                       'format' => 'raw',
                       'attribute' =>'awb_assign_number',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['awb_assign_number'].'</span> <span style="float:right;">'.$model['awb_assign_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Dispatch Order',
                       'format' => 'raw',
                       'attribute' =>'dispatch_number',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['dispatch_number'].'</span> <span style="float:right;">'.$model['dispatch_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Delivered Order',
                       'format' => 'raw',
                       'attribute' =>'delivered_order_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['delivered_order_count'].'</span> <span style="float:right;">'.$model['delivered_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                    
                ],
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
      </div>
    </div>

</div>
