<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Agent Data Analysis';
$this->params['breadcrumbs'][] = $this->title;

if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}
?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 22px;
      margin-top: 13px;
      margin-bottom: 15px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
  th{
    font-size: 16px !important;
    font-family: monospace;
    font-weight: bolder !important;
    text-align: center !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <div class="row row-sm" style="margin-top: 40px;
    background: #edecec;
    padding-top: 20px;
    border-radius: 9px;">
          <div class="col-xl-1 col-md-1"> </div>
        <div class="col-xl-11 col-md-11">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['report-sale'],'method' => 'get']); ?>
                
                  <div class="col-md-2">
                    <?php if((Yii::$app->user->identity->it_easy_type_id != '3')){ ?>
                        <?= $formsearch->field($searchModel, 'it_easy_assigned_by')->dropDownList($tl_data, [ 'prompt' => 'Search by TL Name'])->label(false); ?>

                      <?php } ?>
                    </div>
                    <div class="col-md-2">
                        
                        <?= $formsearch->field($searchModel, 'it_easy_platform')->dropDownlist($search_array, ['prompt' => 'Search by Platform Type'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m').'-01' : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_from_date) ? date('Y-m-d') : $searchModel->date_from_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
                

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    

    <!-- row opened -->
    <div class="row row-sm">
      <div class="col-md-12">
        <div class="col-xl-12">
            
            <div class="card">
                
                <div class="card-body">
                    <div style="float: right;">
                        <?= Html::submitButton('Status Wise Export', ['class' => 'btn btn-secondary-gradient btn-block', 'id' => 'order_list_statusexport_index']) ?>
                    </div>
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                'rowOptions' => function ($model) {
                  return ['style' => 'text-align:center;font-family: "Roboto";font-weight: bolder;'];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    [
                       'label' => 'Username',
                       'format' => 'raw',
                       'attribute' =>'it_easy_assigned_to',
                       'value' => function ($model) {
                            $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model['it_easy_assigned_to'], '0');
                            return $get_agent_tl_name;  
                       }
                    ],
                    [
                       'label' => 'Assign Order',
                       'format' => 'raw',
                       'attribute' =>'total_assign_number',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['total_assign_number'].'</span> <span style="float:right;">'.$model['sum_assign_total'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Confirm Order',
                       'format' => 'raw',
                       'attribute' =>'confirm_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['confirm_count'].'</span> <span style="float:right;">'.$model['ordered_confirm_sum'].' / '.$model['confirm_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Dispatch Order',
                       'format' => 'raw',
                       'attribute' =>'dispatched_order_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['dispatched_order_count'].'</span> <span style="float:right;">'.$model['dispatched_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Delivered Order',
                       'format' => 'raw',
                       'attribute' =>'delivered_order_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['delivered_order_count'].'</span> <span style="float:right;">'.$model['delivered_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Hold Order',
                       'format' => 'raw',
                       'attribute' =>'hold_order_count',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['hold_order_count'].'</span> <span style="float:right;">'.$model['hold_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'RTO Order',
                       'format' => 'raw',
                       'attribute' =>'rto_order_sum',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['rto_order_count'].'</span> <span style="float:right;">'.$model['rto_order_sum'].'</span>&nbsp;';  
                       }
                    ],

                    [
                       'label' => 'Cancelled Order',
                       'format' => 'raw',
                       'attribute' =>'cancelled_order_sum',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['cancelled_order_count'].'</span> <span style="float:right;">'.$model['cancelled_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                    [
                       'label' => 'Prepaid Order',
                       'format' => 'raw',
                       'attribute' =>'preapaid_order_sum',
                        'value' => function ($model) {
                            return '&nbsp;<span style="float:left;">'.$model['prepaid_order_count'].'</span> <span style="float:right;">'.$model['preapaid_order_sum'].'</span>&nbsp;';  
                       }
                    ],
                ],
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
      </div>
    </div>
    <div class="row row-sm">
      <div class="col-md-12" style="    padding-left: 22px;
    padding-right: 22px;">
      <div class="breadcrumb-header justify-content-between">
          <div class="my-auto">
              <div class="d-flex">
                  <h4 class="content-title mb-0 my-auto">Disposition Data Analysis</h4>
              </div>
          </div>
      </div>
      </div>
    </div>
      <div class="row row-sm">
        <div class="col-md-12">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    
                    <div style="float: right;">
                        <?= Html::submitButton('Disposition Wise Export', ['class' => 'btn btn-secondary-gradient btn-block', 'id' => 'order_list_dispositionexport_index']) ?>
                    </div>
                    
                    
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider2,
                'rowOptions' => function ($model) {
                  return ['style' => 'text-align:center;font-family: "Roboto";font-weight: bolder;'];
                },
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    [
                       'label' => 'Username',
                       'format' => 'raw',
                       'attribute' =>'it_easy_assigned_to',
                       'value' => function ($model) {
                            $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model['it_easy_assigned_to'], '0');
                            return $get_agent_tl_name;  
                       }
                    ],
                    [
                       'label' => 'T-Assign',
                       'format' => 'raw',
                       'attribute' =>'total_assign',
                       
                    ],
                    [
                       'label' => 'CallBack',
                       'format' => 'raw',
                       'attribute' =>'callback_req_count',
                    ],
                    [
                       'label' => 'N.Connect',
                       'format' => 'raw',
                       'attribute' =>'not_connected_count',
                    ],
                    [
                       'label' => 'N.I.',
                       'format' => 'raw',
                       'attribute' =>'not_intrested_count',
                    ],
                    [
                       'label' => 'Duplicate',
                       'format' => 'raw',
                       'attribute' =>'duplicate_count',
                    ],

                    [
                       'label' => 'Fake',
                       'format' => 'raw',
                       'attribute' =>'fake_order_count',
                    ],

                    [
                       'label' => 'NotService',
                       'format' => 'raw',
                       'attribute' =>'area_not_ser_count',
                    ],
                    [
                       'label' => 'C.Discnnect',
                       'format' => 'raw',
                       'attribute' =>'call_disconnected_count',
                    ],
                    [
                       'label' => 'Medical',
                       'format' => 'raw',
                       'attribute' =>'medical_condition_count',
                    ],
                    [
                       'label' => 'Language',
                       'format' => 'raw',
                       'attribute' =>'language_arrier',
                    ],
                    [
                       'label' => 'Promise Order',
                       'format' => 'raw',
                       'attribute' =>'promise_To_order_count',
                    ],
                    [
                       'label' => 'Order Placed',
                       'format' => 'raw',
                       'attribute' =>'order_placed_count',
                    ],
                ],
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
      </div>
    </div>





</div>
