<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyPaymentGateway $model */

$this->title = $model->it_easy_id;
$this->params['breadcrumbs'][] = ['label' => 'It Easy Payment Gateways', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="it-easy-payment-gateway-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'it_easy_id' => $model->it_easy_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'it_easy_id' => $model->it_easy_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'it_easy_id',
            'it_easy_name',
            'it_easy_api_key',
            'it_easy_api_secret',
            'it_easy_api_password',
            'it_easy_status',
            'it_easy_created_time',
            'it_easy_updated_time',
            'it_easy_created_by',
            'it_easy_updated_by',
        ],
    ]) ?>

</div>
