<?php

use backend\models\ItEasyProductMaterial;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyProductMaterialSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'It Easy Product Materials';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="it-easy-product-material-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create It Easy Product Material', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'it_easy_id',
            'it_easy_material_name',
            'it_easy_material_form',
            'it_easy_material_weight_type',
            'it_easy_material_quantity',
            //'it_easy_material_type',
            //'it_easy_status',
            //'created_time',
            //'updated_time',
            //'created_by',
            //'updated_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, ItEasyProductMaterial $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                 }
            ],
        ],
    ]); ?>


</div>
