<?php

use backend\models\ItEasyProductMaterial;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyProductMaterialSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Product Materials';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control{
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none; 
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Product Materials', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                            <div class="row">
                                <div class="col-md-12">
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_material_name')->textInput(['maxlength' => true, 'placeholder' => 'Search Material Name....'])->label(false); ?>
                            </div>
                              <div class="col-md-4">
                                 <?= $form->field($searchModel, 'it_easy_material_type')->dropDownList([''=>'Search By Product Material Type','ingredients' => 'Ingredients', 'bottel' => 'Bottel', 'capsule' => 'Capsule', 'label' => 'Label','digital'=>'Digital', 'other' => 'Other'])->label(false); ?>
                            </div>
                            <div class="col-md-4">
                               
                                 <?= $form->field($searchModel, 'it_easy_material_form')->dropDownList([''=>'Search By Material Form','powder' => 'Powder', 'liquid' => 'Liquid','solid'=>'Solid','digital'=>'Digital', 'other' => 'Other'])->label(false); ?> 
                            </div>
                            </div>
                            </div>
                                <div class="row">
                            <div class="col-md-12">
                            <div class="col-md-6">
                                 

                                 <?= $form->field($searchModel, 'it_easy_material_weight_type')->dropDownList([''=>'Search By Material Weight','kilogram' => 'Kilogram', 'liter' => 'Liter','quantity-in-number'=>'Quantity In Number'])->label(false); ?>  
                            </div>
                        
                             <div class="col-md-6">
                                <?= $form->field($searchModel, 'it_easy_status')->dropDownList([ 'Active' => 'Active', 'Inactive' => 'Inactive'], ['prompt' => 'Search by Status'], ['class'=>'form-control select2-no-search select2-hidden-accessible'])->label('Status')->label(false); ?>
                            </div>
                            </div>
                            </div>
                            <div class="col-md-2">
                            </div>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                
                                'it_easy_material_name',
                                'it_easy_material_type',
                                 'it_easy_material_quantity',
                                'it_easy_material_weight_type',
                                'it_easy_status',
                        [
                            'class' => ActionColumn::className(),
                            'template' => '{update}',
                            'urlCreator' => function ($action, ItEasyProductMaterial $model, $key, $index, $column) {
                                return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                             }
                        ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>