<?php

use backend\models\ItEasyProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use backend\models\ItEasyProductCategory;
use backend\models\ItEasyProductBrand;
use backend\models\ItEasyUserPermissionGroup;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyProductSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Products';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control{
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none; 
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Product', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>

                                  <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_product_category_id')->dropDownList(
                            ArrayHelper::map(ItEasyProductCategory::find()->select(['it_easy_id', 'it_easy_category_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_category_name'),[
                                     'prompt' => 'Search By Category'])->label(false) ?>
                            </div>
                          
                          	<div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_product_brand_id')->dropDownList(
                            ArrayHelper::map(ItEasyProductBrand::find()->select(['it_easy_id', 'it_easy_brand_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_brand_name'),[
                                     'prompt' => 'Search By Brand'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                              <?= $form->field($searchModel, 'it_easy_product_name')->textInput(['maxlength' => true, 'placeholder' => 'Search By Product Name....'])->label(false); ?>
                            </div>
                        
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_product_status')->dropDownList([''=>'Search By Status', 'Active' => 'Active', 'In-Active' => 'In-Active'],  ['class'=>'form-control select2-no-search select2-hidden-accessible'])->label(false);; ?>
                            </div>
                 
                            <div class="col-md-2" style="float: right; margin-top: 8px;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                
                                // 'it_easy_material_id',
                                     // [
                           //'label' => 'Product Category',
                           //'attribute' => 'it_easy_product_category_id',
                           //'value' => function ($model) {
                            //    $pagecategory = ItEasyProductCategory::find()->select(['it_easy_id', 'it_easy_category_name'])->where(['it_easy_id' => $model->it_easy_product_category_id ])->asArray()->one(); 
                              //  return $pagecategory['it_easy_category_name'];
                              //     }
                               // ],
                              
                               [
                           'label' => 'Product Brand',
                           'attribute' => 'it_easy_product_brand_id',
                           'value' => function ($model) {
                             
                         		$pagecategory = ItEasyProductBrand::find()->select(['it_easy_id', 'it_easy_brand_name'])->where(['it_easy_id' => $model->it_easy_product_brand_id])->asArray()->one();
                             if(!empty($pagecategory)){
                                return $pagecategory['it_easy_brand_name'];
                             }else{
                               return "";
                             }
                             
                                   }
                                ],
                                
                            'it_easy_product_name',
                            'it_easy_product_sku',
                            //'it_easy_product_description:ntext',
                            //'it_easy_product_type',
                            //'it_easy_weight_type',
                            //'it_easy_product_one_bottle_quantity',
                            'it_easy_product_quantity',
                            //'it_easy_product_stock_id',
                            'it_easy_product_price',
                            //'it_easy_product_mrp',
                            //'it_easy_tax_price',
                            //'it_easy_price_without_tax',
                            //'it_easy_product_tax',
                            //'it_easy_product_image',
                            //'it_easy_product_width',
                            //'it_easy_product_height',
                            //'it_easy_product_length',
                            //'it_easy_product_feature_status',
                            
                            'it_easy_product_status',
                            //'it_easy_product_approved_by',
                            //'created_time',
                            //'updated_time',
                            //'created_by',
                            //'update_by',
                              [
                  
                  'format' => 'raw',
                  'value' => function ($model) {
                    $buttons = '';
                    
                    $buttons .= '<a href='.BASE_URL.'product/update?it_easy_product_id='.$model->it_easy_product_id.' ?><button style= "color: #fff;background-color: #1e91cf;border-color: #1978ab;margin-left: 30px;" type="button" class="btn btn-info btnw btn-sm"><i class="typcn typcn-pencil"></i></button></a>';
         

             
                     $buttons .= '<a style= "margin: 3px 5px;display: inline-block;border-radius: 6px;" class="md-trigger btn btn-info btnw btn-sm" data-toggle="tooltip" title="Add Unit Material" href="'.BASE_URL.'product/unitmaterial?it_easy_product_id='.$model->it_easy_product_id.'"  target="_blank">Add Material</a><br>';

                      return $buttons;
                 
                    },

          
                ], 

                                ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>
