<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\ItEasyProductCategory;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use kartik\datetime\DateTimePicker;
use backend\models\ItEasyProduct;
use kartik\datecontrol\Module;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyTax;
use backend\models\ItEasyProductMaterial;
use backend\models\ItEasyProductUnitMaterial;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyProduct $model */
/** @var yii\widgets\ActiveForm $form */
$this->title = 'Update Product';
$this->params['breadcrumbs'][] = ['label' => 'It Easy Products', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->it_easy_product_id, 'url' => ['view', 'it_easy_product_id' => $model->it_easy_product_id]];
$this->params['breadcrumbs'][] = 'Update';
?>

<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }

    .pricesection{
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2); /* this adds the "card" effect */
  padding: 16px;
  background-color: #cecaca;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>product"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->
    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
           
   

     <div class="card">
     <div class="main-content-label mg-b-5">  
     <div class="card-body">Product Variation</div>
     </div> 
     <div class="pricesection">
     <div id="variationHtml">
        <?php
     $count = count($model2);
     $match = $count - 1;
     $remove = $count;
     // echo "<pre>";print_r($remove);die;
     foreach ($model2 as $key => $value) {

        // echo "<pre>";print_r($value);die;
     ?>
     <div class="row remove<?= $key ?>"> 
        <div class="col-md-12">
     <?= $form->field($value, '['.$key.']it_easy_variation_id')->dropDownList(
        ArrayHelper::map(ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_variation_name'),[
                 'prompt' => 'Please Select'])->label('Variation Name') ?>

       <!--  <input type="hidden" name="ItEasyProductVariation[<?= $key ?>][it_easy_id]" value='<?= $value['it_easy_id']; ?>'> -->
        </div>
      
                            <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="main-content-label mg-b-5">
                                        Add Material
                                    </div>
                                    <p class="mg-b-20">It is Very Easy to add material in Build Product.</p>
                                    
                                    <?php 
                                     $unit_data = ItEasyProductUnitMaterial::findAll(['it_easy_product_id' => $value['it_easy_product_id'],'it_easy_variation_id'=>$value['it_easy_variation_id']]);
                                     $count = count($unit_data);
                                     $match = $count - 1;
                                     $remove = $count;
                                     // echo "<pre>";print_r($count);die;
                                     if(!empty($unit_data)){ ?>
                                        <div id="materialHtml_<?= $value['it_easy_variation_id'] ?>">
                                        <?php 
                                     foreach ($unit_data as $key1 => $value1) { ?>
                                    
                                        <div id="removeunique<?= $key1; ?>_<?= $key; ?>">
                                      <div class="row row-xs">
                                          <div class="col-sm-4">
                                              <div class="form-group">
            <?= $form->field($value1, '['.$value["it_easy_variation_id"].']['.$key1.']it_easy_material_id')->dropDownList(
        ArrayHelper::map(ItEasyProductMaterial::find()->select(['it_easy_id', 'it_easy_material_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(), 'it_easy_id', 'it_easy_material_name'),['prompt' => 'Select Material','class'=>'form-control'])->label('Material Name') ?>
                                              </div>
                                          </div>
              <div class="col-sm-4">
                  <div class="form-group">
                      <?= $form->field($value1, '['.$value["it_easy_variation_id"].']['.$key1.']it_easy_quantity')->textInput(['maxlength' => true])->label('Add Quantity') ?>
                  </div>
              </div>
          <div class="col-sm-2">
              <div class="form-group">
                  <?= $form->field($value1, '['.$value["it_easy_variation_id"].']['.$key1.']it_easy_weight_type')->dropDownList(['' => 'Select', 'kilogram' => 'Kilogram', 'liter' => 'Liter', 'quantity-in-number' => 'Quantity In Number'])->label('Weight Type'); ?>
              </div>
          </div>
          <?php if($match == $key1): ?>
          <div class="col-sm-1">
              <div class="form-group">
                  <div style="margin-top: 28px;">
                      <a href="javascript:void(0);" class="hide<?= $key1; ?>_<?= $value['it_easy_variation_id'] ?>" onclick="addMoreUnitMaterial(<?= $key1; ?>,<?= $value['it_easy_variation_id'] ?>);" style="font-size:90%" class="label label-primary">
                          <li class="icons-list-item"><i class="fa fa-plus-circle"></i></li>
                      </a>
                  </div>
              </div>
          </div>
      <?php endif; ?>

          <?php
    $i = 0;
     if($i++ < $key1): ?>
            <div class="col-sm-1">
            <div class="form-group">
                <div style="margin-top: 4px;">
                    <a href="javascript:void(0);" style="padding-left:10px;" title="Delete" onclick="removeUnitMaterialDivUpdate(<?= $key1; ?>,<?= $key; ?>);"><li class="icons-list-item"><i class="fa fa-times-circle"></i></li></a>
                </div>

            </div>
        </div>
    <?php endif; ?>
                                      </div>
                                  </div>
                                  
                                  <?php }  ?>

                                  </div>
                              <?php }else{ ?>

                                     <div id="materialHtml_<?= $value['it_easy_variation_id'] ?>">
                                      <div class="row row-xs">
                                          <div class="col-sm-4">
                                              <div class="form-group">
            <?= $form->field($unit_model, '['.$value["it_easy_variation_id"].'][0]it_easy_material_id')->dropDownList(
        ArrayHelper::map(ItEasyProductMaterial::find()->select(['it_easy_id', 'it_easy_material_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(), 'it_easy_id', 'it_easy_material_name'),['prompt' => 'Select Material'])->label('Material Name') ?>
                                              </div>
                                          </div>
              <div class="col-sm-4">
                  <div class="form-group">
                      <?= $form->field($unit_model, '['.$value["it_easy_variation_id"].'][0]it_easy_quantity')->textInput(['maxlength' => true])->label('Add Quantity') ?>
                  </div>
              </div>
          <div class="col-sm-2">
              <div class="form-group">
                  <?= $form->field($unit_model, '['.$value["it_easy_variation_id"].'][0]it_easy_weight_type')->dropDownList(['' => 'Select', 'kilogram' => 'Kilogram', 'liter' => 'Liter', 'quantity-in-number' => 'Quantity In Number'])->label('Weight Quantity'); ?>
              </div>
          </div>
          <div class="col-sm-2">
              <div class="form-group">
                  <div style="margin-top: 28px;">
                      <a href="javascript:void(0);" class="hide0_<?= $value['it_easy_variation_id'] ?>" onclick="addMoreUnitMaterial(0,<?= $value['it_easy_variation_id'] ?>);" style="font-size:90%" class="label label-primary">
                          <li class="icons-list-item"><i class="fa fa-plus-circle"></i></li>
                      </a>
                  </div>
              </div>
          </div>
                                      </div>

                                  </div>

                            <?php  }  ?>
                                  
                                  
                                </div>
                            </div>
                        </div>
    </div>
<?php } ?>
    </div>
    </div>
    </div>

    <div class="row">
      <div class="col-md-1">
        <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
        </div>
        <div class="col-md-1">
 
    <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger','onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
        </div>

    </div>
         </div>
        </div>
          <?php ActiveForm::end(); ?>

    </div>
    
  