<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\ItEasyProductCategory;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use kartik\datetime\DateTimePicker;
use backend\models\ItEasyProduct;
use kartik\datecontrol\Module;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyTax;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyProduct $model */
/** @var yii\widgets\ActiveForm $form */
$this->title = 'Update Product';
$this->params['breadcrumbs'][] = ['label' => 'It Easy Products', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->it_easy_product_id, 'url' => ['view', 'it_easy_product_id' => $model->it_easy_product_id]];
$this->params['breadcrumbs'][] = 'Update';
?>

<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }

    .pricesection{
        box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2); /* this adds the "card" effect */
  padding: 16px;
  background-color: #cecaca;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>product"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->
    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        <?= Html::encode($this->title) ?>
                    </div>
            <p class="mg-b-20">Please create Product according to you !!</p>
        <div class="pd-30 pd-sm-40 bg-gray-200">
            <div class="row row-xs">
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_name')->textInput(['maxlength' => true]) ?>
        </div>
         <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_sku')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
         <?= $form->field($model, 'it_easy_product_hsn')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_status')->dropDownList([''=>'Select','In-Active' => 'Inactive', 'Active' => 'Active']); ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_category_id')->dropDownList(
        ArrayHelper::map(ItEasyProductCategory::find()->select(['it_easy_id', 'it_easy_category_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_category_name'),[
                 'prompt' => 'Please Select'])->label('Product Category') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_brand_id')->textInput() ?>
        </div>
      
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_type')->dropDownList([''=>'Select','powder' => 'Powder', 'liquide' => 'Liquide', 'capsule' => 'Capsule','other' => 'Other']); ?>
        </div>
      

        <div class="col-md-3">                   
    <?= $form->field($model, 'it_easy_product_image')->FileInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-3">
            <?php if (!empty($model->it_easy_product_image)){ ?>
                <img src="<?= Yii::$app->request->baseUrl .'/'.'products/' . $model->it_easy_product_image ?>" style="height:60px; width:70px;" >
                <a href="<?= yii\helpers\Url::to(['product/delete-image', 'it_easy_product_id' => $model->it_easy_product_id,'image'=>$model->it_easy_product_image]) ?>" onClick="return confirm('Are you sure You want to delete?');" name="delete">Delete</a>  
            <?php }else{ ?>
                <img src="<?= Yii::$app->request->baseUrl .'/'.'uploads/' .'dummy.jpg' ?>" style="height:60px; width:70px;" >
            <?php } ?>    
        </div>
    <div class="col-md-3">
    <?= $form->field($model, 'it_easy_product_stock_id')->dropDownList([''=>'Select','out-of-stock' => 'Out of Stock', 'in-stock' => 'In stock']); ?>
        </div>

        <div class="col-md-3">
          <label>Check product feature status</label>  
    <?= $form->field($model, 'it_easy_product_feature_status')->checkbox(['checked' => $model->it_easy_product_feature_status > 0,  'value' => true])->label(false) ?>
        </div>

        <div class="col-md-12" style="margin-bottom: 20px;">
        <label class="control-label" for="iteasyproduct-it_easy_product_description">Product Description</label>
    <?= froala\froalaeditor\FroalaEditorWidget::widget([
    'model' => $model,
    'attribute' => 'it_easy_product_description',
    'options' => [
        // html attributes
        'id'=>'content',
        'label' =>'Product Description',
    ],
    'clientOptions' => [
        'height'     => 200,
        'toolbarInline' => false,
        'theme' => 'royal', //optional: dark, red, gray, royal
        'language' => 'en_us' // optional: ar, bs, cs, da, de, en_ca, en_gb, en_us ...
        
    ]
    ]);?>
        </div>

        <div class="card">
         <div class="main-content-label mg-b-5">  
        <div class="card-body">Product Price & Quanity</div>
        </div> 
        <div class="pricesection">
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_tax')->dropDownList(
        ArrayHelper::map(ItEasyTax::find()->select(['it_easy_tax_percentage', 'it_easy_tax_name'])->where(['it_easy_tax_status' => 'Active'])->asArray()->all(),'it_easy_tax_percentage','it_easy_tax_name'),[
                 'prompt' => 'Please Select'])->label('Product Tax') ?>
        </div>
          <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_included_exclude_tax')->dropDownList([''=>'Select','include' => 'include', 'exclude' => 'exclude']); ?>
        </div>
        
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_price')->textInput(['maxlength' => true])->label('Sale Price') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_mrp')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_tax_price')->textInput() ?>
        </div>
         <div class="col-md-4">
    <?= $form->field($model, 'it_easy_price_without_tax')->textInput() ?>
        </div>
        <div class="col-md-3">
    <?= $form->field($model, 'it_easy_product_one_bottle_quantity')->textInput()->label('All Variation Weight') ?>
        </div>
        <div class="col-md-3">
    <?= $form->field($model, 'it_easy_weight_type')->dropDownList([''=>'Select','kilogram' => 'Kilogram', 'gram' => 'Gram', 'milligram' => 'Milligram', 'liter' => 'Liter', 'mililiter' => 'Mili liter','quantity-in-number'=> 'Quantity in Number']); ?>
        </div>
        <div class="col-md-3">
    <?= $form->field($model, 'it_easy_stock_alert')->dropDownList(['0'=>'No','1' => 'Yes']); ?>
        </div>
        <div class="col-md-3">
    <?= $form->field($model, 'it_easy_stock_alert_number')->textInput([ 'type' => 'number']) ?>
        </div>
        </div>
        </div>

           <div class="card">
         <div class="main-content-label mg-b-5">  
        <div class="card-body">Product Discount</div>
        </div> 
        <div class="pricesection">
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_discount')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
    <?php echo '<label>Discount Start Date</label>'; ?>
        <?= DateTimePicker::widget([
    'name' => 'ItEasyProduct[it_easy_discount_start_date]', 
        'value' => "$model->it_easy_discount_start_date",
    'pluginOptions' => [
        'format' => 'yyyy-mm-dd H:i:s',
        'todayHighlight' => true
            ]
        ]);

        ?>
        </div>
        <div class="col-md-4">
    <?php echo '<label>Discount End Date</label>'; ?>
        <?= DateTimePicker::widget([
    'name' => 'ItEasyProduct[it_easy_discount_end_date]', 
        'value' => "$model->it_easy_discount_end_date",
    'pluginOptions' => [
        'format' => 'yyyy-mm-dd H:i:s',
        'todayHighlight' => true
            ]
        ]);

        ?>
        </div>
       </div>
   </div>
         <div class="card">
         <div class="main-content-label mg-b-5">  
        <div class="card-body">Product Image Dimension</div>
        </div> 
        <div class="pricesection">    
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_width')->textInput(['maxlength' => true])->label('Product Width in CM') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_height')->textInput(['maxlength' => true])->label('Product Height in CM') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_length')->textInput(['maxlength' => true])->label('Product Length in CM') ?>
        </div>
    </div>
    </div>

     <div class="card">
     <div class="main-content-label mg-b-5">  
     <div class="card-body">Product Variation</div>
     </div> 
     <div class="pricesection">
     <div id="variationHtml">
        <?php
     $count = count($model2);
     $match = $count - 1;
     $remove = $count;
     // echo "<pre>";print_r($remove);die;
     foreach ($model2 as $key => $value) {
     ?>
     <div class="row remove<?= $key ?>"> 
        <div class="col-md-3">
     <?= $form->field($value, '['.$key.']it_easy_variation_id')->dropDownList(
        ArrayHelper::map(ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_variation_name'),[
                 'prompt' => 'Please Select'])->label('Variation Name') ?>

        <input type="hidden" name="ItEasyProductVariation[<?= $key ?>][it_easy_id]" value='<?= $value['it_easy_id']; ?>'>
        </div>
      
        <div class="col-md-1">
    <?= $form->field($value, '['.$key.']it_easy_varation_price')->textInput()->label('Sale Price') ?>
        </div>
        <div class="col-md-1">
    <?= $form->field($value, '['.$key.']it_easy_varation_mrp')->textInput(['maxlength' => true])->label('VarientMRP') ?>
        </div>
        
        <div class="col-md-1">
    <?= $form->field($value, '['.$key.']it_easy_product_weight')->textInput(['maxlength' => true])->label('WeightGram') ?>
        </div>
        <div class="col-md-2">
    <?= $form->field($value, '['.$key.']shopify_product_id')->textInput(['maxlength' => true])->label('Shopify Product ID') ?>
        </div>
        <div class="col-md-2">
    <?= $form->field($value, '['.$key.']shopify_veriant_id')->textInput(['maxlength' => true])->label('Shopify Variant ID') ?>
        </div>
      
             <?php if($match == $key): ?>
        <div class="col-sm-1">
            <div class="form-group">
                <div style="margin-top: 28px;">
                    <a href="javascript:void(0);" class="hide<?= $key; ?>"  onclick="addMoreVariation(<?= $key ?>);"  style="font-size:90%" class="label label-primary"><li class="icons-list-item"><i class="fa fa-plus-circle"></i></li></a>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php
    $i = 0;
     if($i++ < $key): ?>
            <div class="col-sm-1">
            <div class="form-group">
                <div style="margin-top: 4px;">
                    <a href="javascript:void(0);" style="padding-left:10px;" title="Delete" onclick="removeUpdateDivVariation('<?= $key; ?>');"><li class="icons-list-item"><i class="fa fa-times-circle"></i></li></a>
                </div>

            </div>
        </div>
    <?php endif; ?>
    </div>
<?php } ?>
    </div>
    </div>
    </div>

    <div class="row">
      <div class="col-md-1">
        <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
        </div>
        <div class="col-md-1">
 
    <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger','onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
        </div>

    </div>
         </div>
        </div>
    </div>
    </div>
    </div>

    </div>
    <?php ActiveForm::end(); ?>

</div>