<?php

use backend\models\ItEasyRaiseRequest;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use backend\models\ItEasyOrder;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyRaiseRequestSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Raise Requests';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

        </div>
    </div>


    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
             <?php if(Yii::$app->user->identity->it_easy_dept_id != '8' && Yii::$app->user->identity->it_easy_dept_id != '1'){ ?>   
             <br>
             <br>   
            <div class="row row-sm">
              <div class="col-md-12">
                <div class="col-xl-8 col-md-8">
                  <?php $form = ActiveForm::begin(); ?>
                    <div class="col-md-12">
                      <?= $form->field($model2, 'it_easy_raise_comment')->textArea(['rows' => 9, 'placeholder' => 'Enter Your Request here'])->label(false); ?>
                    </div>
                    <div class="col-md-12">
                      <?= Html::submitButton('SUMBIT', ['class' => 'btn btn-secondary btn-block']) ?>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>
                <div class="col-xl-4 col-md-4">
                  <div class="card text-center" style="background-color: #ecf0fa !important; ">
                      <div class="card-body " style="border: 2px solid #3E3E6E;border-radius: 11px;padding: 45px 0px;width: 100%;">
                        <div class="feature widget-2 text-center mt-0 mb-3">
                          <i class="fa fa-clipboard" style="font-size: 100px; color: #3E3E6E;"></i>
                        </div>
                        <h6 class="mb-1 text-muted" style=" color: #3E3E6E !important;font-size: 20px; font-weight: 900;">Check Request Log</h6>
                      </div>
                    </div>
                </div>

            </div>
            </div>
              <br>
              <br>

          <?php } ?>


                <?php // echo $this->render('_search', ['model' => $searchModel]); 
                ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                           
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                [
                                    'label' => 'UserName',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_user_id',

                                    'value' => function ($model) {
                                        $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_user_id, '0');
                                        return $get_agent_tl_name;
                                    }
                                ],
                                [
                                    'label' => 'Raise-Request',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_raise_comment',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_raise_comment;
                                    }
                                ],

                                [
                                    'label' => 'Solve-Comment',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_solve_comment',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_solve_comment;
                                    }
                                ],

                                [
                                    'label' => 'Status',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_status',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_status;
                                    }
                                ],

                                [
                                    'label' => 'Satisfied-Status',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_satisfied',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        if($model->it_easy_satisfied == '0'){
                                            return "Pending";
                                        }
                                        else{
                                            return "Solved";
                                        }
                                    }
                                ],

                                [
                                    'label' => 'Created',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_created_time',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_created_time;
                                    }
                                ],

                                [
                                    'label' => 'Updated',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_updated_time',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_updated_time;
                                    }
                                ],



                               
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyRaiseRequest $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>




</div>
</div>

</div>
</div>
</div>
</div>