<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;

use yii\grid\GridView;
use yii\widgets\ActiveForm;


/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Agent Sales Growth Analysis';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .bg-gray-200 {
        border-radius: 8px;
    }

    .font-weight-bold {
        color: #2cac81;
        font-size: 22px;
        margin-top: 13px;
        margin-bottom: 15px;
        font-weight: bolder;
        font-family: cursive;
    }

    .mb-1 {
        font-weight: 700;
        font-size: 12px;
        margin-top: 15px;
    }

    .card-order-total {
        border-radius: 0px !important;
        border: none !important;
    }

    textarea {
        border-radius: 10px !important;
        background-color: #ffffff !important;
        border: 2px solid #fdfdfd !important;
    }
</style>
<!-- container -->
<div class="container-fluid">



    <div class="row row-sm">
        <div class="col-md-12">
            <div class="breadcrumb-header justify-content-between">
                <div class="my-auto">
                    <div class="d-flex">
                        <h4 class="content-title mb-0 my-auto">Raise Request</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="col-xl-8 col-md-8">
                <?php $form = ActiveForm::begin(); ?>
                <div class="col-md-12">
                    <?= $form->field($model2, 'it_easy_raise_comment')->textArea(['rows' => 9, 'placeholder' => 'Enter Your Request here'])->label(false); ?>
                </div>
                <div class="col-md-12">
                    <?= Html::submitButton('SUMBIT', ['class' => 'btn btn-secondary btn-block']) ?>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
            <div class="col-xl-4 col-md-4">
                <div class="card text-center" style="background-color: #ecf0fa !important; ">
                    <div class="card-body " style="border: 2px solid #3E3E6E;border-radius: 11px;padding: 45px 0px;width: 80%;">
                        <div class="feature widget-2 text-center mt-0 mb-3">
                            <i class="fa fa-clipboard" style="font-size: 100px; color: #3E3E6E;"></i>
                        </div>
                        <h6 class="mb-1 text-muted" style=" color: #3E3E6E !important;font-size: 20px; font-weight: 900;">Check Request Log</h6>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <br>
    <br>


    <div class="row row-sm">
        <div class="col-md-12">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive border-top userlist-table">
                            <br>
                            <br>
                            <?= GridView::widget([
                                'dataProvider' => $dataProvider2,
                                // 'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],
                                   
                          
                                  

                                    [
                                        'label' => 'UserName',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_user_id',

                                        'value' => function ($model) {
                                            $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_user_id, '0');
                                            return $get_agent_tl_name;
                                        }
                                    ],
                                    [
                                        'label' => 'Raise-Request',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_raise_comment',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_raise_comment;
                                        }
                                    ],

                                    [
                                        'label' => 'Solve-Comment',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_solve_comment',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_solve_comment;
                                        }
                                    ],

                                    [
                                        'label' => 'Solve-Comment',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_status',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_status;
                                        }
                                    ],

                                    [
                                        'label' => 'Satisfied-Status',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_satisfied',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_satisfied;
                                        }
                                    ],

                                    [
                                        'label' => 'Created',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_created_time',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_created_time;
                                        }
                                    ],

                                    [
                                        'label' => 'Updated',
                                        'format' => 'raw',
                                        'attribute' => 'it_easy_updated_time',
                                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                        'value' => function ($model) {

                                            return $model->it_easy_updated_time;
                                        }
                                    ],



                                    [
                                        'class' => 'yii\grid\ActionColumn',
                                        'template' => '{update}',
                                        'buttonOptions' => [
                                            'target' => "_blank"
                                        ],
                                    ],
                                ],
                            ]); ?>
                        </div>
                    </div>
                </div>
            </div>
            <!--/div-->
        </div>
    </div>

</div>