<?php

use backend\models\ItEasyShadowfaxPincodes;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
/** @var yii\web\View $this */
/** @var backend\models\ItEasySmartrPincodesSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Shadowfax Pincodes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Upload Zone Pincode', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_pincode')->textInput(['maxlength' => true, 'placeholder' => 'Search Pincode....'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_city')->textInput(['maxlength' => true, 'placeholder' => 'Search City....'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_state')->textInput(['placeholder' => 'Search State....'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_cod')->textInput(['placeholder' => 'Search COD....'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_prepaid')->textInput(['placeholder' => 'Search Prepaid....'])->label(false) ?>
                            </div>
                            
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>

                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                'it_easy_pincode',
                                'it_easy_city',
                                'it_easy_state',
                                'it_easy_cod',
                                'it_easy_prepaid',
                                // 'it_easy_metro_city',
                                // 'it_easy_delivery_estimate',
                                //'created_by',
                                //'updated_by',
                                //'updated_time',
                                // 'it_easy_date_added',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update} {delete}',
                                    'urlCreator' => function ($action, ItEasyShadowfaxPincodes $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>
