<?php

use backend\models\ItEasyShippingApi;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyShippingApiSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Shipping Apis';
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Shipping API', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_name')->textInput(['maxlength' => true, 'placeholder' => 'Search Shipping Name'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive'],['prompt' => 'Search by Status'])->label(false); ?>
                            </div>
                          
                          
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>

                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_ship_id',
                                'it_easy_name',
                                'it_easy_userName',
                                
                                'it_easy_auth_key',
                                'it_easy_zone_a',
                                //'it_easy_zone_b',
                                //'it_easy_zone_c',
                                //'it_easy_zone_d',
                                //'it_easy_zone_e',
                                'it_easy_fixed_cod_charges',
                               
                                'status',
                                //'created_by',
                                //'updated_by',
                                //'created_time',
                                //'updated_time',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyShippingApi $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_ship_id' => $model->it_easy_ship_id]);
                                    }
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>
