 <?php
use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;


if(!empty($month_report_ticket['confirm_count'])){
    $conversion_percentaget =    ROUND($month_report_ticket['confirm_count'] / $month_report_ticket['total_leads'] * 100);
}else{
    $conversion_percentaget = '0';
}

if(!empty($month_report_ticket['delivered_order_count'])){
    $delivered_percentaget =    ROUND($month_report_ticket['delivered_order_count'] / $month_report_ticket['dispatched_order_count'] * 100);
}else{
    $delivered_percentaget = '0';
}

if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}

 ?>

 <!-- main-content -->
           

            

                <!-- container -->
                <div class="container-fluid">

                    <!-- breadcrumb -->
                    <div class="breadcrumb-header justify-content-between">
                        <div class="left-content">
                            <div>
                              <h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1">Hi, welcome back!</h2>
                              <p class="mg-b-0">Sales monitoring dashboard template.</p>
                            </div>
                        </div>
                        <div class="main-dashboard-header-right">
                            <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                    
                     <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_department_id')->dropDownlist(['4' => 'Sale', '9' => 'Retention'], ['prompt' => 'Search by Department'])->label(false); ?>
                    </div>
                    <div class="col-md-2">
                       
                        <?= $formsearch->field($searchModel, 'it_easy_platform')->dropDownlist($search_array, ['prompt' => 'Search by Platform Type'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Confirmation Date', 'Order Place via Agent' => 'Order Place via Agent', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m-d') : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              
            </div>
                        </div>
                    </div>
                    <!-- /breadcrumb -->

                    <!-- row -->
                    <div class="row row-sm">
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-primary-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today TOTAL ORDERS</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['total_leads']) ? $today_report['total_leads'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7"><?= !empty($today_report['sum_total_leads']) ? $today_report['sum_total_leads'] : '0'; ?></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-up text-white"></i>
                                                <span class="text-white op-7"> </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline" class="pt-1"></span>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-warning-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today Assign Orders</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['assign_leads']) ? $today_report['assign_leads'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7"><?= !empty($today_report['assign_leads_amount']) ? $today_report['assign_leads_amount'] : '0'; ?></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-down text-white"></i>
                                                <span class="text-white op-7"> </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline2" class="pt-1"></span>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-success-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today TOTAL CONFIRM</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['confirm_count']) ? $today_report['confirm_count'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7">Shopify- <?= !empty($today_report['shopify_confirm_sum']) ? $today_report['shopify_confirm_sum'] : '0'; ?>  OWN - <?= !empty($today_report['confirm_sum']) ? $today_report['confirm_sum'] : '0'; ?></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-up text-white"></i>
                                                <span class="text-white op-7"></span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline3" class="pt-1"></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-success-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today  Upsell/Retension Amount</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= $today_report['confirm_sum'] - $today_report['shopify_confirm_sum'].'.00'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7"></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-up text-white"></i>
                                                <span class="text-white op-7"></span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline3" class="pt-1"></span>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-primary-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today TOTAL DISPATCH</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['dispatched_order_count']) ? $today_report['dispatched_order_count'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7"><?= !empty($today_report['dispatched_order_sum']) ? $today_report['dispatched_order_sum'] : '0'; ?></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-down text-white"></i>
                                                <span class="text-white op-7"> </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline4" class="pt-1"></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-warning-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today Ticket Size</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['average_ticket']) ? $today_report['average_ticket'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7">-</p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-down text-white"></i>
                                                <span class="text-white op-7"> </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline4" class="pt-1"></span>
                            </div>
                        </div>
                        
                        <div class="col-xl-4 col-lg-4 col-md-4 col-xm-12">
                            <div class="card overflow-hidden sales-card bg-success-gradient">
                                <div class="pl-3 pt-3 pr-3 pb-2 pt-0">
                                    <div class="">
                                        <h6 class="mb-3 tx-12 text-white">Today Prepaid Order</h6>
                                    </div>
                                    <div class="pb-0 mt-0">
                                        <div class="d-flex">
                                            <div class="">
                                                <h4 class="tx-20 font-weight-bold mb-1 text-white"><?= !empty($today_report['prepaid_order']) ? $today_report['prepaid_order'] : '0'; ?></h4>
                                                <p class="mb-0 tx-12 text-white op-7"><?= !empty($today_report['prepaid_order_amount']) ? $today_report['prepaid_order_amount'] : '0'; ?></p>
                                            </div>
                                            <span class="float-right my-auto ml-auto">
                                                <i class="fas fa-arrow-circle-down text-white"></i>
                                                <span class="text-white op-7"> </span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <span id="compositeline4" class="pt-1"></span>
                            </div>
                        </div>
                    </div>
                    <!-- row closed -->
                    
                    
                    <div class="row row-sm">
                        
                        
                        <div class="col-sm-12 col-lg-4 col-xl-4 col-md-4">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">Total Order</p>
											<h3><?= !empty($month_report_ticket['total_leads']) ? $month_report_ticket['total_leads'] : '0'; ?></h3>
											<p><?= !empty($month_report_ticket['sum_total_leads']) ? $month_report_ticket['sum_total_leads'] : '0'; ?></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-sm-12 col-lg-4 col-xl-4 col-md-4">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">ASSIGN Order</p>
											<h3><?= !empty($month_report_ticket['assign_leads']) ? $month_report_ticket['assign_leads'] : '0'; ?></h3>
											<p><?= !empty($month_report_ticket['assign_leads_amount']) ? $month_report_ticket['assign_leads_amount'] : '0'; ?></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
                        
                        <div class="col-sm-12 col-lg-4 col-xl-4 col-md-4">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left">
											<p class="card-text text-muted mb-1">Confirm Order</p>
											<h3><?= !empty($month_report_ticket['confirm_count']) ? $month_report_ticket['confirm_count'] : '0'; ?></h3>
											<p>Shopify - <?= !empty($month_report_ticket['shopify_confirm_sum']) ? $month_report_ticket['shopify_confirm_sum'] : '0'; ?>  OWN - <?= !empty($month_report_ticket['confirm_sum']) ? $month_report_ticket['confirm_sum'] : '0'; ?></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-sm-12 col-lg-3 col-xl-3 col-md-3">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">Dispatch Order</p>
											<h3><?= !empty($month_report_ticket['dispatched_order_count']) ? $month_report_ticket['dispatched_order_count'] : '0'; ?></h3>
											<p><?= !empty($month_report_ticket['dispatched_order_sum']) ? $month_report_ticket['dispatched_order_sum'] : '0'; ?></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						<div class="col-sm-12 col-lg-3 col-xl-3 col-md-3">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">Delivered Order</p>
											<h3><?= !empty($month_report_ticket['delivered_order_count']) ? $month_report_ticket['delivered_order_count'] : '0'; ?></h3>
											<p><?= !empty($month_report_ticket['delivered_order_sum']) ? $month_report_ticket['delivered_order_sum'] : '0'; ?></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
                        
                        
                        <div class="col-sm-12 col-lg-3 col-xl-3 col-md-3">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">Order Ticket Size</p>
											<h3><?= !empty($month_report_ticket['average_ticket']) ? $month_report_ticket['average_ticket'] : '0'; ?></h3>
											<p>-</p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
						<div class="col-sm-12 col-lg-3 col-xl-3 col-md-3">
							<div class="card card-img-holder">
								<div class="card-body list-icons">
									<div class="clearfix">
										<div class="float-right  mt-2">
											<span class="text-primary ">
												<i class="si si-basket-loaded tx-30"></i>
											</span>
										</div>
										<div class="float-left text-right">
											<p class="card-text text-muted mb-1">Prepaid Order</p>
											<h3><?= !empty($month_report_ticket['prepaid_order']) ? $month_report_ticket['prepaid_order'] : '0'; ?></h3>
											<p><p><?= !empty($month_report_ticket['prepaid_order_amount']) ? $month_report_ticket['prepaid_order_amount'] : '0'; ?></p></p>
										</div>
									</div>
									<div class="card-footer p-0">
										<p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>This Month</p>
									</div>
								</div>
							</div>
						</div>
						
						
						<div class="col-sm-12 col-lg-6 col-xl-6 col-md-6">
                            <div class="card">
                                <div class="card-header pb-0">
                                    <h3 class="card-title mb-2">Conversion Order Percentage</h3>
                                    <p class="tx-12 mb-0 text-muted">This Month Conversion %</p>
                                </div>
                                <div class="card-body sales-info ot-0 pb-0 pt-0">
                                    <br>
                                    <br>
                                    <div id="chart" class="ht-150" style="margin-bottom: 40px !important;"></div>
                                </div>
                            </div>
                            
                        </div>    
                        <div class="col-sm-12 col-lg-6 col-xl-6 col-md-6">
                            <div class="card">
                                <div class="card-header pb-0">
                                    <h3 class="card-title mb-2">Delivered Order Percentage</h3>
                                    <p class="tx-12 mb-0 text-muted">This Month Delivered %</p>
                                </div>
                                <div class="card-body sales-info ot-0 pb-0 pt-0">
                                    <br>
                                    <br>
                                    <div id="chart2" class="ht-150" style="margin-bottom: 40px !important;"></div>
                                </div>
                            </div>
                        </div>
                        
                        
                    </div>
                    <!-- row closed -->

                    <!-- row opened -->
                

                    <!-- row opened -->
                
                    <!-- row close -->

                    
                </div>
                <!-- /Container -->
            </div>
            <!-- /main-content -->
            
            
<?php
include(dirname(__FILE__) . "/../common/alljs.php");

?>            
          
<script>

/*--- Apex (#chart) ---*/
  var options = {
    chart: {
    height: 205,
    type: 'radialBar',
     offsetX: 0,
          offsetY: 0,
  },
  plotOptions: {
    radialBar: {
    startAngle: -135,
    endAngle: 135,
    size: 120,
    imageWidth: 50,
            imageHeight: 50,
        
     track: { 
     strokeWidth: "80%",  
     background: '#ecf0fa', 
    },
     dropShadow: {
                enabled: false,
                top: 0,
                left: 0,
         bottom: 0,
                blur: 3,
                opacity: 0.5
              },
    dataLabels: {
      name: {
      fontSize: '16px',
      color: undefined,
      offsetY: 30,
      },
      hollow: { 
       size: "60%"  
      },
      value: {
      offsetY: -10,
      fontSize: '22px',
      color: undefined,
      formatter: function (val) {
        return val + "%";
      }
      }
    }
    }
  },
  colors: ['#0db2de'],
  fill: {
    type: "gradient",
    gradient: {
    shade: "dark",
    type: "horizontal",
    shadeIntensity: .5,
    gradientToColors: ['#f07529'],
    inverseColors: !0,
    opacityFrom: 1,
    opacityTo: 1,
    stops: [0, 100]
   }
  },
  stroke: {
    dashArray: 4
  },
   series: [<?= $conversion_percentaget; ?>],  
    labels: [""]
  };

  var chart = new ApexCharts(document.querySelector("#chart"), options);
  chart.render();
  /*--- Apex (#chart)closed ---*/


  /*--- Apex (#chart2) ---*/
  var options2 = {
    chart: {
    height: 205,
    type: 'radialBar',
     offsetX: 0,
          offsetY: 0,
  },
  plotOptions: {
    radialBar: {
    startAngle: -135,
    endAngle: 135,
    size: 120,
    imageWidth: 50,
            imageHeight: 50,
        
     track: { 
     strokeWidth: "80%",  
     background: '#ecf0fa', 
    },
     dropShadow: {
                enabled: false,
                top: 0,
                left: 0,
         bottom: 0,
                blur: 3,
                opacity: 0.5
              },
    dataLabels: {
      name: {
      fontSize: '16px',
      color: undefined,
      offsetY: 30,
      },
      hollow: { 
       size: "60%"  
      },
      value: {
      offsetY: -10,
      fontSize: '22px',
      color: undefined,
      formatter: function (val) {
        return val + "%";
      }
      }
    }
    }
  },
  colors: ['#f07529'],
  fill: {
    type: "gradient",
    gradient: {
    shade: "dark",
    type: "horizontal",
    shadeIntensity: .5,
    gradientToColors: ['#f07529'],
    inverseColors: !0,
    opacityFrom: 1,
    opacityTo: 1,
    stops: [0, 100]
   }
  },
  stroke: {
    dashArray: 4
  },
   series: [<?= $delivered_percentaget; ?>],  
    labels: [""]
  };

  var chart = new ApexCharts(document.querySelector("#chart2"), options2);
  chart.render();
  /*--- Apex (#chart)closed ---*/

</script>    
    
    
</script>
        