<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var \common\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;

$this->title = 'Login';

?>

<?php include(dirname(__FILE__) . "/../common/allcss.php"); ?>


<!-- Page -->
<div class="page">

    <div class="container-fluid">
        <div class="row no-gutter">
            <!-- The image half -->
            <div class="col-md-6 col-lg-6 col-xl-7 d-none d-md-flex bg-primary-transparent">
                <div class="row wd-100p mx-auto text-center">
                    <div class="col-md-12 col-lg-12 col-xl-12 my-auto mx-auto wd-100p">
                        <img src="<?= BASE_URL; ?>img/media/login.png" class="my-auto ht-xl-80p wd-md-100p wd-xl-80p mx-auto" alt="logo">
                    </div>
                </div>
            </div>
            <!-- The content half -->
            <div class="col-md-6 col-lg-6 col-xl-5 bg-white">
                <div class="login d-flex align-items-center py-2">
                    <!-- Demo content-->
                    <div class="container p-0">
                        <div class="row">
                            <div class="col-md-10 col-lg-10 col-xl-9 mx-auto">
                                <div class="card-sigin">
                                    <div class="mb-5 d-flex"> <a href="<?= BASE_URL; ?>"><img src="https://cdn.shopify.com/s/files/1/0651/8430/1301/files/NUTRIHERBS-AI-LOGO_256x_bb870c76-7c3f-4415-b825-d0b81d56f656_256x.webp?v=1668001561" class="sign-favicon ht-40" alt="logo"></a><h1 class="main-logo1 ml-1 mr-0 my-auto tx-28">NUTRI<span>HE</span>RBS</h1></div>
                                    <div class="card-sigin">
                                        <div class="main-signup-header">
                                            <h2>Welcome back!</h2>
                                            <h5 class="font-weight-semibold mb-4">Please sign in to continue.</h5>
                                            <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>    
                                                <div class="form-group">
                                                    <label>Username</label> 
                                                    <?= $form->field($model, 'username')->textInput(['autofocus' => true])->label(false); ?>
                                                </div>
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <?= $form->field($model, 'password')->passwordInput()->label(false); ?>
                                                </div>
                                                <div class="form-group">
                                                <?= $form->field($model, 'rememberMe')->checkbox() ?>
                                                </div>
                                                <?= Html::submitButton('Login', ['class' => 'btn btn-main-primary btn-block', 'name' => 'login-button']) ?>
                                            <?php ActiveForm::end(); ?>
                                            <div class="main-signin-footer mt-5">
                                                <p><a href="">Forgot password?</a></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- End -->
                </div>
            </div><!-- End -->
        </div>
    </div>

</div>
<!-- End Page -->
