<?php

use backend\models\ItEasyState;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\StateSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'States';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>

    <!-- breadcrumb -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,   'it_easy_country_name')->dropDownList([''=>'Select Country Name','India'=>'India'])->label(false); ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_state_name',)->textInput(['maxlength' => true, 'placeholder' => 'Search State Name'])->label(false); ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_state_name2',)->textInput(['maxlength' => true, 'placeholder' => 'Search State Name2'])->label(false); ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_state_name3',)->textInput(['maxlength' => true, 'placeholder' => 'Search State Name2'])->label(false); ?>
                                </div>
                               
                                <div class="col-md-2" style="float: right;">
                                    <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                                </div>
                            </div>





                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                'it_easy_country_name',
                                'it_easy_state_name',
                                'it_easy_state_name2',
                                'it_easy_state_name3',
                                'it_easy_state_name4',
                                //'created_by',
                                //'updated_by',
                                //'created_time',
                                //'updated_time',
                                //'it_easy_status',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyState $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>




