<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyStore $model */
/** @var yii\widgets\ActiveForm $form */
?>
<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>store"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="it-easy-product-brand-form">

        <?php $form = ActiveForm::begin(['options' => ['entype' => 'multipart/form-data']]); ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="main-content-label mg-b-5">
                            <?= Html::encode($this->title) ?>
                        </div>
                        <p class="mg-b-20">Please create store according to you !!</p>
                        <div class="pd-30 pd-sm-40 bg-gray-200">
                            <div class="row row-xs">
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_store_name')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_store_mobile')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_store_email')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_store_url')->textInput(['maxlength' => true]) ?>
                                </div>

                            </div>
                            <div class="row row-xs">
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_address_1')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_address_2')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_city')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_state')->textInput(['maxlength' => true]) ?>
                                </div>

                            </div>
                            <div class="row row-xs">
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_pincode')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_gst_number')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">
                                    <?php if (!empty($model->it_easy_store_logo)) { ?>
                                        <img src="<?= Yii::$app->request->baseUrl . '/' . 'logo/' . $model->it_easy_store_logo ?>" style="height:60px; width:70px;">
                                        <a href="<?= yii\helpers\Url::to(['logo/delete-image', 'it_easy_store_logo' => $model->it_easy_store_logo, 'image' => $model->it_easy_store_logo]) ?>" onClick="return confirm('Are you sure You want to delete?');" name="delete">Delete</a>
                                    <?php } else { ?>
                                        <img src="<?= Yii::$app->request->baseUrl . '/' . 'logo/' . 'dummy.jpg' ?>" style="height:60px; width:70px;">
                                    <?php } ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">
                                    <?= $form->field($model, 'it_easy_store_logo')->FileInput(['maxlength' => true]) ?>
                                </div>


                            </div>

                            <div class="row row-xs">
                            <div class="col-md-3 mg-t-10 mg-md-t-0">

<?= $form->field($model, 'it_easy_registered_name')->textInput(['maxlength' => true]) ?>
</div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_status')->dropDownList(['' => 'Select Status', 'Active' => 'Active', 'Inactive' => 'Inactive']) ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0 pt-5">

                                    <?= $form->field($model, 'is_manufacturer')->checkbox() ?>
                                </div>
                                <div class="col-md-3 mg-t-10 mg-md-t-0 pt-5">

                                    <?= $form->field($model, 'is_buyer_product')->checkbox() ?>
                                </div>

                                <div class="col-md-3 mt-4 mt-xl-0" style="margin-top:30px !important;">
                                    <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>