<?php

use backend\models\ItEasyStore;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyStoreSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Stores';
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">


        </div>
    </div>

    <!-- breadcrumb -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">

                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                'it_easy_store_name',
                                'it_easy_registered_name',
                                [

                                    'attribute' => 'img',

                                    'format' => 'html',

                                    'label' => 'Logo',
                                    'headerOptions' => [
                                        'style' => 'color:white;font-size:14px'
                                    ],

                                    'value' => function ($model) {

                                        return Html::img(
                                            BASE_URL.'/logo/' . $model['it_easy_store_logo'],

                                            ['width' => '60px']
                                        );
                                    },

                                ],

                                'it_easy_store_mobile',
                                [
                                    'label' => 'Is Manufacturer ',
                                    'attribute' => 'is_manufacturer',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        if ($model->is_manufacturer == '1') {
                                            return "<div class='text-center'>
  <button type='button' class= 'btn btn-dark btn-sm'>Yes</button>
</div>";
                                        } else {
                                            return "<div class='text-center'>
  <button type='button' class= 'btn btn-dark btn-sm'>No</button>
</div>";
                                        }
                                    }
                                ],
                                [
                                    'label' => 'Is Buyer Product',
                                    'attribute' => 'is_buyer_product',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        if ($model->is_buyer_product == '1') {
                                            return "<div class='text-center'>
  <button type='button' class= 'btn btn-dark btn-sm'>Yes</button>
</div>";
                                        } else {
                                            return "<div class='text-center'>
  <button type='button' class= 'btn btn-dark btn-sm'>No</button>
</div>";
                                        }
                                    }
                                ],

                                'it_easy_status',
                                // 'it_easy_store_logo',
                                // 'created_time',
                                //'updated_time',
                                //'created_by',
                                //'updated_by',

                                //   

                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyStore $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>




</div>