<?php

use backend\models\ItEasyTax;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyTaxSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Taxes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,   'it_easy_tax_name',)->textInput(['maxlength' => true, 'placeholder' => 'Search Tax Name'])->label(false); ?>
                                </div>
                              
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_tax_type')->dropDownList(['GST'=>'GST'],['prompt' => 'Search by GST Type'])->label(false) ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_tax_status',)->dropDownList([ 'Active' => 'Active', 'Inactive' => 'Inactive'],['prompt' => 'Search by Status'])->label(false); ?>
                                </div>

                            </div>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>



                <?php // echo $this->render('_search', ['model' => $searchModel]); 
                ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_tax_id',
                                'it_easy_tax_name',
                                'it_easy_tax_percentage',
                                'it_easy_tax_type',
                                'it_easy_tax_status',
                                //'created_time',
                                //'updated_time',
                                //'created_by',
                                //'updated_by',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyTax $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_tax_id' => $model->it_easy_tax_id]);
                                    }
                                ],
                            ],
                        ]); ?>


                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
