<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyTax $model */

$this->title = $model->it_easy_tax_id;
$this->params['breadcrumbs'][] = ['label' => 'It Easy Taxes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="it-easy-tax-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'it_easy_tax_id' => $model->it_easy_tax_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'it_easy_tax_id' => $model->it_easy_tax_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'it_easy_tax_id',
            'it_easy_tax_name',
            'it_easy_tax_percentage',
            'it_easy_tax_type',
            'it_easy_tax_status',
            'created_time',
            'updated_time',
            'created_by',
            'updated_by',
        ],
    ]) ?>

</div>
