<?php
use backend\models\ItEasyUser;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyTeam $model */
/** @var yii\widgets\ActiveForm $form */
if(!empty($model->it_easy_child_user)){
    
    $model->it_easy_child_user = explode(",",$model->it_easy_child_user);

}

?>
<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>state"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="it-easy-product-brand-form">

        <?php $form = ActiveForm::begin(); ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="main-content-label mg-b-5">
                            <?= Html::encode($this->title) ?>
                        </div>
                        <p class="mg-b-20">Please create team according to you !!</p>
                        <div class="pd-30 pd-sm-40 bg-gray-200">
                            <div class="row row-xs">
                                <div class="col-md-4 mg-t-10 mg-md-t-0">

                                    <?= $form->field($model, 'it_easy_team_name')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-4 mg-t-10 mg-md-t-0">
        
                                    <?= $form->field($model, 'it_easy_parent_user')->dropDownList(ArrayHelper::map(ItEasyUser::find()->select(['id','it_easy_username'])->where(['status'=>'ACTIVE'])->andWhere(['it_easy_type_id'=>[3]])->asArray()->all(),'id','it_easy_username'),['prompt'=>'Select Parent User']) ?>
                                </div>
                                <div class="col-md-4 mg-t-10 mg-md-t-0">
                                    
                                <?= $form->field($model, 'it_easy_child_user')->widget(Select2::classname(), [
                                    'data' => ArrayHelper::map(ItEasyUser::find()->select(['id','it_easy_username'])->where(['status'=>'ACTIVE'])->andWhere(['it_easy_type_id'=>[4,5]])->asArray()->all(), 'id', 'it_easy_username'),
                                    'language' => 'en',
                                    'options' => ['multiple' => true, 'class' => 'text-start', 'placeholder' => 'Child User'],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label('Child User') ?>
                                </div>
                                <div class="col-md-4 mg-t-10 mg-md-t-0">
                                    <?= $form->field($model, 'status')->dropDownList(['Active' => 'Active', 'Blocked' => 'Blocked'], ['prompt' => '']) ?>
                                </div>

                            </div>


                            <div class="row row-xs">
                                <div class="col-md-12">
                                    <div class="col-md-2 mg-t-10 mg-md-t-0">
                                        <?= Html::submitButton('Save', ['class' => 'btn btn-block btn-dark ']) ?>
                                    </div>
                                    <div class="col-md-2 mg-t-10 mg-md-t-0">

                                        <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger', 'onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>