<?php


use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrder;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Undelivered';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
               

            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>




                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'date_type_filter')->dropDownList(['Date Modified' => 'Date Modified', 'Date Added' => 'Date Added', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group field-iteasyundelivered-date_from_date ">
                                    <?= DatePicker::widget([
                                        'name' => 'ItEasyUndelivered[date_from_date]',
                                        'value' => $searchModel->date_from_date,
                                        'options' => ['placeholder' => 'From date', 'id' => 'iteasyundelivered-date_from_date','autoComplete'=>'off'],
                                        'pluginOptions' => [
                                            'format' => 'yyyy-mm-dd',
                                            'todayHighlight' => true,
                                            'autoclose' => true,
                                            'placeholder' => 'Search by From date'
                                        ]
                                    ]) ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group field-iteasyundelivered-date_to_date">
                                    <?= DatePicker::widget([
                                        'name' => 'ItEasyUndelivered[date_to_date]',
                                        'value' => $searchModel->date_to_date,
                                        'options' => ['placeholder' => 'To date', 'id' => 'iteasyundelivered-date_to_date','autoComplete'=>'off'],
                                        'pluginOptions' => [
                                            'format' => 'yyyy-mm-dd',
                                            'todayHighlight' => true,
                                            'autoclose' => true,
                                        ]
                                    ]) ?>
                                </div>
                            </div>



                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                            </div>

                            <div class="col-md-2" style="float: right;">
                                <?= Html::button('Export', ['class' => 'btn btn-light btn-block', 'id' => 'order_list_export_index_four']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,


                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                [
                                    'label' => 'Order-Number',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_order_number',
                                    'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],
             
                                    'value' => function ($model) {
                                          
                                         $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                                         return '<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name;
                                         
                                    }
                                 ],
                                 [
                                    'label' => 'Customer-Info',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_firstname',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {
                                         
                                         return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email;
                                         
                                    }
                                 ],
             
                                 [
                                    'label' => 'Address',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_city',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {
                                         
                                         return $model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;
                                         
                                    }
                                 ],
             
             
                                 [
                                    'label' => 'NDR TL/Agent',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_assigned_to',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {
                                         $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_ndr_tl, $model->it_easy_ndr_agent);
                                         return $get_agent_tl_name;
                                         
                                    }
                                 ],
                                 [
                                    'label' => 'NDR STATUS/Disposition',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_ndr_disposition_id',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {
                                          if(!empty($model->it_easy_ndr_disposition_id)){
                                             $disposition = ItEasyOrder::GetOrderDispositionNamebystatusId($model->it_easy_ndr_disposition_id);
                                         }else{
                                               $disposition = '';
                                         }
                                         if(!empty($model->it_easy_ndr_status_id)){
                                             $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_ndr_status_id);
                                         }else{
                                               $get_status_name = '';
                                         }
                                         return $get_status_name .'<br><br>'. $disposition;
                                         
                                    }
                                 ],
             
                                 
                                 [
                                     'label' => 'Live-Status',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_order_status',
                                    'value' => function ($model) {
                                         $material_name = ItEasyOrderDispatch::find()->select(['it_easy_id', 'it_easy_order_status'])->where(['it_easy_order_id' => $model->it_easy_order_id ])->asArray()->one(); 
                                          if(!empty($material_name)){
                                             return $material_name['it_easy_order_status'];
                                         }else{
                                               return "";
                                         }
                                    }
                                 ],
                                 [
                                     'label' => 'Created',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_created_time',
                                    'value' => function ($model) {
                                         return date('Y-m-d', strtotime($model->it_easy_created_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_created_time));
                                    }
                                 ],
                                 [
                                     'label' => 'Placed Date',
                                    'format' => 'raw',
                                    'attribute' =>'it_easy_placed_time',
                                    'value' => function ($model) {
                                         if(!empty($model->it_easy_placed_time)){
                                        	return date('Y-m-d', strtotime($model->it_easy_placed_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_placed_time));
                                        }else{
                                          	return '';
                                        }
                                    }
                                 ],
             
             
                                
                        
                             ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>
<?php
$script= <<< JS


    $('#order_list_export_index_four').on('click', function(){
	

	var date_type_filter = $('#iteasyundelivered-date_type_filter').val();
	var date_from_date = $('#iteasyundelivered-date_from_date').val();
	var date_to_date = $('#iteasyundelivered-date_to_date').val();
	var url = '';
	
	
	url += "export4?ItEasyUndelivered[date_type_filter]="+date_type_filter;
	url += "&ItEasyUndelivered[date_from_date]="+date_from_date;
	url += "&ItEasyUndelivered[date_to_date]="+date_to_date;
	url += "&export4=export4";
	
	console.log(url);
	window.open(url, '_blank');
	return false;
});

JS;
$this->registerJs($script);


?>