<?php

use kartik\select2\Select2;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyUserType;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyDepartment;


/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserConnectedStatus $model */
/** @var yii\widgets\ActiveForm $form */

if(!empty($model->it_easy_status_id)){
    
    $model->it_easy_status_id = explode(",",$model->it_easy_status_id);

}

if(!empty($model->it_easy_disposition_id)){
    
    $model->it_easy_disposition_id = explode(",",$model->it_easy_disposition_id);

}


?>

<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">

        <div class="d-flex my-xl-auto right-content">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">


                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">

                    <p class="mg-b-20">Please create user connected status according to you !!</p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row row-xs">

                            <div class="col-md-4">
                                <?= $form->field($model, 'it_easy_department_id')->dropDownList(
                                    ArrayHelper::map(ItEasyDepartment::find()->select(['it_easy_id', 'it_easy_depart_name'])->asArray()->all(), 'it_easy_id', 'it_easy_depart_name'),

                                )->label('select department name') ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'it_easy_user_type_id')->dropDownList(
                                    ArrayHelper::map(ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(), 'it_easy_id', 'it_easy_name'),

                                )->label('user type name') ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'it_easy_status_id')->widget(Select2::classname(), [
                                     'data' => ArrayHelper::map(ItEasyOrderStatus::find()->asArray()->all(), 'it_easy_order_status_id', 'it_easy_order_status_name'),
                                    //  'data' => !empty($model->it_easy_status_id) ? ArrayHelper::map(ItEasyOrderStatus::find()->asArray()->all(), 'it_easy_order_status_id', 'it_easy_order_status_name'):"hello",
                                    'language' => 'en',
                                    'options' => ['multiple' => true, 'placeholder' => 'order status name'],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label('status name') ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'it_easy_disposition_id')->widget(Select2::classname(), [
                                    'data' => ArrayHelper::map(ItEasyOrderDisposition::find()->asArray()->all(), 'it_easy_order_disposition_id', 'it_easy_order_disposition_name'),
                                    'language' => 'en',
                                    'options' => ['multiple' => true, 'class' => 'text-start', 'placeholder' => 'order disposition name'],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label('disposition name') ?>
                            </div>


                            <div class="row">
                                <div class="col-md-2">
                                    <?= Html::submitButton('Save', ['class' => 'btn btn-main-greeenarry']) ?>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <?php ActiveForm::end(); ?>
</div>

