<?php

use backend\models\ItEasyUserConnectedStatus;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyUserType;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;


/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = ' user connected status';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control {
        *background-color:#d3d8fb;
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create User connected status Type', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">

                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                // 'department_name',
                                [
                                    'label' => 'department name',
                                    'attribute' => 'it_easy_department_id',
                                    'value' => function ($model) {
                                        $pagecategory = ItEasyDepartment::find()->select(['it_easy_id', 'it_easy_depart_name'])->where(['it_easy_id' => $model->it_easy_department_id])->asArray()->one();
                                        // echo "<pre>";
                                        // print_r( $pagecategory);die;
                                        return $pagecategory['it_easy_depart_name'];
                                    }
                                ],

 
                                // 'user_name',
                                [
                                    'label' => 'user name',
                                    'attribute' => 'it_easy_user_type_id',
                                    'value' => function ($model) {
                                        $pagecategory = ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_id' => $model->it_easy_user_type_id])->asArray()->one();
                                        // echo "<pre>";
                                        // print_r( $pagecategory);die;
                                      
                                        return $pagecategory['it_easy_name'];
                                    }
                                ],

                                // 'status_name',
                                [
                                    'label' => 'status name',
                                    'attribute' => 'it_easy_status_id',
                                    'format' =>'raw',
                                    'value' => function ($model) {
                                       $explode = explode(',',$model->it_easy_status_id);
                                    //    echo "<pre>";
                                    //    print_r( $explode);
                                    $pagecategory = ItEasyOrderStatus::find()->select(['it_easy_order_status_id', 'it_easy_order_status_name'])->where(['in','it_easy_order_status_id', $explode])->asArray()->all();
                                        //  echo "<pre>";
                                    //    print_r( $pagecategory);
                                        
                                        $array = [];
                                    foreach ($pagecategory as $key => $value) {
                                        
                                         $array[] =  $value['it_easy_order_status_name'];
                                         
                                    }
                                    
                                    return implode(',',$array);

                                    
                                       
                                    }
                                ],

                                [
                                    'label' => 'Disposition Name',
                                    'attribute' => 'it_easy_disposition_id',
                                    'format' =>'raw',
                                    'value' => function ($model) {
                                       $explode = explode(',',$model->it_easy_disposition_id);
                                    //    echo "<pre>";
                                    //    print_r( $explode);
                                    $pagecategory = ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->where(['in','it_easy_order_disposition_id', $explode])->asArray()->all();
                                    //      echo "<pre>";
                                    //    print_r( $pagecategory);die;
                                        
                                        $array = [];
                                    foreach ($pagecategory as $key => $value) {
                                        
                                         $array[] =  $value['it_easy_order_disposition_name'];
                                         
                                    }
                                    
                                    return implode(',',$array);

                                    
                                       
                                    }
                                ],

                                

                                // 'disposition_name',
                                
                                //'created_by',
                                //'updated_by',

                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyUserConnectedStatus $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>