<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyUserType;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2; // or kartik\select2\Select2
use yii\web\JsExpression;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUser $model */
/** @var yii\widgets\ActiveForm $form */

if(!empty($model->it_easy_platform)){
    $model->it_easy_platform = explode(',', $model->it_easy_platform);
}
?>

<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>user"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="it-easy-warehouse-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="main-content-label mg-b-5">
                            <?= Html::encode($this->title) ?>
                        </div>
                        <p class="mg-b-20">Please create tax according to you !!</p>
                        <div class="pd-30 pd-sm-40 bg-gray-200">
                            <div class="row row-xs">
                                
                            <?php if(Yii::$app->user->identity->it_easy_dept_id == '8'){ ?>    
                                
                                
                                <div class="col-md-6 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'it_easy_dept_id')->dropDownList(ArrayHelper::map(ItEasyDepartment::find()->select(['it_easy_id', 'it_easy_depart_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_depart_name' ), ['prompt' => 'Select Department']) ?>
                                </div>
                                <div class="col-md-6 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'it_easy_type_id')->dropDownList(ArrayHelper::map(ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_name' ) ,[ 'prompt' => 'Select User Type']) ?>
                                </div>
                        <?php }else{ ?>
                        
                            <div class="col-md-6 mg-t-10 mg-md-t-0" style="display:none;">
                        <?= $form->field($model, 'it_easy_dept_id')->dropDownList(ArrayHelper::map(ItEasyDepartment::find()->select(['it_easy_id', 'it_easy_depart_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_depart_name' ), ['prompt' => 'Select Department']) ?>
                                </div>
                                <div class="col-md-6 mg-t-10 mg-md-t-0" style="display:none;">
                        <?= $form->field($model, 'it_easy_type_id')->dropDownList(ArrayHelper::map(ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_name' ) ,[ 'prompt' => 'Select User Type']) ?>
                                </div>
                        
                        <?php } ?>
                         <div class="col-md-12 mg-t-10 mg-md-t-0">       
                                
                                <?= 


                $form->field($model, 'it_easy_platform')->widget(Select2::classname(), [
                            'data' => ['Online Website' => 'Online Website', 'CRMLeads' => 'CRMLeads', 'Marketplace' => 'Marketplace'],
                            'options' => [ 'placeholder' => 'Search for a Product ...', 'class' => 'order_variation_change_status','multiple' => true],
                            'pluginOptions' => [
                                'allowClear' => true,
                            ],
                        ])->label('Platform');
                         ?>
                      </div>         
                                
                                <div class="col-md-6 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'it_easy_username')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-6 mg-t-10 mg-md-t-0">
                            <?= $form->field($model, 'it_easy_password_hash')->textInput(['maxlength' => true, 'value' => ''])->label('Password'); ?>
                                </div>
                                <div class="col-md-4 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'it_easy_firstname')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-4 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'it_easy_lastname')->textInput(['maxlength' => true]) ?>
                                </div>

                                <div class="col-md-4 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
                                </div>
                                <div class="col-md-12 mg-t-10 mg-md-t-0">
                        <?= $form->field($model, 'status')->dropDownList(['ACTIVE' => 'ACTIVE', 'IN-ACTIVE' => 'IN-ACTIVE']) ?>
                                </div>

                                <div class="col-md-2">
                                   
                                   <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                                </div>
                                <div class="col-md-2">

                                    <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger', 'onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php ActiveForm::end(); ?>
        </div>
</div>
