<?php

use backend\models\ItEasyUser;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyUserType;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;


/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Users';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="it-easy-product-brand-form">


        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,   'it_easy_dept_id')->dropDownList(ArrayHelper::map(ItEasyDepartment::find()->select(['it_easy_id', 'it_easy_depart_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_depart_name' ),['prompt' => 'Search By Department Name'])->label(false); ?>


                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_type_id',)->dropDownList(ArrayHelper::map(ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_name' ) ,[ 'prompt' => 'Search by User Type'])->label(false); ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'it_easy_username',)->textInput(['maxlength' => true, 'placeholder' => 'Search by Username'])->label(false); ?>
                                </div>
                                <div class="col-md-3">
                                    <?= $form->field($searchModel,  'status',)->dropDownList(['ACTIVE' => 'ACTIVE', 'IN-ACTIVE' => 'IN-ACTIVE'], ['prompt' => 'Search by Status'])->label(false); ?>
                                </div>
                               
                                <div class="col-md-2" style="float: right;">
                                    <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                                </div>
                            </div>





                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                    <div class="card-body">
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        // 'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            
             [
               'label' => 'Department Name',
               'format' => 'raw',
               'attribute' =>'it_easy_dept_id',
               'value' => function ($model) {
                    $Department_name = ItEasyDepartment::find()->where(['it_easy_id' => $model->it_easy_dept_id])->one();
                    return $Department_name->it_easy_depart_name;
                    
               }
            ],

             [
               'label' => 'User Type',
               'format' => 'raw',
               'attribute' =>'it_easy_type_id',
               'value' => function ($model) {
                    $Department_name = ItEasyUserType::find()->where(['it_easy_id' => $model->it_easy_type_id])->one();
                    return $Department_name->it_easy_name;
                    
               }
            ],
            
            'it_easy_username',
            //'it_easy_password_hash',
            //'password_reset_token',
            'email:email',
            //'is_manufacturer',
            //'is_product_buyer',
            'status',
            //'it_easy_permissions:ntext',
            //'last_login_ip',
            //'login_status',
            //'login_browser',
            //'login_device',
            //'created_at',
            //'updated_at',
            'created_time',
            //'updated_time',
            //'verification_token',
            [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, ItEasyUser $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>