<?php


use yii\helpers\Html;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Live Users';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>user"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="it-easy-product-brand-form">


        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="card">
                    <div class="card-body">

                   
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            // 'model' => $model,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                'it_easy_username',
                              

                                [
                                    'attribute' => 'login_status',
                                    'format' => 'raw',
                                    'value' => function () {
                                        return '<div class="dropdown nav-item main-header-notification">
                    <a class="new nav-link" href="#">
                    <span class=" pulse2"></span></a>
                    
                </div>';
                                    },


                                ]

                            ],
                        ]); ?>


                    </div>
                </div>
            </div>
        </div>

    </div>
</div>