<?php

use backend\models\ItEasyVendor;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyVendorSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Vendors';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control{
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none; 
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Vendor', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                            <div class="row">
                                <div class="col-md-12">
                              <div class="col-md-4">
                                 <?= $form->field($searchModel, 'it_easy_vendor_type')->dropDownList([''=>'Search Vendor Type','ingredients' => 'Ingredients', 'bottel' => 'Bottel', 'capsule' => 'Capsule', 'label' => 'Label', 'other' => 'Other'])->label(false); ?>
                            </div>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_vendor_code')->textInput(['maxlength' => true, 'placeholder' => 'Search Code....'])->label(false); ?>
                            </div>
                             <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_vendor_name')->textInput(['maxlength' => true, 'placeholder' => 'Search Name....'])->label(false); ?>
                            </div>
                            </div>
                            </div>
                             <div class="row">
                                <div class="col-md-12">
                              <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_vendor_mobile')->textInput(['maxlength' => true, 'placeholder' => 'Search Mobile....'])->label(false); ?>
                            </div>
                              <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_vendor_email')->textInput(['maxlength' => true, 'placeholder' => 'Search Email....'])->label(false); ?>
                            </div>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_status')->dropDownList([ 'Active' => 'Active', 'Inactive' => 'Inactive'],['prompt' => 'Search by Status'],  ['class'=>'form-control select2-no-search select2-hidden-accessible'])->label('Status')->label(false);; ?>
                            </div>
                        </div>
                         </div>

                            <div class="col-md-2">
                            </div>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                'it_easy_vendor_type',
                                'it_easy_vendor_code',
                                'it_easy_vendor_name',
                                'it_easy_vendor_mobile',
                                'it_easy_vendor_email:email',
                                'it_easy_status',
                        [
                            'class' => ActionColumn::className(),
                            'template' => '{update}',
                            'urlCreator' => function ($action, ItEasyVendor $model, $key, $index, $column) {
                                return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                             }
                        ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>