<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyWarehouse;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariationAttribute;
use common\models\User;
use kartik\date\DatePicker;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyWarehouseHistory $model */
/** @var yii\widgets\ActiveForm $form */
?>

<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>warehouse-history"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
        <div class="main-content-label mg-b-5">
            <?= Html::encode($this->title) ?>
        </div>
            <p class="mg-b-20">Please create Warehouse history according to you !!</p>
        <div class="pd-30 pd-sm-40 bg-gray-200">
            <div class="row row-xs">
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_warehouse_id')->dropDownList(
        ArrayHelper::map(ItEasyWarehouse::find()->select(['it_easy_warehouse_id', 'it_easy_warehouse_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_warehouse_id','it_easy_warehouse_name'),[
                 'prompt' => 'Please Select'])->label('Warehouse Name') ?>
        </div>
           <div class="col-md-4">
     <?= $form->field($model, 'it_easy_received_by')->dropDownList(
        ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->andWhere(['it_easy_dept_id'=>6])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Please Select'])->label('Product Received By') ?>
        </div>
           <div class="col-md-4">
    <?php echo '<label>Produt Received Date</label>'; ?>
        <?= DatePicker::widget([
        'name' => 'ItEasyWarehouseHistory[it_easy_received_date]', 
        'value' => "$model->it_easy_received_date",
        'pluginOptions' => [
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true
            ]
        ]) ?>
        </div>


              <div class="card">
                                <div class="card-body">
                                    <div class="main-content-label mg-b-5">
                                        Add Warehouse History
                                    </div>
                                    <p class="mg-b-20">It is Very Easy to add warehouse history.</p>
                                    
                                    <div id="materialHtml">
                                      <div class="row row-xs">
                                          <div class="col-sm-4">
                                              <div class="form-group">
                                                   <?= $form->field($addwarehouse_history, '[0]it_easy_product_id')->dropDownList(
        ArrayHelper::map(ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_name'])->where(['it_easy_product_status' => 'Active'])->asArray()->all(),'it_easy_product_id','it_easy_product_name'),[
                 'prompt' => 'Please Select','onchange'=>'addProduct(0)','id'=>'iteasywarehousehistory-0-it_easy_product_id'])->label('Product Name') ?>
                                              </div>
                                          </div>
                                          <div class="col-sm-3">
                                              <div class="form-group">
                                                
        <?= $form->field($addwarehouse_history, '[0]it_easy_variation_id')->dropDownList(
        ArrayHelper::map(ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_variation_name'),[
                 'prompt' => 'Please Select','id'=>'iteasywarehousehistory-0-it_easy_variation_id'])->label('Variation Name') ?>
            
                                              </div>
                                          </div>
                                          <div class="col-sm-2">
                                              <div class="form-group">
                                             
    <?= $form->field($addwarehouse_history, '[0]it_easy_product_quantity')->textInput(['maxlength' => true])->label('Product Quantity') ?>
     
                                              </div>
                                          </div>
                                    
                                          <div class="col-sm-2">
                                              <div class="form-group">
                                                  <div style="margin-top: 28px;">
                                                      <a href="javascript:void(0);" class="hide0" onclick="addMoreWarehousehistory(0);" style="font-size:90%" class="label label-primary">
                                                          <li class="icons-list-item"><i class="fa fa-plus-circle"></i></li>
                                                      </a>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>

                                  </div>
                                  
                                  
                                  
                                </div>
                            </div>
    
   
    <div class="row row-xs">
        <div class="col-md-12">
              <div class="col-md-2">
                <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                </div>
                <div class="col-md-1">
         
            <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger','onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                </div>
            </div>
            </div>
                 </div>
                </div>
                </div>
            </div>
        </div>
        
  
    <?php ActiveForm::end(); ?>

</div>
