<?php

use backend\models\ItEasyWarehouseHistory;
use backend\models\ItEasyProductVariationAttribute;
use backend\models\ItEasyWarehouse;
use backend\models\ItEasyProduct;
use backend\models\ItEasyWarehouseProductQuantitySearch;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Warehouse History';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control{
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none; 
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Warehouse History', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_warehouse_id')->dropDownList(ArrayHelper::map(ItEasyWarehouse::find()->select(['it_easy_warehouse_id', 'it_easy_warehouse_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_warehouse_id','it_easy_warehouse_name'), [ 'prompt' => 'Search By Warehouse Name'])->label(false); ?>
                            </div>
                            <div class="col-md-4">
                               <?= $form->field($searchModel, 'it_easy_product_id')->dropDownList(ArrayHelper::map(ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_name'])->where(['it_easy_product_status' => 'Active'])->asArray()->all(),'it_easy_product_id','it_easy_product_name'), [ 'prompt' => 'Search By Product Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                            </div>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                //'it_easy_id',
                                //'it_easy_warehouse_id',
                                'it_easy_warehouse_name',
                                //'it_easy_product_id',
                                'it_easy_product_name',
                              	[
                                   'label' => 'Variation Name',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_variation_id',
                                   'value' => function ($model) {
										$order_product = ItEasyProductVariationAttribute::find()->where(['it_easy_id' => $model->it_easy_variation_id])->one();
                                     
                                        return $order_product->it_easy_variation_name;

                                   }
                                ],
                                'it_easy_product_quantity',
                                'created_time:datetime',
                                //'updated_time:datetime',
                                //'created_by',
                                //'updated_by',
                       [
                            'class' => ActionColumn::className(),
                            'template' => '',
                            'urlCreator' => function ($action, ItEasyWarehouseHistory $model, $key, $index, $column) {
                                return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                             }
                        ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>






