<?php

use backend\models\ItEasyWarehouse;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyWarehouseSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Warehouses';
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-12">
                                <div class="col-md-4">
                                    <?= $form->field($searchModel,   'it_easy_warehouse_name',)->textInput(['maxlength' => true, 'placeholder' => 'Search Warehouse Name'])->label(false); ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $form->field($searchModel,  'it_easy_warehouse_email',)->textInput(['maxlength' => true, 'placeholder' => 'Search Warehouse Email'])->label(false); ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $form->field($searchModel,  'it_easy_warehouse_mobile',)->textInput(['maxlength' => true, 'placeholder' => 'Search Warehouse Mobile'])->label(false); ?>
                                </div>
                            </div>

                            <div class="col-md-12">
                            <div class="col-md-4">
                                    <?= $form->field($searchModel,  'it_easy_warehouse_city',)->textInput(['maxlength' => true, 'placeholder' => 'Search Warehouse City'])->label(false); ?>
                                </div>
                                <div class="col-md-4">
                                    <?= $form->field($searchModel,   'it_easy_warehouse_state',)->textInput(['maxlength' => true, 'placeholder' => 'Search Warehouse State'])->label(false); ?>
                                </div>
                               
                                <div class="col-md-4">
                                    <?= $form->field($searchModel, 'it_easy_warehouse_type')->dropDownList(['FORWARD' => 'FORWARD', 'RTO' => 'RTO'],['prompt' => 'Search by Warehouse Type'])->label(false) ?>
                                </div>

                            </div>


                            <div class="col-md-2"  style="float: right;" >
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_warehouse_id',
                                // 'it_easy_warehouse_code',
                                  'it_easy_warehouse_type',
                                'it_easy_warehouse_name',
                                'it_easy_warehouse_mobile',
                                'it_easy_warehouse_email:email',
                                // 'it_easy_warehouse_address',
                                'it_easy_warehouse_city',
                                'it_easy_warehouse_state',
                                'it_easy_warehouse_pincode',
                              
                                //'it_easy_product_quantity',
                                //'it_easy_status',
                                //'created_time',
                                //'updated_time',
                                //'created_by',
                                //'updated_by',
                                // [
                                //     'class' => ActionColumn::className(),
                                //     'urlCreator' => function ($action, ItEasyWarehouse $model, $key, $index, $column) {
                                //         return Url::toRoute([$action, 'it_easy_warehouse_id' => $model->it_easy_warehouse_id]);
                                //      }
                                // ],
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyWarehouse $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_warehouse_id' => $model->it_easy_warehouse_id]);
                                    }
                                ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>