<?php

use backend\models\ItEasyXpressbeesPincodes;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyXpressbeesPincodesSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Xpressbees Pincodes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

<!-- breadcrumb -->
<div class="breadcrumb-header justify-content-between">
    <div class="my-auto">
        <div class="d-flex">
            <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            
            <br>
                <br>
                <?= Html::a('Export', ['export'], ['class' => 'btn btn-dark btn-block', 'target' => '_blank']) ?>
        </div>
    </div>
    <div class="d-flex my-xl-auto right-content">

        <div class="mb-xl-0">
            <div class="btn-group dropdown">
                <?= Html::a('Upload Zone Pincode', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb -->

<!-- row opened -->
<div class="row row-sm">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-header pb-0">
                <div class="row">
                    <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                        <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_Pincode')->textInput(['maxlength' => true, 'placeholder' => 'Search Pincode....'])->label(false); ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_AreaCode')->textInput(['maxlength' => true, 'placeholder' => 'Search Areacode....'])->label(false); ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_process_code')->textInput(['placeholder' => 'Search Process Code....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_HubZoneName')->textInput(['placeholder' => 'Search HubZoneName....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_HubCity')->textInput(['placeholder' => 'Search Hubcity....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_HubState')->textInput(['placeholder' => 'Search HubState....'])->label(false) ?>
                        </div>
                        <div class="col-md-2" style="float: right;">
                            <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <br>
                    <br>

                    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        // 'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'it_easy_id',
            'it_easy_Pincode',
            'it_easy_AreaCode',
            'it_easy_HubCity',
            'it_easy_HubState',
            'it_easy_COD',
            'it_easy_Prepaid',
            //'it_easy_metro_city',
            //'it_easy_delivery_estimate',
            //'it_easy_HasReversePickUpService',
            //'created_by',
            //'created_time',
            //'updated_by',
            //'updated_time',
            //'it_easy_date_added',
            [
                'class' => ActionColumn::className(),
                'template'=>'{update}{delete}',
                'urlCreator' => function ($action, ItEasyXpressbeesPincodes $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                 }
            ],
        ],
    ]); ?>
                </div>
            </div>
        </div>
    </div>
    <!--/div-->
</div>
</div>
