<?php
use backend\models\ItEasyUser;
use backend\models\ItEasyTeam;
use backend\models\ItEasyUserMenu;
use backend\models\ItEasyUserType;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyTeamSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Teams';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Team', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-12">
                                <div class="col-md-5">
                                    <?= $form->field($searchModel, 'it_easy_team_name')->textInput(['maxlength' => true, 'placeholder' => 'Search By Team Name'])->label(false); ?>
                                </div>
                                <div class="col-md-5">
                                    <?= $form->field($searchModel, 'status')->dropDownList(['Active' => 'Active', 'In-active' => 'In-active'])->label(false) ?>
                                </div>


                            </div>
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>



                <?php // echo $this->render('_search', ['model' => $searchModel]); 
                ?>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?php // echo $this->render('_search', ['model' => $searchModel]); 
                        ?>

                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                'it_easy_team_name',
                               
                                [
                                    'label' => 'Parent name',
                                    'attribute' => 'it_easy_parent_user',
                                    'value' => function ($model) {
                                        $pagecategory = ItEasyUserType::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_id' => $model->it_easy_parent_user])->asArray()->one();
                                        // echo "<pre>";
                                        // print_r( $pagecategory);die;
                                      
                                        return $pagecategory['it_easy_name'];
                                    }
                                ],
                                [
                                    'label' => 'Child User',
                                    'attribute' => 'it_easy_child_user',
                                    'format' =>'raw',
                                    'value' => function ($model) {
                                       $explode = explode(',',$model->it_easy_child_user);
                                    //    echo "<pre>";
                                    //    print_r( $explode);
                                    $pagecategory = ItEasyUser::find()->select(['id', 'it_easy_firstname','it_easy_type_id'])->where(['in','it_easy_type_id', $explode])->asArray()->all();
                                         echo "<pre>";
                                       print_r( $pagecategory);die;
                                        
                                        $array = [];
                                    foreach ($pagecategory as $key => $value) {
                                        
                                         $array[] =  $value['it_easy_username'];
                                         
                                    }
                                    
                                    return implode(',',$array);

                                    
                                       
                                    }
                                ],

                                [
                                    'label' => 'Child User',
                                    'attribute' => 'it_easy_child_user',
                                    'format' =>'raw',
                                    'value' => function ($model) {
                                       return $model->it_easy_child_user;
                                    }
                                ],
                                'status',
                                //'created_by',
                                //'created_time',
                                //'updated_by',
                                //'updated_time',
                                [
                                    'class' => ActionColumn::className(),
                                    'template' => '{update}',
                                    'urlCreator' => function ($action, ItEasyTeam $model, $key, $index, $column) {
                                        return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                    }
                                ],
                            ],
                        ]); ?>


                    </div>
                </div>

            </div>
        </div>
    </div>
</div>