<?php

use backend\models\ItEasyBuildHistory;
use backend\models\ItEasyProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyVendor;
use backend\models\ItEasyProductMaterial;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyProductVariationAttribute;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyBuildHistorySearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

use kartik\daterange\DateRangePicker;

$this->title = 'Build Product History';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Build History', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                           
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_product_id')->dropDownList(ArrayHelper::map(ItEasyProduct::find()->where(['it_easy_product_status'=>'Active'])->all(),'it_easy_product_id','it_easy_product_name'),['prompt'=>'Search By Product ID'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_variation_id')->dropDownList(ArrayHelper::map(ItEasyProductVariationAttribute::find()->where(['it_easy_status'=>'Active'])->asArray()->all(),'it_easy_id','it_easy_variation_name'),['prompt'=>'Search By Variation ID'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_product_quantity')->textInput(['maxlength' => true, 'placeholder' => 'Search By Prodcut Quantity....'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= DateRangePicker::widget([
                                    'model' => $searchModel,
                                    'attribute' => 'created_time',
                                    'options' => ['placeholder' => 'Search By Received date ...', 'class' => 'form-control'],
                                    'convertFormat' => true,
                                    'pluginOptions' => [
                                        'timePicker' => true,
                                        'timePickerIncrement' => 30,
                                        'locale' => [
                                            'format' => 'Y/m/d'
                                        ]
                                    ]
                                ]); ?>
                            </div>

                            <div class="col-md-2" style="float: right; margin-top: 8px;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                
                          
                                // 'it_easy_id',
                               
                                [
                                    'label' => 'Product Name',
                                    'attribute' => 'it_easy_product_id',
                                    'value' => function ($model) {
                                         $variation_name = ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_name'])->where(['it_easy_product_id' => $model->it_easy_product_id ])->asArray()->one(); 
                                         return $variation_name['it_easy_product_name'];
                                            }
                                         ],
                            
                                [
                                    'label' => 'Variation Name',
                                    'attribute' => 'it_easy_id',
                                    'value' => function ($model) {
                                         $variation_name = ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_id' => $model->it_easy_variation_id ])->asArray()->one(); 
                                         return $variation_name['it_easy_variation_name'];
                                            }
                                         ],
                                'it_easy_product_quantity',
                                // 'it_easy_added_by',
                                'it_easy_build_date',
                                //'it_easy_product_batch_id',
                                //'it_easy_unique_start',
                                //'it_easy_unique_end',
                                //'created_by',
                                //'created_time',
                                //'updated_by',
                                //'updated_time',
                                // [
                                //     'class' => ActionColumn::className(),
                                //     'template' => '{update}',
                                //     'urlCreator' => function ($action, ItEasyBuildHistory $model, $key, $index, $column) {
                                //         return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                                //     }
                                // ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>