<?php

use backend\models\ItEasyBuyProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\web\JsExpression;
use backend\models\ItEasyProduct;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyCourierPincode;
use kartik\date\DatePicker;
use backend\models\ItEasyOrder;
use kartik\daterange\DateRangePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Assign AWB & Ready For Dispatch';
$this->params['breadcrumbs'][] = $this->title;
$shipping_data = ArrayHelper::map(ItEasyCourierPincode::find()->select(['it_easy_ship_id', 'it_easy_name'])->where(['status' => 'Active'])->asArray()->all(), 'it_easy_ship_id', 'it_easy_name');

// echo "<pre>"; print_r($shipping_data); die;
?>

<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">


                    <div class="col-md-7">

                        <div class="form-group field-iteasyorder-it_easy_ship_id">

                            <select id="iteasyorder-it_easy_ship_id" class="form-control" name="ItEasyOrder[it_easy_ship_id]">
                                <option value="">Select Courier</option>

                                <?php
                                if (!empty($shipping_data)) {
                                    foreach ($shipping_data as $key => $shipping) {
                                ?>
                                        <option value="<?= $key; ?>"><?= $shipping; ?></option>

                                <?php }
                                } ?>
                            </select>

                            <div class="help-block"></div>
                        </div>


                    </div>

                    <div class="col-md-5" style="float: right;">
                        <button type="submit" onclick="getCourier()" class="btn btn-dark btn-block">Assign</button>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">

                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['assign'],'method' => 'get']); ?>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Order number....'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_mobile_number')->textInput(['maxlength' => true, 'placeholder' => 'Search by Mobile number....'])->label(false); ?>
                            </div>

                            

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'date_type_filter')->dropDownList(['Date Modified' => 'Date Modified', 'Date Converted' => 'Date Converted'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_from_date">
                                <?= DatePicker::widget([
                                'name' => 'ItEasyOrderSearch[date_from_date]', 
                                'value' => $searchModel->date_from_date,
                                'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                                'pluginOptions' => [
                                'format' => 'yyyy-mm-dd',
                                'todayHighlight' => true,
                                'autoclose' => true,
                                'placeholder' => 'Search by From date'
                                    ]
                                ]) ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group field-iteasyordersearch-date_to_date">
                                    <?= DatePicker::widget([
                                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                                    'value' => $searchModel->date_to_date,
                                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                                    'pluginOptions' => [
                                    'format' => 'yyyy-mm-dd',
                                    'todayHighlight' => true,
                                    'autoclose' => true,
                                        ]
                                    ]) ?>
                                </div>
                            </div>

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_order_status_id')->dropDownlist($order_statusdata, [ 'prompt' => 'Search by Order Status'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_payment_code')->dropDownlist($payment_method, ['prompt' => 'Search by Payment Mode'])->label(false); ?>
                            </div>

                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_first_status')->dropDownlist(['Lead' => 'Lead', 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by First Status'])->label(false); ?>
                            </div>
                            
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>

                </div>
                <?php $form1 = ActiveForm::begin(['id' => 'import-student', 'options' => ['target' => '_blank'], 'action' => ['get-apiname'], 'method' => 'post']); ?>

                <?= $form->field($model, 'it_easy_ship_id')->hiddenInput(['id' => 'get_shipping_id'])->label(false); ?>

                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
  							'rowOptions' => function ($model) {
                                if($model->it_easy_read_status == '0'){
                                    return ['style' => 'background-color:#cbc9c9;text-align:center'];
                                }
                                return ['style' => 'text-align:center;'];
                            },
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                ['class' => 'yii\grid\CheckboxColumn'],


                                [
                                   'label' => 'Order-Number',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_order_number',
                                   'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],

                                   'value' => function ($model) {
                                        $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                                        return '<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name;

                                   }
                                ],
                                [
                                   'label' => 'Customer-Info',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_firstname',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {

                                        return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email;

                                   }
                                ],
		
                                [
                                   'label' => 'Address',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_city',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {

                                        return $model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;

                                   }
                                ],
                              
                              	[
                                   'label' => 'Disposition',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_order_disposition_id',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {
                                        $get_status_name = ItEasyOrder::GetOrderDispositionNamebystatusId($model->it_easy_order_disposition_id);
                                        return $get_status_name;

                                   }
                                ],
                              	
                             
                              
                              	[
                                   'label' => 'Serviceable',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_order_serviceable',
                                   'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                   'value' => function ($model) {
                                        if(!empty($model->it_easy_order_serviceable)){
                                            $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($model->it_easy_order_serviceable);
                                            $str_serviceable = '';
                                            if(!empty($get_serviceable_name)){
                                                $count_serviceable = count($get_serviceable_name);
                                                $check_serviceable = $count_serviceable - 1; 
                                                foreach ($get_serviceable_name as $key => $service){
                                                    if($service->it_easy_ship_id == '1'){
                                                        $str_serviceable .= '<a onclick="reassigned('.$model->it_easy_order_id.','.$service->it_easy_ship_id.')" title="'.$service->it_easy_name.'" class="btn btn-info delhivery-sfr btn-sm" style="background-color: #c5b01f;color: #ffffff;margin: 3px;">DEHV</a>&nbsp;';
                                                    }else if($service->it_easy_ship_id == '2'){
                                                        $str_serviceable .= '<a onclick="reassigned('.$model->it_easy_order_id.','.$service->it_easy_ship_id.')" title="'.$service->it_easy_name.'" class="btn btn-info aramex btn-sm" style="background-color: #f1ae7e;color: #ffffff;margin: 3px;">ECM</a><br>';
                                                    }else if($service->it_easy_ship_id == '3'){
                                                        $str_serviceable .= '<a onclick="reassigned('.$model->it_easy_order_id.','.$service->it_easy_ship_id.')" title="'.$service->it_easy_name.'" class="btn btn-info delhivery-sfr btn-sm" style="background-color: #2cbf59;color: #ffffff;margin: 3px;">XPB</a>&nbsp;';
                                                    }else if($service->it_easy_ship_id == '4'){
                                                        $str_serviceable .= '<a onclick="reassigned('.$model->it_easy_order_id.','.$service->it_easy_ship_id.')" title="'.$service->it_easy_name.'" class="btn btn-info delhivery-sfr btn-sm" style="background-color: #1f43c5;color: #ffffff;margin: 3px;">SHP</a><br>';
                                                    }
                                                }
                                              	$str_serviceable .= '<a href="'.BASE_URL.'order-dispatch/refresh-api?order_id='.$model->it_easy_order_id.'" data-toggle="tooltip" class=""  data-original-title="Refresh Serviceable API"><span style="font-size: 24px;float: right;margin-top: 14px;"><i class="typcn typcn-refresh"></i></span></a>';
                                            }    
                                            return $str_serviceable;
                                        }else{
                                            return '';
                                        }
                                   }
                                ],
                              
                              
                              
                              	[
                                    'label' => 'Updated',
                                   'format' => 'raw',
                                   'attribute' =>'it_easy_updated_time',
                                   'value' => function ($model) {
                                        return date('Y-m-d', strtotime($model->it_easy_updated_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_updated_time));
                                   }
                                ],
                                [
                                    'label' => 'Action',
                                   'format' => 'raw',
                                   'value' => function ($model) {
                                            return '<div class="dropdown nav-item main-header-notification">
                                                <a class="new nav-link" href="#">
                                                <span class=" pulse"></span></a>

                                            </div>';
                                   }
                                ],

                            ],
                        ]); ?>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
            </div>
        </div>
        <!--/div-->
    </div>
</div>