<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Call Back History';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
              	<div class="btn-group dropdown">
                    
                </div>
              
              	<div class="btn-group dropdown">
                    <?= Html::a('Create', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
                
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
               
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                // 'filterModel' => $searchModel,
                'columns'=>[

                    ['class'=>'yii\grid\SerialColumn'],
                    [
                        'label' => 'Order-Number',
                        'format' => 'raw',
                        'attribute' =>'it_easy_order_number',
                        'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],
 
                        'value' => function ($model) {
                             $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                             return '<b>'.$model->it_easy_order_number.'<br>'.$model->it_easy_other_order_id.'</b><br>'.$model->it_easy_first_status.'<br>'.$get_status_name;
                             
                        }
                     ],
                    [
                        'label' => 'Customer-Info',
                        'format' => 'raw',
                        'attribute' =>'it_easy_firstname',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {
                             
                             return $model->it_easy_firstname.' '.$model->it_easy_lastname.'<br>'.$model->it_easy_mobile_number.'<br>'.$model->it_easy_email;
                             
                        }
                     ],
                     [
                        'label' => 'Address',
                        'format' => 'raw',
                        'attribute' =>'it_easy_city',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {
                             
                             return $model->it_easy_city.'<br>'.$model->it_easy_state.'<br>'.$model->it_easy_pincode;
                             
                        }
                     ], [
                        'label' => 'Total/Coupon',
                        'format' => 'raw',
                        'attribute' =>'it_easy_total_price',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;font-weight:600;padding:12px;'],
                        'value' => function ($model) {
                             $coupon_data = ItEasyOrder::getCoouponbyid($model->it_easy_coupon_id);
                             if(!empty($coupon_data)){
                                 return '₹<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_price, 2, '.', '').'</span><br>Coupon('.$coupon_data->it_easy_coupon_code.')<br>₹'.number_format((float)$coupon_data->it_easy_discount, 2, '.', '');
                             }else{
                                 return '₹<span style="font-size:16px;">'.number_format((float)$model->it_easy_total_price, 2, '.', '').'</span>';
                             }
                             
                        }
                     ],
 
                     [
                        'label' => 'TL/Agent',
                        'format' => 'raw',
                        'attribute' =>'it_easy_assigned_to',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {
                             $get_agent_tl_name = ItEasyOrder::getTLandAgentName($model->it_easy_assigned_by, $model->it_easy_assigned_to);
                             return $get_agent_tl_name;
                             
                        }
                     ],
                     [
                        'label' => 'Disposition',
                        'format' => 'raw',
                        'attribute' =>'it_easy_order_disposition_id',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {
                             $get_status_name = ItEasyOrder::GetOrderDispositionNamebystatusId($model->it_easy_order_disposition_id);
                             return $get_status_name;
                             
                        }
                     ],
 
                     [
                        'label' => 'Serviceable',
                        'format' => 'raw',
                        'attribute' =>'it_easy_order_serviceable',
                        'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                        'value' => function ($model) {
                             if(!empty($model->it_easy_order_serviceable)){
                                 $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($model->it_easy_order_serviceable);
                                 $str_serviceable = '';
                                 if(!empty($get_serviceable_name)){
                                     $count_serviceable = count($get_serviceable_name);
                                     $check_serviceable = $count_serviceable - 1; 
                                     foreach ($get_serviceable_name as $key => $service){
                                         if($key == $check_serviceable){
                                             $str_serviceable .= $service->it_easy_name;
                                         }else{
                                             $str_serviceable .= $service->it_easy_name.'<br>';
                                         }
                                     }
                                 }    
                                 return $str_serviceable;
                             }else{
                                 return '';
                             }
                        }
                     ],
                     
                     [
                        'label' => 'CallBack',
                       'format' => 'raw',
                       'attribute' =>'it_easy_disposition_time',
                       'value' => function ($model) {
                            return date('Y-m-d', strtotime($model->it_easy_disposition_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_disposition_time));
                       }
                    ],
                   
                     [
                         'label' => 'Created',
                        'format' => 'raw',
                        'attribute' =>'it_easy_created_time',
                        'value' => function ($model) {
                             return date('Y-m-d', strtotime($model->it_easy_created_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_created_time));
                        }
                     ],
                     [
                         'label' => 'Updated',
                        'format' => 'raw',
                        'attribute' =>'it_easy_updated_time',
                        'value' => function ($model) {
                             return date('Y-m-d', strtotime($model->it_easy_updated_time)).'<br>'.date('H:i:s', strtotime($model->it_easy_updated_time));
                        }
                     ],
                     [
                         'label' => 'Action',
                        'format' => 'raw',
                        'value' => function (ItEasyOrder $model) {
                           



                                 return 
                                 
                                 '
                                 <div class="col-sm-1">
                                     <a class="text-white" href="calldone?orderid='.$model->it_easy_order_id.'">
                                     <button class="btn btn-primary btn-sm text-white">Call Done</>
                                     </a>
                                     
                                 </div>
                                 <div class="col-sm-1">
                                     <a class="text-white" href="callback">
                                     <button  class="btn btn-primary text-white btn-sm">Call Pending</>
                                     </a>
                                     
                                 </div>';
                        }
                     ],
                     [
                         'class' => ActionColumn::className(),
                         'template'=>'{update}',
                         'buttonOptions' => [
                             'target' => "_blank"
                          ],
                         'urlCreator' => function ($action, ItEasyOrder $model, $key, $index, $column) {
                             return Url::toRoute([$action, 'it_easy_order_id' => $model->it_easy_order_id]);
                          }
                     ],
                     
                ]
            ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>
