<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2; // or kartik\select2\Select2
use yii\web\JsExpression;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyState;
use backend\models\ItEasyProduct;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrder;
use kartik\datetime\DateTimePicker;
use backend\models\ItEasyDiseasesName;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrder $model */

$this->title = 'Update Order';
$this->params['breadcrumbs'][] = ['label' => 'It Easy Orders', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->it_easy_order_id, 'url' => ['view', 'it_easy_order_id' => $model->it_easy_order_id]];
$this->params['breadcrumbs'][] = 'Update';

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrder $model */
/** @var yii\widgets\ActiveForm $form */
$url = \yii\helpers\Url::to(['ajax/getstate']);
$productdata = [];




$order_dispositiondata = ArrayHelper::map(ItEasyOrderDisposition::find()->select(['it_easy_order_disposition_id', 'it_easy_order_disposition_name'])->andWhere(['it_easy_status' => 'Active'])->andWhere(['it_easy_disposition_type' => 'Order'])->all(), 'it_easy_order_disposition_id', 'it_easy_order_disposition_name');

$shipping_method = ArrayHelper::map(ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Shipping'])->andWhere(['it_easy_status' => 'Active'])->all(), 'it_easy_method_code', 'it_easy_method_name' );

$payment_method = ArrayHelper::map(ItEasyShippingPaymentMethod::find()->select(['it_easy_method_code', 'it_easy_method_name'])->andWhere(['it_easy_method_type' => 'Payment'])->andWhere(['it_easy_status' => 'Active'])->all(), 'it_easy_method_code', 'it_easy_method_name' );
// echo "<pre>"; print_r($productdata); die;
$diseases = ArrayHelper::map(ItEasyDiseasesName::find()->select(['it_easy_id', 'it_easy_name'])->where(['it_easy_status' => 'Active'])->all(), 'it_easy_id', 'it_easy_name' );

// echo "<pre>"; print_r($model->it_easy_disease_name); die;
// if(!empty($model->it_easy_disease_name)){
//     $model->it_easy_disease_name = explode(',', $model->it_easy_disease_name);
// }
?>
<style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }
    .timeline-badge{
        left: 43.5% !important;
        width: 35px !important;
        height: 35px !important;
    }
    .timeline-panel{
        width: 53% !important;
        margin-left: 0% !important;
        margin-right: 0% !important;
        padding-right: 5px !important;
        padding-left: 5px !important; 
    }
    .timeline-title{
        color: #939393;
    }
    .vtimeline .timeline-wrapper.timeline-inverted .timeline-panel{
        margin-left: auto !important;
        

    }
    .vtimeline .timeline-wrapper .timeline-badge i{
        font-size: 14px !important;
        line-height: 33px !important;
    }
    .timeline-wrapper-primary .timeline-panel:before, .timeline-wrapper-primary .timeline-badge{
        background-color: #eb4b26 !important;
    }
    .timeline-wrapper-secondary .timeline-panel:before, .timeline-wrapper-secondary .timeline-badge{
        background-color: #eb4b26 !important;
    }
    .timeline-wrapper-info .timeline-panel:before, .timeline-wrapper-info .timeline-badge{
        background-color: #eb4b26 !important;
    }

    .show_customer_dropdown{
        background-color: #f7f3f3;
        /* padding-left: 10px; */
        margin-top: -17px;
        border-radius: 5px;
        border: 2px solid #fbebce;
        padding-top: 10px;
        max-height: 210px;
        overflow: scroll;
        display: none;
    }
    .tiny-add-customer{
        list-style: none;
        overflow-x: scroll;
        color: #8d8a8a;
        font-size: 14px;
        font-weight: 700;
        margin-bottom: -6px;
    }
    .tiny-add-customer > li{
        padding: 10px 1px 10px 25px;
        border-bottom: 1px solid #dfdcdc;
        margin-left: -43px;
        cursor: pointer;
    }
    @media (min-width: 576px){
        .modal-dialog{
            max-width: 700px !important;
        }
    }
    label{
        font-size: 15px;
        font-weight: 400;
    }
    .title{
        padding-bottom: 15px;
        border-bottom: 1px solid #e3e8f7;
        margin-bottom: 20px;
    }
</style>

<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between" style="background-color: #fcfcfc;padding: 10px;color: #999898;">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::submitButton('Save Order', ['class' => 'btn btn-dark btn-block',  'id' => 'submit_button_take_4']) ?>&nbsp;&nbsp;&nbsp;
                    <div class="pr-1 mb-xl-0">

                        <a href="<?= BASE_URL ?>order"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->
    <span class="order_id_get" style="display:none;"><?= $model->it_easy_order_id; ?></span>
    
    <span class="coupon_id_get" style="display:none;"><?= $model->it_easy_coupon_id; ?></span>
    <div class="row">
        <div class="col-lg-3 col-md-3">
            <div class="vtimeline" style="background-color:#ffffff; padding: 10px;">
                <div class="timeline-wrapper timeline-wrapper-primary">
                    <div class="timeline-badge success" id="checkbox_customer_adding_class" style="background-color: #d7e54a !important;">
                    	<i class="fas fa-check" id="checkbox_customer_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Customer</h6>
                        </div>
                    </div>
                </div>

                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge success" id="checkbox_billing_adding_class" style="background-color: #d7e54a !important;"><i class="fas fa-check" id="checkbox_billing_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Billing</h6>
                        </div>
                    </div>
                </div>

                <div class="timeline-wrapper timeline-wrapper-info">
                    <div class="timeline-badge" id="checkbox_shipping_adding_class" style="background-color: #d7e54a !important;"><i class="fas fa-check" id="checkbox_shipping_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Shipping</h6>
                        </div>
                    </div>
                </div>
                
                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge" id="checkbox_product_adding_class" style="background-color: #d7e54a !important;"><i class="fas fa-check" id="checkbox_product_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Product</h6>
                        </div>
                    </div>
                </div>
                <div class="timeline-wrapper timeline-wrapper-info">
                    <div class="timeline-badge" id="checkbox_payments_adding_class" style="background-color: #d7e54a !important;"><i class="fas fa-check" id="checkbox_payments_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Payments</h6>
                        </div>
                    </div>
                </div>

                <?php if(!empty($order_dispatch_details)){ ?>
                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge" style="background-color: #d7e54a !important;"><i class="fas fa-check" id="checkbox_couries_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Courier</h6>
                        </div>
                    </div>
                </div>

                <?php }else{ ?>    
                <div class="timeline-wrapper timeline-inverted timeline-wrapper-secondary">
                    <div class="timeline-badge success"><i class="fas fa-times" id="checkbox_couries_adding" aria-hidden="true"></i></div>
                    <div class="timeline-panel">
                        <div class="timeline-heading">
                            <h6 class="timeline-title">Courier</h6>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
        
        <div class="col-lg-9 col-md-9">
            
            
            <div class="col-lg-6 col-md-6">
    		<div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Order Status History
                    </div>
                    <p class="mg-b-20"></p>
                    <?php $formstatus = ActiveForm::begin(); ?>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
                       
                        <div class="col-md-12">
                    <?= $formstatus->field($statusmodel, 'it_easy_order_status_id')->dropDownList($order_statusdata, ['prompt' => 'Select Order Status']); ?>
                        </div> 

                        <div class="col-md-8">   
               		<?= $formstatus->field($statusmodel, 'it_easy_comment')->textArea(); ?>
                        </div>

                        <div class="col-md-4" style="float: right; margin-top: 30px;">
                            <?= Html::submitButton('Save', ['class' => 'btn btn-secondary btn-block']) ?>
                        </div>

                        </div>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0">

                        <tbody>
                            <tr>
                                <td class="w-1" style="width:25%;"><strong>Status</strong></td>
                                <td style="width:50%;"><strong>Comment</strong></td>
                                <td class="w-1 text-right" style="width:25%;"><b>Status-Time</b></td>
                            </tr>
                        <?php if(!empty($order_status_history)){
                        	foreach ($order_status_history as $key => $o_s_history) {
             					$status_name = ItEasyOrder::GetOrderStatusNamebystatusId($o_s_history->it_easy_order_status_id);
                         ?>    
                            <tr>
                                <td class="w-1" style="width:25%;"><?= $status_name; ?></td>
                                <td style="width:50%;"><?= $o_s_history->it_easy_comment; ?></td>
                                <td class="w-1 text-right" style="width:25%;"><?= $o_s_history->it_easy_created_time; ?></td>
                            </tr>
                        <?php } } ?>    
                        </tbody>
                    </table>
                    
                        </div>
                    </div>
                </div>

                
            </div>
            </div>
            <div class="col-lg-6 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Order Disposition History
                    </div>
                    <p class="mg-b-20"></p>
                    <?php $formdisposition = ActiveForm::begin(); ?>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
                       
                        <div class="col-md-12">
                    <?= $formdisposition->field($dispositionmodel, 'it_easy_order_disposition_id')->dropDownList($order_dispositiondata, ['prompt' => 'Select Disposition']); ?>
                        </div> 
						<div class="col-md-12">   
               		<?php 
               		echo '<label>Select Callback Time</label>';
					

					echo DateTimePicker::widget([
                        'name' => 'ItEasyOrder[it_easy_disposition_time]',
                        'value' => $model->it_easy_disposition_time,
                      	'options' => ['placeholder' => 'Select Callback Time'],
                        'pluginOptions' => [
                            'format' => 'yyyy-mm-dd hh:ii:ss',
                          	'startDate' => '2023-01-10 00:00:00',
					        'todayHighlight' => true,
                          	'autoclose' => true,
                        ]
                    ]);
					?>
			<br>
                        </div>
                        <div class="col-md-8">   
               		<?= $formdisposition->field($dispositionmodel, 'it_easy_comment')->textArea(); ?>
                        </div>
                        
                        <div class="col-md-4" style="float: right; margin-top: 30px;">
                            <?= Html::submitButton('Save', ['class' => 'btn btn-secondary btn-block']) ?>
                        </div>

                        </div>
                    </div>
                    <?php ActiveForm::end(); ?>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0">

                        <tbody>
                            <tr>
                                <td class="w-1" style="width:25%;"><strong>Disposition</strong></td>
                                <td style="width:50%;"><strong>Comment</strong></td>
                                <td class="w-1 text-right" style="width:25%;"><b>Status-Time</b></td>
                            </tr>
                         <?php if(!empty($order_disposition_history)){
                        	foreach ($order_disposition_history as $key => $o_d_history) {
             					$status_name = ItEasyOrder::GetOrderDispositionNamebystatusId($o_d_history->it_easy_order_disposition_id);
                         ?>    
                            <tr>
                                <td class="w-1" style="width:25%;"><?= $status_name; ?></td>
                                <td style="width:50%;"><?= $o_d_history->it_easy_comment; ?></td>
                                <td class="w-1 text-right" style="width:25%;"><?= $o_d_history->it_easy_created_time; ?></td>
                            </tr>
                        <?php } } ?>
                  
                        </tbody>
                    </table>
                    
                        </div>
                    </div>
                </div>

                
            </div>

        

    	</div>
            
            
            
        </div>
    </div>
    <div class="row">
        
        
        <div class="col-lg-12 col-md-12">
        <?php $form = ActiveForm::begin(); ?>
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Customer Information
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                            <?= $form->field($model, 'it_easy_customer_id')->textInput(['id' => 'Add-Customer', 'placeholder' => 'Add & Search by Name or mobile number', 'value' => ''])->label(false); ?>
                        <div class="show_customer_dropdown" id="show_customer_dropdown">

                        </div>
                

                        <div class="card" id="customer_information_show">
                            <div class="card-header pb-0">
                                <div class="card-title pb-0  mb-2" id="customer_name_add" style="font-size: 20px;"><?= $model->it_easy_firstname.' '.$model->it_easy_lastname; ?></div>
                                <p class="tx-14 tx-gray-500 mb-3" id="custome_address_add"><?= $model->it_easy_address_1.' '.$model->it_easy_address_2.' '.$model->it_easy_city.' '.$model->it_easy_state.' '.$model->it_easy_pincode; ?></p>
                                <div class="right" style="float: right;margin-top: -76px;">
                                    <button type="button" class="btn btn-primary" data-target="#scrollmodal" data-toggle="modal"><i class="typcn typcn-pen"></i></button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col text-center">
                                        <label class="tx-12" >Mobile</label>
                                        <p class="font-weight-bold tx-16" id="customer_mobile_add"><?= $model->it_easy_mobile_number; ?>,<br><?= $model->it_easy_alternate_number; ?></p>
                                    </div><!-- col -->
                                    <div class="col border-left text-center">
                                        <label class="tx-12">Email</label>
                                        <p class="font-weight-bold tx-16" id="customer_email_add"><?= $model->it_easy_email; ?></p>
                                    </div><!-- col -->
                                    <div class="col border-left text-center">
                                        <label class="tx-12">Pincode</label>
                                        <p class="font-weight-bold tx-16" id="customer_pincode_add"><?= $model->it_easy_pincode; ?></p>
                                    </div><!-- col -->
                                </div><!-- row -->
                                <div class="progress ht-20 mt-4">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary ht-20 wd-95p">99%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
    	</div>	
        
        	<?php $form = ActiveForm::begin(); ?>
        <div class="col-lg-6 col-md-6">	
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Add Product
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
                        <div class="col-md-5">
                <?= 


                $form->field($product_model, 'it_easy_product_id')->widget(Select2::classname(), [
                            'data' => $productdata,
                            'options' => [ 'placeholder' => 'Search for a Product ...', 'class' => 'order_variation_change_status'],
                            'pluginOptions' => [
                                'allowClear' => true,
                                'minimumInputLength' => 2,
                                'language' => [
                                    'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
                                ],
                                'ajax' => [
                                    'url' => $url = \yii\helpers\Url::to(['ajax/getproduct']),
                                    'dataType' => 'json',
                                    'data' => new JsExpression('function(params) { return {q:params.term}; }')
                                ],
                                'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                                'templateResult' => new JsExpression('function(city) { return city.text; }'),
                                'templateSelection' => new JsExpression('function (city) { return city.text; }'),
                            ],
                        ])->label(false);

                    //$form->field($product_model, 'it_easy_product_id')->dropDownList($productdata, ['prompt' => 'Search by Product'])->label(false);


                         ?>     
                        </div>

                        <div class="col-md-4">
                <?= $form->field($product_model, 'it_easy_variation_id')->dropDownList([], ['prompt' => 'Search Variation'])->label(false); ?>     
                        </div>

                        <div class="col-md-3">
                                <button class="btn btn-secondary" id="add_product_creater" type="button">Add Product</button>
                        </div>
                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0" id="product_table_Add_show">
                        <tbody>
                            <tr data-id="0">
                                <td class="w-1" style="width:15%;"></td>
                                <td style="width:46%;"><b>Product Details<b></td>
                                <td class="w-1 text-right" style="width:14%;"><b>Quantity</b></td>
                                <td class="w-1 text-right" style="width:15%;"><b>Total</b></td>

                                <td class="w-1 text-right" style="width:10%;"></td>
                            </tr>

                         <?php if(!empty($prod_model)){
                         		$subtotal_price = 0; 
                         		foreach ($prod_model as $key => $pro) {
                         			$ar_key = $key +1;
                         			$product_with_tax = $pro->it_easy_product_total - $pro->it_easy_product_tax;
                                  	if(!empty($pro->it_easy_product_id)){
                                        $p_data = ItEasyOrder::FindProductbyid($pro->it_easy_product_id);

                                        $varitaion_data = ItEasyOrder::getProductVariationData($pro->it_easy_product_id, $pro->it_easy_variation_id);

                                        if(empty($p_data->it_easy_product_image)){
                                              	if(!isset($p_data->it_easy_product_image)){	
                                            		$it_easy_product_image = 'dummy_product.png';
                                                }
                                        }else{
                                           $it_easy_product_image = $p_data->it_easy_product_image;
                                        }
                                        
                                        
                                        if($p_data['it_easy_product_included_exclude_tax'] == 'include'){

                                            $product_total_price = $pro->it_easy_product_total;

                                        }else{
                                            $product_total_price = $pro->it_easy_product_total - $pro->it_easy_product_tax;
                                        }


                                        $subtotal_price += $pro->it_easy_product_total - $pro->it_easy_product_tax;
                                    }else{
                                      	$it_easy_product_image = 'dummy_product.png';
                                      	$varitaion_data = [];
                                      	$subtotal_price += $pro->it_easy_product_total - $pro->it_easy_product_tax;
                                      	$product_total_price = $pro->it_easy_product_total;
                                      

                                    }
                                    
                                    if(!empty($pro->it_easy_product_total)){
                                        $set_one_product_total = $pro->it_easy_product_total / $pro->it_easy_product_quantity;
                                    }else{
                                        $set_one_product_total = 0;
                                    }
                                  
                         		?>
                         	
                         	<tr class="row_for_product_<?= $key; ?>" data-id="<?= $ar_key; ?>">
                         		<td class="w-1">
                         			<img height="80" width="80" src="<?= BASE_URL; ?>upload/<?= $it_easy_product_image; ?>" alt="flags" class="">
                         		</td>
                         		<td>
                         			<h6><?= $pro->it_easy_product_name; ?> ( <?= $pro->it_easy_variation_name; ?> )</h6>
                         			<p>₹<?= $pro->it_easy_product_total / $pro->it_easy_product_quantity; ?></p>
                                    <div class="progress progress-sm mt-1">
                                        <div class="progress-bar bg-primary wd-200"></div>
                                        
                                        <input type="hidden" name="ItEasyOrderProduct[<?= $key; ?>][it_easy_id]" value="<?= $pro->it_easy_id; ?>" >
                                        
                                        <input type="hidden" name="ItEasyOrderProduct[<?= $key; ?>][it_easy_product_id]" value="<?= $pro->it_easy_product_id; ?>" >
                                        <input type="hidden" name="ItEasyOrderProduct[<?= $key; ?>][it_easy_variation_id]" value="<?= $pro->it_easy_variation_id; ?>" >
                                        
                                        <input type="hidden" name="ItEasyOrderProduct[<?= $key; ?>][it_easy_product_total]" value="<?= $set_one_product_total; ?>" >
                                    </div>
                                </td>
                                <td class="w-1 text-right">
                                	<input type="number" name="ItEasyOrderProduct[<?= $key; ?>][it_easy_product_quantity]"  class="form-control quantity_row_product" id="quantity_row_product" data-id="<?= $key; ?>" data-value="<?= $product_with_tax.'$$$'.$pro->it_easy_product_tax.'$$$'.$product_total_price; ?>" value="<?= $pro->it_easy_product_quantity; ?>" style="width: 60px;float: right;">
                                	<span class="last_time_quantity_check_<?= $key; ?>" style="display:none;">1<span>
                                </td>
                                <td class="w-1 text-right">
                                	<b><span class="row_product_price_<?= $key; ?>" data-id="<?= $key; ?>" data-value="<?= $pro->it_easy_product_total; ?>" style="font-size:16px;">₹<?= $pro->it_easy_product_total; ?></span></b></td>
                                <td class="w-1 text-right"><h4><i class="fa fa-times remove_tr_product" style="cursor:pointer;" data-id="<?= $key ?>" data-value="<?= $product_with_tax.'$$$'.$pro->it_easy_product_tax.'$$$'.$product_total_price; ?>"></i></h4></td>
                            </tr>
                         

                         <?php } }else{ $subtotal_price = 0;  } ?>  
                        </tbody>
                    </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
        <div class="col-lg-6 col-md-6">	
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        Payments
                    </div>
                    <p class="mg-b-20"></p>
                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row">
          				<div class="col-md-12">
                    <?= $form->field($model, 'it_easy_disease_name')->widget(Select2::classname(), [
                        'data' => $diseases,
                        'language' => 'en',
                        'options' => ['placeholder' => 'Select Disease Name ...','multiple' => true],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                        ]);

                         ?>
                        </div> 

                        <div class="col-md-6">
                  
                        <?= $form->field($model, 'it_easy_course_duration')->dropDownList([ '1 week' => '1 week', '15 days' => '15 days', '1 month' => '1 month', '45 days' => '45 days', '2 months' => '2 months', '3 months' => '3 months', '4 months' => '4 months', '5 months' => '5 months', '6 months' => '6 months'], ['prompt' => 'Select Course Duration'])->label('Course Duration') ?>

                        </div> 

                        <div class="col-md-6">
                        
                        <?= $form->field($model, 'it_easy_age')->textInput(['maxlength' => true]) ?>
                        </div>
                          
                        <div class="col-md-6">

                        	<?php 
                        	if($get_shippingmethod->it_easy_method_value_type == 'Add-Amount'){ 
                        		$var_add_shipping = $get_shippingmethod->it_easy_method_value.'_add';
                        	}else{
                        		$var_add_shipping = $get_shippingmethod->it_easy_method_value.'_minus';
                        	}
                        	if($get_paymentmethod->it_easy_method_value_type == 'Add-Amount'){ 
                        		$var_add_payment = $get_paymentmethod->it_easy_method_value.'_add';
                        	}else{
                        		$var_add_payment = $get_paymentmethod->it_easy_method_value.'_minus';
                        	}
                        	?>
                        	<input type="hidden" name="ItEasyOrder[Payment_Value_Old]" id="Payment_Value_Old" value="<?= $var_add_payment; ?>">
                            <input type="hidden" name="ItEasyOrder[Shipping_Value_Old]" id="Shipping_Value_Old" value="<?= $var_add_shipping; ?>">
                            <?= $form->field($model, 'it_easy_payment_code')->dropDownList($payment_method, ['prompt' => 'Select Payment Method']); ?>

                        </div>
                        <div class="col-md-6">
                    <?= $form->field($model, 'it_easy_shipping_code')->dropDownList($shipping_method, ['prompt' => 'Select Shipping Method']); ?>
                        </div> 

                        <div class="col-md-9">   
                <?= $form->field($model, 'it_easy_coupon_id')->widget(Select2::classname(), [
                            'data' => $coupon_data,
                            'options' => [ 'placeholder' => 'Search for a Coupon...', 'class' => 'order_variation_change_status', 'value' => ''],
                            'pluginOptions' => [
                                'allowClear' => true,
                                'minimumInputLength' => 2,
                                'language' => [
                                    'errorLoading' => new JsExpression("function () { return 'Waiting for results...'; }"),
                                ],
                                'ajax' => [
                                    'url' => $url = \yii\helpers\Url::to(['ajax/getcoupon']),
                                    'dataType' => 'json',
                                    'data' => new JsExpression('function(params) { return {q:params.term}; }')
                                ],
                                'escapeMarkup' => new JsExpression('function (markup) { return markup; }'),
                                'templateResult' => new JsExpression('function(city) { return city.text; }'),
                                'templateSelection' => new JsExpression('function (city) { return city.text; }'),
                            ],
                        ])->label(false);

                    //$form->field($product_model, 'it_easy_product_id')->dropDownList($productdata, ['prompt' => 'Search by Product'])->label(false);


                         ?>  
                         
                <input type="hidden" name="ItEasyOrder[coupon_id_last]" class="old_coupon_value" value="<?= $model->it_easy_coupon_id; ?>">         
                        </div>

                        <div class="col-md-3" style="float: right;">
                                <button class="btn btn-secondary" id="apply_coupon22" type="button">Apply Coupon</button>
                        </div>

                        </div>
                    </div>
                </div>

                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12" style="padding: 15px 30px;">
                    <table class="table card-table country-table mb-0" id="product_table_Add_show">

                        <tbody>
                            <tr data-id="0">
                                <td class="w-1" style="width:25%;"><strong>Subtotal</strong></td>
                                <td style="width:50%;"></td>
                                <td class="w-1 text-right" style="width:25%;"><b>₹<span class="order_subtotal_price"><?= number_format((float)$subtotal_price, 2, '.', ''); ?></span></b></td>
                            </tr>
                            <tr data-id="1">
                                <td class="w-1" style="width:25%;">Add discount</td>
                                <td style="width:50%;"><span class="add_coupon_name" style="font-size: 18px;font-weight: 900;font-family: sans-serif;"><?php if(!empty($get_coupon_data->it_easy_coupon_code)){  echo $get_coupon_data->it_easy_coupon_code; } ?> </span> <?php if(!empty($get_coupon_data->it_easy_coupon_code)){ ?> &nbsp;&nbsp;<span style="cursor:pointer;font-size: 20px;color: #d91818;" id="remove-coupon" title="Remove Coupon"><i class="fas fa-times"></i></span> <?php } ?></td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_discount_price"><?= !empty($get_coupon_data->it_easy_coupon_discount) ? number_format((float)$get_coupon_data->it_easy_coupon_discount, 2, '.', '') : '0.00'; ?></span></td>
                            </tr>
                            <tr data-id="2">
                                <td class="w-1" style="width:25%;">Add Shipping</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_shipping_price"><?= number_format((float)$get_shippingmethod->it_easy_method_value, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="2">
                                <td class="w-1" style="width:25%;">COD Handling Charges</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_cod_handling_price"><?= number_format((float)$get_paymentmethod->it_easy_method_value, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="3">
                                <td class="w-1" style="width:25%;">Estimate Tax</td>
                                <td style="width:50%;">—</td>
                                <td class="w-1 text-right" style="width:25%;">₹<span class="add_estimate_tax_price"><?= number_format((float)$model->it_easy_gst_price, 2, '.', ''); ?></span></td>
                            </tr>
                            <tr data-id="4">
                                <td class="w-1" style="width:25%;"><strong>Total</strong></td>
                                <td style="width:50%;"></td>
                                <div class="main_total_price" style="display:none;"><?= number_format((float)$model->it_easy_total_price, 2, '.', ''); ?></div>
                                <td class="w-1 text-right" style="width:25%;"><b>₹<span class="add_Total_price"><?= number_format((float)$model->it_easy_total_price, 2, '.', ''); ?></span></b></td>
                            </tr>

                        </tbody>
                    </table>
                        <p style="padding: 10px;margin-top: 10px;">Taxes may be estimates until the order is created.</p>
                        </div>
                    </div>
                </div>

                <div class="col-md mt-4 mt-xl-0" style="margin-top:30px !important;">
                    <?= Html::submitButton('Save Order', ['class' => 'btn btn-dark btn-block', 'id' => 'submit_button_take_1']) ?>
                    <br>
                </div>
            </div>
          </div>
          	<?php ActiveForm::end(); ?>
          	
          	  
        
		<?php if(!empty($order_dispatch_details)){ ?>
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                  <div class="col-lg-4 col-md-4">
                  	<div class="card mg-b-20 text-center">
                      <div class="card-body h-100">
                        <img src="<?= BASE_URL ?>img/note_taking.svg" alt="" class="wd-35p">
                        <h5 class="mg-b-10 mg-t-15 tx-18"><?= !empty($order_dispatch_details->it_easy_order_number) ? $order_dispatch_details->it_easy_order_number : ''; ?></h5>
                        <a href="#" class="text-muted">Order Number</a>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-md-4">
                    <div class="card mg-b-20 text-center">
                        <div class="card-body h-100">
                            <img src="<?= BASE_URL ?>img/no-data.svg" alt="" class="wd-35p">
                            <h5 class="mg-b-10 mg-t-15 tx-18"><?= !empty($order_dispatch_details->it_easy_courier_name) ? $order_dispatch_details->it_easy_courier_name : ''; ?></h5>
                          	<a href="#" class="text-muted">Courier Name</a>
                        </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-md-4">
                  	<div class="card mg-b-20 text-center">
                      <div class="card-body h-100">
                        <img src="<?= BASE_URL ?>img/imac.svg" alt="" class="wd-40p">
                        <h5 class="mg-b-10 mg-t-15 tx-18"><?= !empty($order_dispatch_details->it_easy_awb_number) ? $order_dispatch_details->it_easy_awb_number : ''; ?></h5>
                        <a href="#" class="text-muted">AWB Number</a>
                      </div>
                    </div>
                  </div>
                    <div class="table-responsive border-top userlist-table">
                        <table class="table card-table table-striped table-vcenter text-nowrap mb-0">
                            <thead>
                                <tr>
                                    <th class="wd-lg-13p"><span>Order Number</span></th>
                             		<th class="wd-lg-22p"><span>AWB Number</span></th>
                                    <th class="wd-lg-15p"><span>Location</span></th>
                                    <th class="wd-lg-15p"><span>Order Status</span></th>
                                    <th class="wd-lg-30p"><span>Courier Comment</span></th>
                                    <th class="wd-lg-15p">Courier Time</th>
                              
                                </tr>
                            </thead>
                            <tbody>
                              
                              <?php if(!empty($trackModel)){ 
                                  foreach($trackModel as $key => $track){

                                ?>
                                <tr>
                                    
                                    <td><?= $track->it_easy_order_awb; ?></td>
                                  	<td><?= $track->it_easy_awb_number; ?></td>
                                  	<td><?= $track->it_easy_location; ?></td>
                                  	<td><?= $track->it_easy_order_status; ?></td>
                                  	<td><?= $track->it_easy_courier_comment; ?></td>
                                  	<td><?= $track->it_easy_courier_time; ?></td>
                                    
                                </tr>
                              
                              <?php } }else{ ?>
                  
                              <tr><td colspan="6">No Data Found!</td></tr>
                              <?php } ?>
                            </tbody>
                        </table>
                    </div>    


                </div>
            </div>
        </div> 
          <?php } ?>  	
          
     </div>
</div>





<?php $form = ActiveForm::begin(); ?> 
<div class="modal show" id="scrollmodal" style="display: none;" aria-modal="true">
    <div class="modal-dialog modal-dialog-scrollable" role="document">
        <div class="modal-content modal-content-demo">
            <div class="modal-header">
                <h6 class="modal-title">Customer Information</h6><button aria-label="Close" class="close" data-dismiss="modal" type="button"><span aria-hidden="true">×</span></button>
            </div>
            
            <div class="modal-body">

                <div class="row">
                    <div style="display: none;">
                        <?= $form->field($model, 'it_easy_customer_id')->hiddenInput([])->label(false); ?>
                    </div>
                    <div class="col-md-6">
                        
                        <?= $form->field($model, 'it_easy_firstname')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_lastname')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_mobile_number')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_alternate_number')->textInput(['maxlength' => true]) ?>
                    </div>        
                    <div class="col-md-4">
                        <?= $form->field($model, 'it_easy_email')->textInput(['maxlength' => true]) ?>
                    </div>
                    
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_address_1')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-6">
                        <?= $form->field($model, 'it_easy_address_2')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_city')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-3">
                    <?= $form->field($model, 'it_easy_pincode')->textInput(['maxlength' => true]) ?>
                    </div>
                    <div class="col-md-3">
                        <?= $form->field($model, 'it_easy_fax')->textInput(['maxlength' => true]) ?>
                    </div>
                </div>  
                <br>
                <div class="content clearfix">
                   	<div class="row">
                   	<div class="col-md-6"> 
                    <h3 id="wizard1-h-0" tabindex="-1" class="title current">Billing Information</h3>
                    </div>
                    <div class="col-md-6"><input type="checkbox" name="" id="forbilling"><span style="font-weight: 700;"> Same as main address</span>
                    </div>
                    </div>
                    <section id="wizard1-p-0" role="tabpanel" aria-labelledby="wizard1-h-0" class="body current" aria-hidden="false">
                     <div class="row">  
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_firstname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_lastname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_company_name')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_gst')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_mobile')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_alternate_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_email')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_address_1')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_address_2')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                
                                
                                <?= $form->field($model, 'it_easy_billing_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_city')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_billing_pincode')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                    </div>
                    </section>
                </div>

                <br>
                <div class="content clearfix">
                   <div class="row">
                        <div class="col-md-6">
                    <h3 id="wizard1-h-0" tabindex="-1" class="title current">Shipping Information</h3>
                    </div>
                     <div class="col-md-6"><input type="checkbox" name="" id="forshiping"><span style="font-weight: 700;">   Same as main address</span>
                    </div>
                    </div>
                    <section id="wizard1-p-0" role="tabpanel" aria-labelledby="wizard1-h-0" class="body current" aria-hidden="false">
                     <div class="row">  
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_firstname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_lastname')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_mobile_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_alternate_number')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_email')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_address_1')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-6"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_address_2')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                

                                <?= $form->field($model, 'it_easy_shipping_state_id')->dropDownList($statedata, ['prompt' => 'Search by State']); ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_city')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                        <div class="col-md-4"> 
                            <div class="control-group form-group">
                                <?= $form->field($model, 'it_easy_shipping_pincode')->textInput(['maxlength' => true]) ?>
                            </div>
                        </div>
                    </div>
                    </section>
                </div>
            </div>
            
            <div class="modal-footer">
                <button class="btn ripple btn-primary" type="submit">Save changes</button>
                <button class="btn ripple btn-secondary" data-dismiss="modal" type="button">Close</button>
            </div>
            
        </div>
    </div>
</div>

<?php ActiveForm::end(); ?>



<div class="sweet-overlay" tabindex="-1" style="opacity: -0.01;display: none;"></div>
<div class="sweet-alert showSweetAlert visible" data-custom-class="" data-has-cancel-button="false" data-has-confirm-button="true" data-allow-outside-click="false" data-has-done-function="false" data-animation="pop" data-timer="null" style="display: none;margin-top: -182px;">
    
    <div class="sa-icon sa-success animate" style="display: block;">
      <span class="sa-line sa-tip animateSuccessTip"></span>
      <span class="sa-line sa-long animateSuccessLong"></span>

      <div class="sa-placeholder"></div>
      <div class="sa-fix"></div>
    </div>
    <h2>Well done!</h2>
    <p style="display: block;">You added a customer!</p>
    <fieldset>
      <input type="text" tabindex="3" placeholder="">
      <div class="sa-input-error"></div>
    </fieldset>
    <div class="sa-error-container">
      <div class="icon">!</div>
      <p>Not valid!</p>
    </div>
    <div class="sa-button-container">
      <button class="cancel" tabindex="2" style="display: none; box-shadow: none;">Cancel</button>
      <div class="sa-confirm-button-container">
        <button class="confirm" tabindex="1" style="display: inline-block; background-color: rgb(87, 169, 79); box-shadow: rgba(87, 169, 79, 0.8) 0px 0px 2px, rgba(0, 0, 0, 0.05) 0px 0px 0px 1px inset;">OK</button><div class="la-ball-fall">
          <div></div>
          <div></div>
          <div></div>
        </div>
      </div>
    </div>
</div>


<div class="sweet-alert showSweetAlert visible" id="sweet-alert2" data-custom-class="" data-has-cancel-button="false" data-has-confirm-button="true" data-allow-outside-click="false" data-has-done-function="false" data-animation="pop" data-timer="null" style="display: none;margin-top: -182px;">
    
    <div class="sa-icon sa-error">
      <span class="sa-x-mark">
        <span class="sa-line sa-left"></span>
        <span class="sa-line sa-right"></span>
      </span>
    </div>
    <h2 class="product_add_error">!</h2>
    <br>
    <fieldset>
      <input type="text" tabindex="3" placeholder="">
      <div class="sa-input-error"></div>
    </fieldset>
    <div class="sa-error-container">
      <div class="icon">!</div>
      <p>Not valid!</p>
    </div>
    <div class="sa-button-container">
      <div class="sa-confirm-button-container">
        <button class="confirm" tabindex="1" style="display: inline-block; background-color: rgb(87, 169, 79); box-shadow: rgba(87, 169, 79, 0.8) 0px 0px 2px, rgba(0, 0, 0, 0.05) 0px 0px 0px 1px inset;">OK</button><div class="la-ball-fall">
          <div></div>
          <div></div>
          <div></div>
        </div>
      </div>
    </div>
</div>

