<?php
namespace console\controllers;

use Yii;
use yii\console\Controller;
use backend\models\AddressChangeLog;
use backend\models\ItEasyOrder;
use backend\models\CronAddressUpdateSummary;
class AddressController extends Controller
{
    public function actionCronUpdateAddress()
    {
        
         $updatedCount = 0;
    $failedCount = 0;
    $updatedIds = [];
    $failedIds = [];
        $pendingLogs = AddressChangeLog::find()
            ->where(['change_status' => 0])
            ->all();

        foreach ($pendingLogs as $log) {
            $message = '';
            $order = ItEasyOrder::findOne(['it_easy_other_order_id' => $log->order_id]);

            if ($order) {
                $decodedNew = json_decode($log->new_address, true);

                if (is_array($decodedNew)) {
                    // Save old address
                    $log->old_address = json_encode([
                        'order_id_crm' => $order->it_easy_order_id,
                        'address1' => $order->it_easy_shipping_address_1,
                        'address2' => $order->it_easy_shipping_address_2,
                        'city'     => $order->it_easy_shipping_city,
                        'state'    => $order->it_easy_shipping_state,
                        'pin'      => $order->it_easy_shipping_pincode,
                        'shop_id'  => $order->it_easy_other_order_id,
                    ]);

                    // Update to new address
                    $order->it_easy_shipping_address_1 = $decodedNew['address1'] ?? '';
                    $order->it_easy_shipping_address_2 = $decodedNew['address2'] ?? '';
                    $order->it_easy_shipping_city      = $decodedNew['city'] ?? '';
                    $order->it_easy_shipping_pincode   = $decodedNew['pincode'] ?? '';
                    $order->it_easy_shipping_state     = $decodedNew['state'] ?? '';
                    $order->it_easy_order_add_verify = 1;
                    
                    $order->it_easy_order_status_id = '1';
                    $order->it_easy_order_disposition_id = '3';
                    $order->it_easy_assigned_by = '1';
                    $order->it_easy_assigned_to = '231';
                    

                    // Save both
                    $order->save(false);
                    $log->change_status = 1;
                    $message = "Order ID {$log->order_id} address updated.";
                    $updatedCount++;
                $updatedIds[] = $log->order_id;
                } else {
                    $message = "Invalid JSON in new_address for Order ID {$log->order_id}.";
                    $failedCount++;
                $failedIds[] = $log->order_id;
                }
            } else {
                $message = "order ID {$log->order_id} not found in order table.";
                  $failedCount++;
            $failedIds[] = $log->order_id;
            }

            // Log cron time and message in same row
            $log->cron_run_time = (new \DateTime('now', new \DateTimeZone('Asia/Kolkata')))->format('Y-m-d H:i:s');
$log->cron_message = $message;
$log->save(false);

            echo $message . "\n";
            
            
        }
         // Save summary log
   $summary = new CronAddressUpdateSummary();
$summary->run_time =  (new \DateTime('now', new \DateTimeZone('Asia/Kolkata')))->format('Y-m-d H:i:s');
$summary->total_updated = $updatedCount;
$summary->total_failed = $failedCount;
$summary->updated_order_ids = json_encode($updatedIds); // <-- Add this
$summary->failed_order_ids = json_encode($failedIds);   // <-- And this
$summary->save(false);

echo "Cron Summary: {$updatedCount} updated, {$failedCount} failed.\n";
    }
}
