<?php

namespace console\controllers;

use Yii;
use yii\console\Controller;
use yii\filters\VerbFilter;
use backend\models\ItEasyOrder;
use backend\models\ItEasyOrderSearch;
use backend\models\ItEasyStore;
use backend\models\ItEasyProductVariation;
use backend\models\ItEasyShippingPaymentMethod;
use backend\models\ItEasyCouponHistory;
use backend\models\ItEasyState;
use backend\models\ItEasyCustomer;
use backend\models\ItEasyFinancialYear;
use backend\models\ItEasyOrderProduct;
use backend\models\ItEasyOrderStatusHistory;
use backend\models\ItEasyOrderDispositionHistory;
use backend\models\ItEasyOrderHistory;
use backend\models\ItEasyRaiseRequestSearch;
use backend\models\ItEasyRaiseRequest;
use yii2tech\spreadsheet\Spreadsheet;
use yii\data\ActiveDataProvider;
use yii\data\ArrayDataProvider;
use backend\models\ItEasyOrderDispatch;
use backend\models\ItEasyOrderTrack;
use backend\models\ItEasyOrderStatus;
use backend\models\ItEasyOrderDisposition;
use backend\models\ItEasyChanel;
use common\models\User;
use Automattic\WooCommerce\Client;

/**
 * PlatformNetworkController implements the CRUD actions for PlatformNetwork model.
 */
class FetchchannelController extends Controller
{
    
    public function actionIndex() {
        
        $shopifyOrder = ItEasyChanel::find()->where(['status' => 'Active'])->andWhere(['fetch_Type' => 'Auto'])->limit(5)->asArray()->all();
      
        if(!empty($shopifyOrder)){
            foreach($shopifyOrder as $key => $value){
                
                $url = $value['shop_url'];
                $username = $value['api_key'];
                $password = $value['api_password'];
                date_default_timezone_set("Asia/Kolkata");
                $c_date=date("Y-m-d H:i:s");
                switch ($value['channel_name']) {
                	case 'Shopify':
                		$today_date =date('Y-m-d',strtotime("-1 days"));
                        $today_time = date('H:i:s');
                        $request_url = $url."/admin/api/2020-04/orders.json?created_at_min=".$today_date."T".$today_time."&limit=250&fulfillment_status=unfulfilled";
                        $request_handle = curl_init($request_url);
                        curl_setopt($request_handle, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                        curl_setopt($request_handle, CURLOPT_USERPWD, $username . ":" . $password); 
                        curl_setopt($request_handle, CURLOPT_RETURNTRANSFER, true);
                        $request_result = curl_exec($request_handle);
                        $data_val = json_decode($request_result);
                  		// echo "<pre>"; print_r($data_val); die;
                        if(!empty($data_val->orders)) {
                            $save_data = [];
                          	$xr = 0;
                            foreach($data_val->orders as $key => $orders){
                            //   echo "<pre>"; print_r($orders); die;
                            $order_number = 's'.str_replace("#","",$orders->name);
                            $created_Date = date("Y-m-d H:i:s");
                            $created_t_date =  date("Y-m-d H:i:s", strtotime($orders->created_at));
                        
                            $addingFiveMinutes= strtotime($created_t_date.' + 25 minute');
                            $check_date = date('Y-m-d H:i:s', $addingFiveMinutes);
                            if($check_date <  $created_Date){
                            $chk_order = ItEasyOrder::find()->where(['it_easy_other_order_id' => $order_number])->asArray()->one();
                                if(empty($chk_order)){
                                    
                                    // echo "<pre>";  print_r($orders); die;
                                  	$model = new ItEasyOrder();
                                    
                                    $model->it_easy_other_order_id = 's'.str_replace("#","",$orders->name);
                                  	$model->shopify_order_id = $orders->id;
                                    if( (isset($orders->payment_gateway_names[0]) && ($orders->payment_gateway_names[0] == 'razorpay' || $orders->payment_gateway_names[0] == 'Razorpay Secure')) || (str_contains($orders->tags, 'ONLINE'))  ){
                                        $payment_mode = 'Prepaid';
                                      	$first_status = 'Prepaid';
                                        $cod_amount = $orders->total_price;
                                      	$order_status = '21';
                                    }else{
                                      	$payment_mode = 'COD';
                                      	$first_status = 'COD';
                                        $cod_amount = $orders->total_price;
                                      	$order_status = '21'; 
                                    }
                                    if((str_contains($orders->tags, 'ONLINE')) && $orders->payment_gateway_names[0] == 'shopflo'){
                                        $order_status = '1';
                                        $model->it_easy_order_disposition_id = '3';
                                        $model->it_easy_assigned_by = '1';
                                        $model->it_easy_assigned_to = '231';
                                    }else{
                                        $order_status = '21';
                                        $model->it_easy_assigned_by = '0';
                                        $model->it_easy_assigned_to = '0';
                                        $model->it_easy_order_disposition_id = '0';
                                    }
                                  	$partially_paid = $orders->total_price - $orders->total_outstanding;
                                    $total_outstanding = $orders->total_outstanding;
                                    $price = $orders->total_price;
                                  	$height = 0;
                                    $length = 0;
                                    $width = 0;
                                    $weight = 0.5;
                                  	$order_product = [];
                                  	$product_quantity = 0;
                                  	if(!empty($orders->line_items)){
                                      	foreach($orders->line_items as $key => $items){
                                          	$product_quantity +=$items->fulfillable_quantity;
                                          	$order_product[$key]['shopify_product_id'] = $items->product_id;
                                          	$order_product[$key]['shopify_variant_id'] = $items->variant_id;
                                          	$order_product[$key]['product_name'] = $items->title;
                                        if(!empty($items->variant_title)){  	$order_product[$key]['variation_name'] = $items->variant_title;
                                        }else{
                                            $order_product[$key]['variation_name'] = 'Pack of 1';
                                        }
                                          	$order_product[$key]['quantity'] = $items->fulfillable_quantity;
                                          	$order_product[$key]['price'] = $items->price;
                                        }
                                    }
                                  	$model->it_easy_product_quantity = $product_quantity;
                                  	if(!isset($orders->billing_address) || empty($orders->billing_address)){
                                      	if(isset($orders->shipping_address)){
                                          	$orders->billing_address = $orders->shipping_address;
                                          
                                        }
                                      	
                                	}
                                  	
                                  	$ipaddress = $orders->browser_ip;
                                    $get_device = $orders->device_id;
                                    $browser = ItEasyOrder::getBrowsername();
                                    $get_financial_year = ItEasyFinancialYear::getFinancialrealyear();
                                    $model->it_easy_financial_year = $get_financial_year;
                                    $model->it_easy_store_id = ItEasyStore::getStorename()->it_easy_id;
                                    $model->it_easy_store_name = ItEasyStore::getStorename()->it_easy_store_name;
                                  	if(!empty($orders->billing_address->province) && isset($orders->billing_address->province)){
                                      	
                                  		$get_state_data = ItEasyState::getStatedatabyStateName($orders->billing_address->province);
                                      	if(empty($get_state_data)){
                                          	$model->it_easy_state = 'Delhi';
                                            $model->it_easy_shipping_state = 'Delhi';
                                            $model->it_easy_billing_state = 'Delhi';
                                        }else{
                                          $model->it_easy_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_shipping_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_billing_state_id = $get_state_data->it_easy_id;
                                          $model->it_easy_state = $get_state_data->it_easy_state_name;
                                          $model->it_easy_shipping_state = $get_state_data->it_easy_state_name;
                                          $model->it_easy_billing_state = $get_state_data->it_easy_state_name;
                                        }
                                    }else{
                                      	$model->it_easy_state = 'Missing Orders';
                                        $model->it_easy_shipping_state = 'Missing Orders';
                                        $model->it_easy_billing_state = 'Missing Orders';
                                    }
                                    $get_paymentmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode($payment_mode);
                                    
                                    
                                    if(isset($orders->total_shipping_price_set->shop_money->amount) && !empty($orders->total_shipping_price_set->shop_money->amount) && ($orders->total_shipping_price_set->shop_money->amount == '50.00')){
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Flat Shipping 50 Rs.');
                                    }else if(isset($orders->total_shipping_price_set->shop_money->amount) && !empty($orders->total_shipping_price_set->shop_money->amount) && ($orders->total_shipping_price_set->shop_money->amount == '100.00')){
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Flat Shipping 100 Rs.');
                                    }else{
                                        $get_shippingmethod = ItEasyShippingPaymentMethod::getShippingbyMethodcode('Free Shipping');
                                    }
                                    
                                    
                                  	if(isset($orders->billing_address->first_name)){
                                  		$model->it_easy_firstname = $orders->billing_address->first_name;
                                      	$model->it_easy_shipping_firstname = $orders->billing_address->first_name;
                                      	$model->it_easy_billing_firstname = $orders->billing_address->first_name;
                                    }else{
                                      	$model->it_easy_firstname = '';
                                      	$model->it_easy_shipping_firstname = '';
                                      	$model->it_easy_billing_firstname = '';
                                      	
                                    }
                                    if(!empty($orders->billing_address->last_name) && isset($orders->billing_address->last_name)){
                                        $model->it_easy_lastname = $orders->billing_address->last_name;
                                        $model->it_easy_shipping_lastname = $orders->billing_address->last_name;
                                        $model->it_easy_billing_lastname = $orders->billing_address->last_name;
                                    }else{
                                        $model->it_easy_lastname = $model->it_easy_firstname;
                                        $model->it_easy_shipping_lastname = $model->it_easy_firstname;
                                        $model->it_easy_billing_lastname = $model->it_easy_firstname;
                                    }
                                    if(empty($model->it_easy_firstname)){
                                        if(empty($model->it_easy_lastname)){
                                            $model->it_easy_firstname = 'Missing Order';
                                          	$model->it_easy_shipping_firstname = 'Missing Order';
                                          	$model->it_easy_billing_firstname = 'Missing Order';
                                        }else{
                                            $model->it_easy_firstname = $orders->billing_address->last_name;
                                            $model->it_easy_shipping_firstname = $orders->billing_address->last_name;
                                            $model->it_easy_billing_firstname = $orders->billing_address->last_name;
                                        }
                                    }
                                    if(empty($model->it_easy_lastname)){
                                        $model->it_easy_lastname = 'Missing Order';
                                        $model->it_easy_shipping_lastname = 'Missing Order';
                                      	$model->it_easy_billing_lastname = 'Missing Order';
                                    }

                                    
                                    if(empty($orders->billing_address->address1) && !isset($orders->billing_address->address1)){
                                        $model->it_easy_address_1 = 'Missing-Order';
                                      	$model->it_easy_shipping_address_1 = 'Missing-Order';
                                      	$model->it_easy_billing_address_1 = 'Missing-Order';
                                    }else{
                                      	$model->it_easy_address_1 = $orders->billing_address->address1;
                                        $model->it_easy_shipping_address_1 = $orders->billing_address->address1;
                                        $model->it_easy_billing_address_1 = $orders->billing_address->address1;
                                    }
                                    
                                    if(empty($orders->billing_address->address2) && !isset($orders->billing_address->address2)){
                                        $model->it_easy_address_2 = 'Missing-Order';
                                      	$model->it_easy_shipping_address_2 = 'Missing-Order';
                                      	$model->it_easy_billing_address_2 = 'Missing-Order';
                                    }else{
                                      	$model->it_easy_address_2 = $orders->billing_address->address2;
                                        $model->it_easy_shipping_address_2 = $orders->billing_address->address2;
                                        $model->it_easy_billing_address_2 = $orders->billing_address->address2;
                                    }

                                    
                                    if(empty($orders->billing_address->city)  && !isset($orders->billing_address->city)){
                                        $model->it_easy_city = 'Missing';
                                      	$model->it_easy_shipping_city = 'Missing';
                                  		$model->it_easy_billing_city = 'Missing';
                                    }else{
                                      	$model->it_easy_city = $orders->billing_address->city;
                                        $model->it_easy_shipping_city = $orders->billing_address->city;
                                        $model->it_easy_billing_city = $orders->billing_address->city;
                                    }
                                  	
                                  	
                                    if(empty($orders->billing_address->zip) && !isset($orders->billing_address->zip)){
                                        $model->it_easy_pincode = '000000';
                                      	$model->it_easy_shipping_pincode = '000000';
                                  		$model->it_easy_billing_pincode = '000000';
                                    }else{
                                      	$model->it_easy_pincode = $orders->billing_address->zip;
                                      	$recommand =  ItEasyOrder::getServicealAPIbyPincode($model->it_easy_pincode);
                                      	
                                      	$model->it_easy_order_serviceable = $recommand;
                                        $model->it_easy_shipping_pincode = $orders->billing_address->zip;
                                        $model->it_easy_billing_pincode = $orders->billing_address->zip;
                                    }
                                    if(!empty($orders->email)){
                                        $model->it_easy_billing_email = $orders->email;
                                      	$model->it_easy_shipping_email = $orders->email;
                                      	$model->it_easy_email = $orders->email;
                                    }
                                    if(!empty($orders->billing_address->phone) && isset($orders->billing_address->phone)){
                                        $model->it_easy_mobile_number = $orders->billing_address->phone;
                                      	$model->it_easy_shipping_mobile_number = $orders->billing_address->phone;
                                      	$model->it_easy_billing_mobile = $orders->billing_address->phone;
                                    }else{
                                        $model->it_easy_mobile_number = 'MissingOrder';
                                      	$model->it_easy_shipping_mobile_number = 'MissingOrder';
                                      	$model->it_easy_billing_mobile = 'MissingOrder';
                                    }
                                    $address_model = new ItEasyOrder();
                                    $f_name = $model->it_easy_shipping_firstname.' '.$model->it_easy_lastname;
                                    $f_address = $model->it_easy_shipping_address_1.' '.$model->it_easy_shipping_address_2.' '.$model->it_easy_shipping_city;
                                    $address_validator = $address_model->getAddressValidator($f_name, $model->it_easy_shipping_email, $f_address, $model->it_easy_shipping_state, $model->it_easy_shipping_pincode, $order_number);
                                    
                                    if(!empty($address_validator)){
                                        if($address_validator->meta->status == '200'){
                                            $model->address_validator_response =     $address_validator->result->address_category.'-'.$address_validator->result->pincode_rto_risk.'-'.$address_validator->result->address_incomplete_reason;
                                        }
                                    }
                                 
                                  	$model->it_easy_ordered_amount = $price;
                                  	$model->it_easy_total_price = $price;
                                  	$model->it_easy_partially_paid = $partially_paid;
                                  	$model->it_easy_total_understanding = $total_outstanding;
                                  	$model->it_easy_gst_price = '0.00';
                                  	$model->it_easy_order_status_id = $order_status;
                                  	$model->it_easy_first_status = $first_status;
                                  	
                                  	$model->it_easy_department_id = '4';
                                    $model->it_easy_payment_method = $get_paymentmethod->it_easy_method_name;
                                    $model->it_easy_payment_code = $get_paymentmethod->it_easy_method_code;
                                    $model->it_easy_shipping_method = $get_shippingmethod->it_easy_method_name;
                                    $model->it_easy_shipping_code = $get_shippingmethod->it_easy_method_code;
                                    $model->it_easy_country = 'IN';
                                    $model->it_easy_shipping_country = 'IN';
                                    $model->it_easy_billing_country = 'IN';
                                    
                                    $model->it_easy_server_ip = $ipaddress;
                                    $model->it_easy_device = $get_device;
                                    $model->it_easy_browser = $browser;
                                  	$model->it_easy_created_time = date("Y-m-d H:i:s", strtotime($orders->created_at));
                                  	
                                    $live_users = User::find()->where(['login_status' => '1'])->andwhere(['it_easy_dept_id' => '4'])->andwhere(['or', ['it_easy_type_id' => '4'], ['it_easy_type_id' => '5'],  ['it_easy_type_id' => '3']])->all();
                                  	$count_user = count($live_users);
                                //   	if($xr == $count_user){
                                //       	$xr = 0;
                                //     }
                                //   	foreach($live_users as $key => $live_user){
                                //         if($xr == $key){
                                //             $model->it_easy_assigned_by = '1';
                                //             $model->it_easy_assigned_to = $live_user->id;
                                //         }
                                //     }
                                
                                
                                  	if($model->it_easy_mobile_number == 'MissingOrder'){
                                      	$model->it_easy_customer_id = '0';
                                    }else{
                                      	$find_customer_data = ItEasyCustomer::FindCustomerbyMobile($model->it_easy_mobile_number);
                                    }
                                  	$model->save(false);
                                  
                                  	if(empty($find_customer_data)){
                                        $find_customer_data = ItEasyCustomer::SavecustomerModelFromMobileArray($model, $model->it_easy_order_id);
                                        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                                    }else{

                                        $model->it_easy_customer_id = $find_customer_data->it_easy_customer_id;
                                        if(!empty($find_customer_data->it_easy_order_ids)){
                                            $customer_it_easy_order_ids = explode(',', $find_customer_data->it_easy_order_ids);
                                            if (!in_array($model->it_easy_order_id, $customer_it_easy_order_ids)){
                                                $find_customer_data->it_easy_order_ids = $find_customer_data->it_easy_order_ids.','.$model->it_easy_order_id;
                                                $find_customer_data->save();
                                            }
                                        }
                                    }
                                  	$it_easy_gst_price = 0;
                                  	$it_easy_total_price = 0;
                                  	$quantity_order = 0;
                                  	foreach ($order_product as $key => $value_product) {
                                      	
                                      	
                                      	$check_product_data = ItEasyProductVariation::find()->where(['shopify_product_id' => $value_product['shopify_product_id']])->andWhere(['shopify_veriant_id' =>$value_product['shopify_variant_id'] ])->andWhere(['it_easy_status' => 'Active'])->asArray()->one();
                                      	
                                      	
                                      	
                                      	
                                      	
                                      	
                                      	$quantity_order += $value_product['quantity'];
                                      		
                                        
                                        $orderProductModel = new ItEasyOrderProduct();
                                        $orderProductModel->it_easy_order_id = $model->it_easy_order_id;
                                        
                                        if(!empty($check_product_data)){
                                            $orderProductModel->it_easy_product_id = $check_product_data['it_easy_product_id'];
                                                $orderProductModel->it_easy_variation_id = $check_product_data['it_easy_variation_id'];
                                                $orderProductModel->it_easy_product_name = $check_product_data['it_easy_product_name']; 
                                                $orderProductModel->it_easy_variation_name = $check_product_data['it_easy_variation_name'];
                                        }else{
                                        
                                        switch ($value_product['product_name']) {
                                              case "Ashwagandha with Tribulus Terrestris":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '2';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name']; 
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                              case "Nutriherbs Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                case "Ashwagandha with Tribulus Terrestris 60 capsule Pack 1":
                                                $orderProductModel->it_easy_product_id = '28';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (15 Sachets)":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food ( Sachets )":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "NutriHerbs Glow Builder with the Blend of 48 Super Food (30 Sachets)":
                                                $orderProductModel->it_easy_product_id = '1';
                                                if($value_product['variation_name'] == '15 Sachets'){
                                                $orderProductModel->it_easy_variation_id = '8';
                                                }else if($value_product['variation_name'] == '30 Sachets'){
                                                    $orderProductModel->it_easy_variation_id = '9';
                                                }else if($value_product['variation_name'] == '60 sachets'){
                                                    $orderProductModel->it_easy_variation_id = '10';
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '8';
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E & Grape Seed Extract":
                                                $orderProductModel->it_easy_product_id = '3';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs L Glutathione Capsules With Vitamin C, E &amp; Grape Seed Extract":
                                                $orderProductModel->it_easy_product_id = '3';
                                                $orderProductModel->it_easy_variation_id = '2';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit with Ashwagandha (60 Caps)":
                                                $orderProductModel->it_easy_product_id = '11';
                                                $orderProductModel->it_easy_variation_id = '11';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Pure Shilajit Resin with Kesar":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 3)":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin with Kesar-15gm (Pack of 2)":
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Nutriherbs Shilajit Resin":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                
                                                case "Nutriherbs Shilajit Resin-15gm":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Shilajit Resin":
                                                
                                                if($value_product['variation_name'] == 'kesar Flavour : 15 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 15 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 30 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                }else if($value_product['variation_name'] == 'kesar Flavour : 30 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '6';
                                                }else if($value_product['variation_name'] == 'kesar Flavour : 45 gm'){    
                                                $orderProductModel->it_easy_product_id = '5';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                }else if($value_product['variation_name'] == 'Normal Flavour: 45 gm'){    
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '7';
                                                }else{
                                                  $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';   
                                                }
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                        
                                                
                                              case "Shilajit Resin Pack of 1":
                                                $orderProductModel->it_easy_product_id = '26';
                                                $orderProductModel->it_easy_variation_id = '5';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                break;
                                                
                                                case "Skin Glow Tablets":
                                                $orderProductModel->it_easy_product_id = '204';
                                                if($value_product['variation_name'] == 'Orange' ){
                                                    $orderProductModel->it_easy_variation_id = '41';
                                                    $orderProductModel->it_easy_product_name = "(NH) Skin Glow ) Orange flavour";
                                                    $orderProductModel->it_easy_variation_name = "Tablet-15";
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '41';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                }
                                                
                                                
                                                
                                                break;
                                                
                                                
                                                case "Original Shilajit Resin Ashwagold - 10 gram":
                                                $orderProductModel->it_easy_product_id = '190';
                                                if($value_product['variation_name'] == '10 Gram' ){
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                    $orderProductModel->it_easy_product_name = "(NH) Pure Shilajit Resin Ashwagold  - Trail Pack (Prepaid)";
                                                    $orderProductModel->it_easy_variation_name = "10gm";
                                                }else if($value_product['variation_name'] == '20 Gram' ){
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                    $orderProductModel->it_easy_product_name = "(NH) Pure Shilajit Resin Ashwagold  - Trail Pack (Prepaid)";
                                                    $orderProductModel->it_easy_variation_name = "20gm";
                                                }else{
                                                    $orderProductModel->it_easy_variation_id = '34';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                                }
                
                                                break;
                                                
                                                
                                              default:
                                                $orderProductModel->it_easy_product_id = '0';
                                                $orderProductModel->it_easy_variation_id = '1';
                                                $orderProductModel->it_easy_product_name = $value_product['product_name'];
                                                $orderProductModel->it_easy_variation_name = $value_product['variation_name'];
                                            }
                                            
                                            
                                        }    
                                            
                                            
                                        $product_variation = ItEasyProductVariation::find()->where(['it_easy_product_name' => $orderProductModel->it_easy_product_name])
                                          												   ->andWhere(['it_easy_variation_name' => $orderProductModel->it_easy_variation_name])
                                          												   ->asArray()->one();
                                      	if(empty($product_variation)){
                                          	$product_variation['it_easy_product_id'] = 0;
                                          	$product_variation['it_easy_variation_id'] = 0;
                                          	$product_taxe = 0;
                                          	$t_product_price = $value_product['price'] * $value_product['quantity'];
                                          	$it_easy_total_price += $value_product['price'] * $value_product['quantity'];
                                          	$it_easy_gst_price +=0;
                                          	$product_variation_price = $value_product['price'] * $value_product['quantity'];
                                        }else{
                                            
            $p_data = ItEasyOrder::FindProductbyid($product_variation['it_easy_product_id']);
            // echo "<pre>"; print_r($p_data); die;
            $p_data_tax_percentage = $p_data->it_easy_product_tax;
            if(!empty($p_data_tax_percentage)){
                $tax_price_p = ROUND((($value_product['price'] * $value_product['quantity']) * $p_data_tax_percentage )/100, 2);
            }else{
                $tax_price_p = ROUND((($value_product['price'] * $value_product['quantity']) * 12 )/100, 2);
            }
                                            
                                            
                                            
                                            if(!empty($value_product['quantity'])){
                                            $one_bottle_price = $value_product['price'] * $value_product['quantity']/$value_product['quantity'];
                                            }else{
                                                $one_bottle_price = '0';
                                            }
                                          	$product_taxe = $value_product['quantity'] * $tax_price_p;
                                            $t_product_price = $one_bottle_price * $value_product['quantity'];
                                            $it_easy_total_price +=  $t_product_price;
                                            $it_easy_gst_price += $product_taxe;
                                        
                                        $price_without_tax_1 =   $t_product_price -  $product_taxe;
                                          	$product_variation_price = $price_without_tax_1 * $value_product['quantity'];
                                        }    
                                        
                                        $orderProductModel->it_easy_product_sku = $value_product['product_name'];
                                        
                                        $orderProductModel->it_easy_product_quantity = $value_product['quantity'];
                                        $orderProductModel->it_easy_product_total = $t_product_price;
                                        $orderProductModel->it_easy_product_price = $product_variation_price;
                                        $orderProductModel->it_easy_product_tax = $product_taxe;
                                        $orderProductModel->created_time = date('Y-m-d H:i:s');
                                        $orderProductModel->save();
                                           
                                  	}
                                  
                                  	$model->it_easy_total_price = $it_easy_total_price;
                                    $model->it_easy_gst_price = $it_easy_gst_price;
                                    if(!empty($orders->note)){
                                        $model->it_easy_marketer_publisher = 'Funnelish_'.$orders->note;
                                    }else if(!empty($orders->tags)){
                                        $model->it_easy_marketer_publisher = str_replace(", ","_",$orders->tags);
                                    }else if(!empty($orders->landing_site_ref)){
                                        $model->it_easy_marketer_publisher = $orders->landing_site_ref;
                                    }else{
                                        $model->it_easy_marketer_publisher = 'Direct';
                                    }
                                    $model->it_easy_product_quantity = $quantity_order;
                                    
                                    
                                    $model->save(false); 
                                    $model->it_easy_order_number = 'NH'.$model->it_easy_order_id;
                                    $model->it_easy_invoice_number = 'NH-'.$get_financial_year.'-'.$model->it_easy_order_id;
                                    $model->save(false); 
                                  
                                  	$xr++;
                                }  
                                }
                            }
                            
                            
                        }
                		break;
                		
                /*	case 'Woocommerce':
                  
                  
                		$today_date =date('Y-m-d',strtotime("-1 days"));
                        $today_time = date('H:i:s');
                        
                        $woocommerce = new Client(
                            $url, 
                            $username, 
                            $password,
                            [
                                'version' => 'wc/v1',
                            ]
                        );
                        $order_list = $woocommerce->get('orders', $parameters = ['after' => $today_date."T".$today_time]);
                
                        if(empty($order_list)){
                            $message = 'Order value null';
                        }
                        if(!empty($order_list)) {
                            $save_data = [];
                            foreach($order_list as $key => $orders){
                            $order_number = 'wooco'.$orders->id;
                            $chk_order = SolLogisOrders::find()->where(['vendor_id' => $user_id, 'extra_id' => $order_number])->asArray()->one();
                            if(empty($chk_order)){
                                $pincode = $orders->shipping->postcode;
                                $shipping_priority = SolLogisShippingPriority::find()->where(['user_id' => $user_id])->andWhere(['status' => 'Active'])->orderBy(['seq' => SORT_ASC])->asArray()->all();
                                if(!empty($shipping_priority)){
                                    $count_ship = count($shipping_priority);
                                    if($count_ship == '1'){
                                        if($shipping_priority[0]['shipping_id'] == '2'){
                                        
                                            
                                            $pincode_check = SolLogisDelhiveryPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '2';
                                                $courier_name = 'Delhivery_Express'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '4'){
                                        
                                            
                                            $pincode_check = SolLogisShipdelightPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '4';
                                                $courier_name = 'shipdelight'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '6'){
                                            
                                            
                                            $pincode_check = SolLogisXpressbeesPincodes::find()->where(['Pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '6';
                                                $courier_name = 'xpressbess';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '7'){
                                            
                                            
                                            $pincode_check = SolLogisEkartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '7';
                                                $courier_name = 'Ekart';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '8'){
                                            
                                            
                                            $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '8';
                                                $courier_name = 'Shadowfax';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($shipping_priority[0]['shipping_id'] == '9'){
                                            
                                            
                                            $pincode_check = SolLogisBluedartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $shipping_id = '9';
                                                $courier_name = 'Bluedart';
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($ship_choose['shipping_id'] == '10'){
                                                $pincode_check = SolLogisDelhiverysurfacePincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '10';
                                                    $courier_name = 'Delhivery_Surface';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }
                                    }else{
                                        
                                        $x = 0;
                                        foreach($shipping_priority as $ship_choose){
                                            if($x == 1){
                                                break;
                                            }
                                            
                                            if($shipping_priority[0]['shipping_id'] == '2'){
                                        
                                            
                                            $pincode_check = SolLogisDelhiveryPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                            if(!empty($pincode_check)){
                                                $x = 1;
                                                $shipping_id = '2';
                                                $courier_name = 'Delhivery_Express'; 
                                            }else{
                                                $shipping_id = '';
                                            }
                                        }else if($ship_choose['shipping_id'] == '4'){
                                                $pincode_check = SolLogisShipdelightPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                if(!empty($pincode_check)){
                                                    $x = 1;
                                                    $shipping_id = '4';
                                                    $courier_name = 'shipdelight';
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '6'){
                                                $pincode_check = SolLogisXpressbeesPincodes::find()->where(['Pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '6';
                                                    $courier_name = 'xpressbees';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '7'){
                                                $pincode_check = SolLogisEkartPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '7';
                                                    $courier_name = 'Ekart';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = ''; 
                                                }
                                            }else if($ship_choose['shipping_id'] == '8'){
                                                $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '8';
                                                    $courier_name = 'Shadowfax';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '9'){
                                                $pincode_check = SolLogisShadowfaxPincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '9';
                                                    $courier_name = 'Bluedart';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }else if($ship_choose['shipping_id'] == '10'){
                                                $pincode_check = SolLogisDelhiverysurfacePincodes::find()->where(['pincode' => $pincode])->asArray()->one();
                                                
                                                if(!empty($pincode_check)){
                                                    $shipping_id = '10';
                                                    $courier_name = 'Delhivery_Surface';
                                                    $x = 1;
                                                }else{
                                                     $shipping_id = '';
                                                }
                                            }
                                        }
                                    }
                                    if($orders->payment_method == 'cod'){
                                        $payment_mode = 'COD';
                                        $cod_amount = $orders->total;
                                    }else{
                                        $payment_mode = 'Prepaid';
                                        $cod_amount = 0;
                                    }
                                    $product_name = '';
                                    $product_descrition = '';
                                    $quantity = 0;
                                    $price = $orders->total;
                                    $height = 0;
                                    $length = 0;
                                    $width = 0;
                                    $weight = 0.5;
                                    $order_status = 'Pending_order'; 
                                    
                                    
                                    
                                    foreach($orders->line_items as $key => $product){
                                        $product_name .= $product->name;
                                        $product_descrition .= $product->name;
                                        $quantity += $product->quantity;
                                        
                                    }
                                    if(!empty($shipping_id)){
                                        $save_data[] = [$order_number, $orders->id, $shipping_id, $user_id, $orders->id, $payment_mode, $orders->shipping->first_name, $orders->shipping->last_name, $orders->shipping->address_1, $orders->shipping->address_2, $orders->shipping->city, $orders->shipping->state, $orders->shipping->postcode, $orders->billing->phone, $orders->billing->phone, $product_name, $product_descrition, $quantity, $price, $cod_amount, $height, $length, $width, $weight, $courier_name, $order_status, $c_date, '1'];
                                    }
                                }
                            
                            }
                            }
                            
                            $user_Detail = User::findOne(['id' => $user_id]);
                            if($user_Detail->wallet_user_type == 'Prepaid'){
                                $count_shipment = count($save_data);
                                $amount_for_shipment = $count_shipment * 100;
                                if($user_Detail->wallet_amount < $amount_for_shipment){
                                    if(!empty($save_data)){
                                        Yii::$app->db->createCommand()->batchInsert('sol_logis_orders', ['extra_id', 'order_number', 'shipping_id', 'vendor_id', 'transaction_id', 'payment_mode', 'customer_firstname', 'customer_lastname', 'address_1', 'address_2', 'city', 'state', 'postcode', 'mobile', 'alternate_number', 'product_name', 'item_description', 'quantity', 'price', 'collective_price', 'height', 'length', 'width', 'weight', 'courier_name', 'order_status', 'created_time', 'created_by'], $save_data)->execute();
                                    }
                                }
                            }else{
                                if(!empty($save_data)){
                                    Yii::$app->db->createCommand()->batchInsert('sol_logis_orders', ['extra_id','order_number', 'shipping_id', 'vendor_id', 'transaction_id', 'payment_mode', 'customer_firstname', 'customer_lastname', 'address_1', 'address_2', 'city', 'state', 'postcode', 'mobile', 'alternate_number', 'product_name', 'item_description', 'quantity', 'price', 'collective_price', 'height', 'length', 'width', 'weight', 'courier_name', 'order_status', 'created_time', 'created_by'], $save_data)->execute();
                                }
                            }
                        }
                        
                        
                        
                		break;	 
                	
                	default:
                	    
                		break; */
                }
                
                
                
                 
                
            }
        }
    } 
}